/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeDAO;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.AVMStoreDAO;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.LookupComponent;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Lookup
implements Serializable {
    private static final long serialVersionUID = -2844833688622561L;
    private static Log logger = LogFactory.getLog(Lookup.class);
    private boolean fValid = true;
    private AVMStore fAVMStore;
    private String fStoreName;
    private List<LookupComponent> fComponents;
    private AVMStore fFinalStore;
    private boolean fLayeredYet;
    private boolean fDirectlyContained;
    private LayeredDirectoryNode fTopLayer;
    private int fTopLayerIndex;
    private int fLowestLayerIndex;
    private int fPosition;
    private boolean fNeedsCopying;
    private int fVersion;

    public Lookup(Lookup other, AVMNodeDAO nodeDAO, AVMStoreDAO storeDAO) {
        this.fAVMStore = storeDAO.getByID(other.fAVMStore.getId());
        this.fVersion = other.fVersion;
        if (this.fAVMStore == null) {
            this.fValid = false;
            return;
        }
        this.fStoreName = this.fAVMStore.getName();
        this.fComponents = new ArrayList<LookupComponent>();
        this.fLayeredYet = other.fLayeredYet;
        if (other.fTopLayer != null) {
            this.fTopLayer = (LayeredDirectoryNode)nodeDAO.getByID(other.fTopLayer.getId());
            if (this.fTopLayer == null) {
                this.fValid = false;
                return;
            }
        }
        this.fPosition = other.fPosition;
        this.fTopLayerIndex = other.fTopLayerIndex;
        this.fLowestLayerIndex = other.fLowestLayerIndex;
        this.fNeedsCopying = other.fNeedsCopying;
        this.fDirectlyContained = other.fDirectlyContained;
        if (this.fLayeredYet) {
            for (LookupComponent comp : other.fComponents) {
                LookupComponent newComp = new LookupComponent();
                newComp.setName(comp.getName());
                newComp.setIndirection(comp.getIndirection());
                newComp.setIndirectionVersion(comp.getIndirectionVersion());
                newComp.setNode(nodeDAO.getByID(comp.getNode().getId()));
                if (newComp.getNode() == null) {
                    this.fValid = false;
                    return;
                }
                this.fComponents.add(newComp);
            }
        } else {
            LookupComponent newComp;
            LookupComponent comp;
            int i;
            for (i = 0; i < this.fPosition; ++i) {
                comp = other.fComponents.get(i);
                newComp = new LookupComponent();
                newComp.setName(comp.getName());
                this.fComponents.add(newComp);
            }
            comp = other.fComponents.get(i);
            newComp = new LookupComponent();
            newComp.setName(comp.getName());
            newComp.setNode(nodeDAO.getByID(comp.getNode().getId()));
            if (newComp.getNode() == null) {
                this.fValid = false;
                return;
            }
            this.fComponents.add(newComp);
        }
        this.fFinalStore = storeDAO.getByID(other.fFinalStore.getId());
        if (this.fFinalStore == null) {
            this.fValid = false;
        }
    }

    public Lookup(AVMStore store, String storeName, int version) {
        this.fAVMStore = store;
        this.fStoreName = storeName;
        this.fVersion = version;
        this.fComponents = new ArrayList<LookupComponent>();
        this.fLayeredYet = false;
        this.fTopLayer = null;
        this.fPosition = -1;
        this.fTopLayerIndex = -1;
        this.fLowestLayerIndex = -1;
        this.fNeedsCopying = false;
        this.fDirectlyContained = true;
        this.fFinalStore = store;
    }

    public boolean isValid() {
        return this.fValid;
    }

    public void add(AVMNode node, String name, boolean directlyContained, boolean write) {
        LookupComponent comp = new LookupComponent();
        comp.setName(name);
        comp.setNode(node);
        if (this.fPosition >= 0 && this.fDirectlyContained && this.getCurrentNode().getType() == 3) {
            this.fDirectlyContained = directlyContained;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("add: fDirectlyContained = " + directlyContained));
            }
        }
        if (!write) {
            if (node.getType() == 3) {
                LayeredDirectoryNode oNode = (LayeredDirectoryNode)node;
                if (oNode.getPrimaryIndirection()) {
                    comp.setIndirection(oNode.getIndirection());
                    comp.setIndirectionVersion(oNode.getIndirectionVersion());
                } else {
                    Pair<String, Integer> ind = this.computeIndirection(name);
                    comp.setIndirection((String)ind.getFirst());
                    comp.setIndirectionVersion((Integer)ind.getSecond());
                }
                this.fLayeredYet = true;
                if (this.fTopLayer == null) {
                    this.fTopLayer = oNode;
                    this.fTopLayerIndex = this.fPosition + 1;
                }
                this.fLowestLayerIndex = this.fPosition + 1;
            }
            this.fComponents.add(comp);
            ++this.fPosition;
            return;
        }
        if (!node.getIsNew()) {
            this.fNeedsCopying = true;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("add-cow: " + this + " (" + this.fPosition + ") (not new)"));
            }
        } else if (this.fPosition >= 0 && !this.fDirectlyContained) {
            this.fNeedsCopying = true;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("add: COW: " + this + " (" + this.fPosition + ") (new, not directly contained)"));
            }
        }
        if (node.getType() == 3) {
            LayeredDirectoryNode oNode = (LayeredDirectoryNode)node;
            if (oNode.getPrimaryIndirection()) {
                comp.setIndirection(oNode.getIndirection());
                comp.setIndirectionVersion(-1);
            } else {
                Pair<String, Integer> ind = this.computeIndirection(name);
                comp.setIndirection((String)ind.getFirst());
                comp.setIndirectionVersion(-1);
            }
            this.fLayeredYet = true;
            if (this.fTopLayer == null) {
                this.fTopLayer = oNode;
                this.fTopLayerIndex = this.fPosition + 1;
            }
            this.fLowestLayerIndex = this.fPosition + 1;
        } else if (this.fLayeredYet) {
            Pair<String, Integer> ind = this.computeIndirection(name);
            comp.setIndirection((String)ind.getFirst());
            comp.setIndirectionVersion(-1);
        }
        this.fComponents.add(comp);
        ++this.fPosition;
        if (this.fNeedsCopying) {
            node = node.copy(this);
            this.getCurrentLookupComponent().setNode(node);
            if (this.fPosition == 0) {
                this.fAVMStore.setNewRoot((DirectoryNode)node);
                ((DirectoryNode)node).setIsRoot(true);
                AVMDAOs.Instance().fAVMNodeDAO.update((DirectoryNode)node);
                AVMDAOs.Instance().fAVMStoreDAO.update(this.fAVMStore);
                return;
            }
            if (this.fPosition == this.fTopLayerIndex) {
                this.fTopLayer = (LayeredDirectoryNode)node;
            }
            ((DirectoryNode)this.fComponents.get(this.fPosition - 1).getNode()).putChild(name, node);
        }
    }

    private Pair<String, Integer> computeIndirection(String name) {
        String parentIndirection = this.getCurrentIndirection();
        int parentIndirectionVersion = this.getCurrentIndirectionVersion();
        if (parentIndirection.endsWith("/")) {
            return new Pair((Object)(parentIndirection + name), (Object)parentIndirectionVersion);
        }
        return new Pair((Object)(parentIndirection + "/" + name), (Object)parentIndirectionVersion);
    }

    public DirectoryNode getCurrentNodeDirectory() {
        int position = this.fPosition - 1;
        if (position >= 0 && position < this.fComponents.size()) {
            return (DirectoryNode)this.fComponents.get(this.fPosition - 1).getNode();
        }
        return null;
    }

    private LookupComponent getCurrentLookupComponent() {
        return this.fComponents.get(this.fPosition);
    }

    public AVMNode getCurrentNode() {
        return this.getCurrentLookupComponent().getNode();
    }

    public boolean isLayered() {
        return this.fLayeredYet;
    }

    public boolean isInThisLayer() {
        return this.fLayeredYet && this.fDirectlyContained;
    }

    public int size() {
        return this.fComponents.size();
    }

    public String getIndirectionPath() {
        int pos = this.fLowestLayerIndex;
        AVMNode node = this.fComponents.get(pos).getNode();
        LayeredDirectoryNode oNode = null;
        while (!(pos < this.fTopLayerIndex || node.getType() == 3 && (oNode = (LayeredDirectoryNode)node).getLayerID() == this.fTopLayer.getLayerID() && oNode.getPrimaryIndirection())) {
            node = this.fComponents.get(--pos).getNode();
        }
        oNode = (LayeredDirectoryNode)node;
        StringBuilder builder = new StringBuilder();
        builder.append(oNode.getIndirection());
        for (int i = pos + 1; i <= this.fPosition; ++i) {
            builder.append("/");
            builder.append(this.fComponents.get(i).getName());
        }
        return builder.toString();
    }

    public String getCurrentIndirection() {
        return this.getCurrentLookupComponent().getIndirection();
    }

    public int getCurrentIndirectionVersion() {
        return this.getCurrentLookupComponent().getIndirectionVersion();
    }

    public LayeredDirectoryNode getTopLayer() {
        return this.fTopLayer;
    }

    public AVMStore getAVMStore() {
        return this.fAVMStore;
    }

    public String getRepresentedPath() {
        if (this.fComponents.size() == 1) {
            return AVMUtil.buildAVMPath(this.fStoreName, "/");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.fStoreName);
        builder.append(':');
        int count = this.fComponents.size();
        for (int i = 1; i < count; ++i) {
            builder.append('/');
            builder.append(this.fComponents.get(i).getName());
        }
        return builder.toString();
    }

    public String getBaseName() {
        return this.getCurrentLookupComponent().getName();
    }

    public void setFinalStore(AVMStore store) {
        this.fFinalStore = store;
    }

    public AVMStore getFinalStore() {
        return this.fFinalStore;
    }

    public boolean getDirectlyContained() {
        return this.fDirectlyContained;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRepresentedPath());
        builder.append(" [");
        for (int i = 0; i < this.fComponents.size(); ++i) {
            builder.append('/');
            builder.append(this.fComponents.get(i).toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

