/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMRevertListAction
extends ActionExecuterAbstractBase {
    private static Log fgLogger = LogFactory.getLog(AVMRevertListAction.class);
    public static final String NAME = "avm-revert-list";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_NODE_LIST = "node-list";
    private AVMSyncService fSyncService;

    public void setAvmSyncService(AVMSyncService service) {
        this.fSyncService = service;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        int revertVersion = (Integer)action.getParameterValue(PARAM_VERSION);
        List paths = (List)((Object)action.getParameterValue(PARAM_NODE_LIST));
        ArrayList<AVMDifference> diffs = new ArrayList<AVMDifference>();
        for (String path : paths) {
            List<AVMDifference> diffSet = this.fSyncService.compare(revertVersion, path, -1, path, null);
            diffs.addAll(diffSet);
        }
        String message = "Reverted to version " + revertVersion;
        this.fSyncService.update(diffs, null, false, false, true, true, message, message);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_VERSION, DataTypeDefinition.INT, true, this.getParamDisplayLabel(PARAM_VERSION)));
        paramList.add(new ParameterDefinitionImpl(PARAM_NODE_LIST, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_NODE_LIST)));
    }
}

