/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMRevertToVersionAction
extends ActionExecuterAbstractBase {
    private static Log fgLogger = LogFactory.getLog(AVMRevertToVersionAction.class);
    public static final String NAME = "avm-revert-to-version";
    public static final String TOREVERT = "to-revert";
    private AVMService fAVMService;

    public void setAvmService(AVMService service) {
        this.fAVMService = service;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(actionedUponNodeRef);
        AVMNodeDescriptor toRevertTo = (AVMNodeDescriptor)action.getParameterValue(TOREVERT);
        this.fAVMService.revert((String)versionPath.getSecond(), toRevertTo);
        String[] storePath = AVMUtil.splitPath((String)versionPath.getSecond());
        this.fAVMService.createSnapshot(storePath[0], null, "Reverted " + (String)versionPath.getSecond() + " to version " + toRevertTo.getVersionID());
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(TOREVERT, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(TOREVERT)));
    }
}

