/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.locking;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.util.BulkLoader;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingException;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.remote.RepoRemote;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.springframework.context.ApplicationContext;

public class AVMLockingServiceTest
extends TestCase {
    private static String[] TESTUSERS = new String[]{"Buffy", "Willow", "Xander", "Tara", "Spike"};
    private static String[] TESTAUTHORITIES = new String[]{"GROUP_Scoobies", "ROLE_SUPER_POWERED", "GROUP_vampires"};
    private ApplicationContext ctx = null;
    private static AVMLockingService lockingService;
    private static AVMService avmService;
    private static AVMSyncService syncService;
    private static PersonService personService;
    private static AuthorityService authorityService;
    private static MutableAuthenticationService authenticationService;
    private static NodeService nodeService;
    private static RepoRemote repoRemoteService;
    private static final String testWP1;
    private NodeRef testWP1NodeRef;
    private static final Map<String, String> EMPTY_MAP;

    protected void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        lockingService = (AVMLockingService)this.ctx.getBean("AVMLockingService");
        avmService = (AVMService)this.ctx.getBean("AVMLockingAwareService");
        syncService = (AVMSyncService)this.ctx.getBean("AVMSyncService");
        personService = (PersonService)this.ctx.getBean("PersonService");
        authorityService = (AuthorityService)this.ctx.getBean("AuthorityService");
        authenticationService = (MutableAuthenticationService)this.ctx.getBean("AuthenticationService");
        nodeService = (NodeService)this.ctx.getBean("NodeService");
        repoRemoteService = (RepoRemote)this.ctx.getBean("RepoRemoteService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        NodeRef root = repoRemoteService.getRoot();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(WCMAppModel.PROP_AVMSTORE, testWP1);
        this.testWP1NodeRef = nodeService.createNode(root, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)testWP1), WCMAppModel.TYPE_AVMWEBFOLDER, properties).getChildRef();
        this.cleanUsersAndGroups();
        authenticationService.createAuthentication("Buffy", "Buffy".toCharArray());
        personService.getPerson("Buffy");
        authorityService.createAuthority(AuthorityType.GROUP, "Scoobies");
        authorityService.addAuthority("GROUP_Scoobies", "Buffy");
        authorityService.createAuthority(AuthorityType.ROLE, "SUPER_POWERED");
        authorityService.addAuthority("ROLE_SUPER_POWERED", "Buffy");
        authenticationService.createAuthentication("Willow", "Willow".toCharArray());
        personService.getPerson("Willow");
        authorityService.addAuthority("GROUP_Scoobies", "Willow");
        authenticationService.createAuthentication("Xander", "Xander".toCharArray());
        personService.getPerson("Xander");
        authorityService.addAuthority("GROUP_Scoobies", "Xander");
        authenticationService.createAuthentication("Tara", "Tara".toCharArray());
        personService.getPerson("Tara");
        authenticationService.createAuthentication("Spike", "Spike".toCharArray());
        personService.getPerson("Spike");
        authorityService.addAuthority("ROLE_SUPER_POWERED", "Spike");
        authorityService.createAuthority(AuthorityType.GROUP, "vampires");
        authorityService.addAuthority("GROUP_vampires", "Spike");
    }

    protected void tearDown() throws Exception {
        lockingService.removeLocks(testWP1);
        this.cleanUsersAndGroups();
        nodeService.deleteNode(this.testWP1NodeRef);
    }

    private void cleanUsersAndGroups() {
        for (String testUser : TESTUSERS) {
            if (authenticationService.authenticationExists(testUser)) {
                authenticationService.deleteAuthentication(testUser);
            }
            if (!personService.personExists(testUser)) continue;
            personService.deletePerson(testUser);
        }
        for (String testAuthority : TESTAUTHORITIES) {
            if (!authorityService.authorityExists(testAuthority)) continue;
            authorityService.deleteAuthority(testAuthority);
        }
    }

    public void testAll() throws Exception {
        lockingService.lock(testWP1, "Revello Drive/1630", TESTUSERS[0], EMPTY_MAP);
        AVMLockingServiceTest.assertEquals((String)lockingService.getLockOwner(testWP1, "Revello Drive/1630"), (String)TESTUSERS[0]);
        lockingService.removeLock(testWP1, "Revello Drive/1630");
        AVMLockingServiceTest.assertNull((Object)lockingService.getLockOwner(testWP1, "Revello Drive/1630"));
        lockingService.lock(testWP1, "UC Sunnydale/Stevenson Hall", TESTUSERS[0], EMPTY_MAP);
        AVMLockingServiceTest.assertEquals((String)lockingService.getLockOwner(testWP1, "UC Sunnydale/Stevenson Hall"), (String)TESTUSERS[0]);
        try {
            lockingService.lock(testWP1, "UC Sunnydale/Stevenson Hall", TESTUSERS[1], EMPTY_MAP);
            AVMLockingServiceTest.fail((String)"Failed to detect existing lock");
        }
        catch (AVMLockingException aVMLockingException) {
            // empty catch block
        }
    }

    public void testRoleBasedLocking() {
        Map<String, String> lockData = Collections.singletonMap("avm-store-name", "Sunnydale");
        lockingService.lock(testWP1, "TheInitiative/Adam/plans.txt", TESTAUTHORITIES[1], lockData);
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Xander"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Xander"));
    }

    public void testGroupBasedLocking() {
        Map<String, String> lockData = Collections.singletonMap("avm-store-name", "Sunnydale");
        lockingService.lock(testWP1, "TheInitiative/Adam/plans.txt", TESTAUTHORITIES[0], lockData);
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Xander"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Xander"));
    }

    public void testLockModification() {
        Map<String, String> lockData = Collections.singletonMap("avm-store-name", "Sunnydale");
        lockingService.lock(testWP1, "TheInitiative/Adam/plans.txt", TESTAUTHORITIES[0], lockData);
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/TheInitiative/Adam/plans.txt", "Xander"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/TheInitiative/Adam/plans.txt", "Xander"));
        lockData = Collections.singletonMap("avm-store-name", "Sunnydale");
        lockingService.modifyLock(testWP1, "TheInitiative/Adam/plans.txt", TESTAUTHORITIES[0], testWP1, "ScrapHeap/Adam/plans.txt", lockData);
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Xander"));
        lockData = Collections.singletonMap("avm-store-name", "LA");
        lockingService.modifyLock(testWP1, "ScrapHeap/Adam/plans.txt", TESTAUTHORITIES[0], testWP1, "ScrapHeap/Adam/plans.txt", lockData);
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "LA:/ScrapHeap/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/ScrapHeap/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "LA:/ScrapHeap/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "LA:/ScrapHeap/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess(testWP1, "LA:/ScrapHeap/Adam/plans.txt", "Xander"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Buffy"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Spike"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Willow"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Tara"));
        AVMLockingServiceTest.assertFalse((boolean)lockingService.hasAccess(testWP1, "Sunnydale:/ScrapHeap/Adam/plans.txt", "Xander"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockingAwareService() throws Exception {
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            if (avmService.getStore("main") == null) {
                avmService.createStore("main");
            }
            avmService.setStoreProperty("main", SandboxConstants.PROP_WEB_PROJECT_NODE_REF, new PropertyValue(DataTypeDefinition.NODE_REF, (Serializable)new NodeRef("workspace://SpacesStore/dummy")));
            if (avmService.getStore("main--admin") == null) {
                avmService.createStore("main--admin");
            }
            this.setupBasicTree0();
            List<AVMDifference> diffs = syncService.compare(-1, "main:/", -1, "main--admin:/", null);
            AVMLockingServiceTest.assertEquals((int)2, (int)diffs.size());
            AVMLockingServiceTest.assertEquals((String)"[main:/a[-1] > main--admin:/a[-1], main:/d[-1] > main--admin:/d[-1]]", (String)diffs.toString());
            syncService.update(diffs, null, false, false, false, false, null, null);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    BulkLoader loader = new BulkLoader();
                    loader.setAvmService(avmService);
                    loader.recursiveLoad(System.getProperty("alfresco.java.sources.dir", "source/java") + "/org/alfresco/repo/avm", "main--admin:/");
                    return null;
                }
            };
            RetryingTransactionHelper helper = (RetryingTransactionHelper)this.ctx.getBean("retryingTransactionHelper");
            helper.doInTransaction(cb);
        }
        finally {
            lockingService.removeLocks("main");
            avmService.purgeStore("main--admin");
            avmService.purgeStore("main");
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockingAwareServiceFileRename() throws Exception {
        lockingService.removeLocks("wpA");
        lockingService.removeLocks("wpB");
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            avmService.createStore("wpA");
            avmService.createStore("wpA--admin");
            avmService.createStore("wpB");
            avmService.createStore("wpB--admin");
            avmService.setStoreProperty("wpA", SandboxConstants.PROP_WEB_PROJECT_NODE_REF, new PropertyValue(DataTypeDefinition.NODE_REF, (Serializable)new NodeRef("workspace://SpacesStore/dummyA")));
            avmService.setStoreProperty("wpB", SandboxConstants.PROP_WEB_PROJECT_NODE_REF, new PropertyValue(DataTypeDefinition.NODE_REF, (Serializable)new NodeRef("workspace://SpacesStore/dummyB")));
            AVMLockingServiceTest.assertNull((Object)lockingService.getLockOwner("wpA", "/file1.txt"));
            AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess("wpA", "wpA--admin:/file1.txt", "admin"));
            avmService.createFile("wpA--admin:/", "file1.txt").close();
            AVMLockingServiceTest.assertNotNull((Object)lockingService.getLockOwner("wpA", "/file1.txt"));
            AVMLockingServiceTest.assertEquals((String)"admin", (String)lockingService.getLockOwner("wpA", "/file1.txt"));
            AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess("wpA", "wpA--admin:/file1.txt", "admin"));
            AVMLockingServiceTest.assertNull((Object)lockingService.getLockOwner("wpB", "/file1.txt"));
            AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess("wpB", "wpB--admin:/file1.txt", "admin"));
            avmService.rename("wpA--admin:/", "file1.txt", "wpB--admin:/", "file1.txt");
            AVMLockingServiceTest.assertNull((Object)lockingService.getLockOwner("wpA", "/file1.txt"));
            AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess("wpA", "wpA--admin:/file1.txt", "admin"));
            AVMLockingServiceTest.assertNotNull((Object)lockingService.getLockOwner("wpB", "/file1.txt"));
            AVMLockingServiceTest.assertEquals((String)"admin", (String)lockingService.getLockOwner("wpB", "/file1.txt"));
            AVMLockingServiceTest.assertTrue((boolean)lockingService.hasAccess("wpB", "wpB--admin:/file1.txt", "admin"));
        }
        finally {
            try {
                lockingService.removeLocks("wpA");
            }
            catch (Exception e) {}
            if (avmService.getStore("wpA--admin") != null) {
                avmService.purgeStore("wpA--admin");
            }
            if (avmService.getStore("wpA") != null) {
                avmService.purgeStore("wpA");
            }
            try {
                lockingService.removeLocks("wpB");
            }
            catch (Exception exception) {}
            if (avmService.getStore("wpB--admin") != null) {
                avmService.purgeStore("wpB--admin");
            }
            if (avmService.getStore("wpB") != null) {
                avmService.purgeStore("wpB");
            }
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        }
    }

    protected void setupBasicTree0() throws IOException {
        avmService.createDirectory("main:/", "a");
        avmService.createDirectory("main:/a", "b");
        avmService.createDirectory("main:/a/b", "c");
        avmService.createDirectory("main:/", "d");
        avmService.createDirectory("main:/d", "e");
        avmService.createDirectory("main:/d/e", "f");
        avmService.createFile("main:/a/b/c", "foo").close();
        ContentWriter writer = avmService.getContentWriter("main:/a/b/c/foo", true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/foo");
        avmService.createFile("main:/a/b/c", "bar").close();
        writer = avmService.getContentWriter("main:/a/b/c/bar", true);
        writer.setEncoding("UTF-16");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/bar");
        avmService.createSnapshot("main", null, null);
    }

    static {
        testWP1 = "alfresco-" + System.currentTimeMillis();
        EMPTY_MAP = Collections.emptyMap();
    }
}

