/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.actions.AVMDeployWebsiteAction;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class AVMDeployHandler
extends JBPMSpringActionHandler {
    private DeploymentService deploymentService;
    private AVMService avmService;
    private ActionService actionService;
    private NodeService unprotectedNodeService;
    private PermissionService unprotectedPermissionService;
    private static final String BEAN_DEPLOYMENT_SERVICE = "deploymentService";
    private static final String BEAN_AVM_SERVICE = "AVMService";
    private static final String BEAN_ACTION_SERVICE = "actionService";
    private static final String BEAN_NODE_SERVICE = "nodeService";
    private static final String BEAN_PERMISSION_SERVICE = "permissionService";
    private static final long serialVersionUID = 5590265401983087178L;
    private static final Log logger = LogFactory.getLog(AVMDeployHandler.class);

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        this.deploymentService = (DeploymentService)factory.getBean(BEAN_DEPLOYMENT_SERVICE);
        this.avmService = (AVMService)factory.getBean(BEAN_AVM_SERVICE);
        this.actionService = (ActionService)factory.getBean(BEAN_ACTION_SERVICE);
        this.unprotectedNodeService = (NodeService)factory.getBean(BEAN_NODE_SERVICE);
        this.unprotectedPermissionService = (PermissionService)factory.getBean(BEAN_PERMISSION_SERVICE);
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        JBPMNode webProjNode;
        NodeRef webProjectRef;
        List<NodeRef> servers;
        Boolean autoDeploy = (Boolean)executionContext.getContextInstance().getVariable("wcmwf_autoDeploy");
        if (logger.isDebugEnabled()) {
            String label = (String)executionContext.getContextInstance().getVariable("wcmwf_label");
            long workflowId = executionContext.getProcessInstance().getId();
            logger.debug((Object)("autoDeploy state for submission (workflowid: jbpm$" + workflowId + ", label: " + label + ") is: " + autoDeploy));
        }
        if (autoDeploy != null && autoDeploy.booleanValue() && (servers = this.deploymentService.findLiveDeploymentServers(webProjectRef = (webProjNode = (JBPMNode)executionContext.getContextInstance().getVariable("wcmwf_webproject")).getNodeRef())).size() > 0) {
            NodeRef pkg = ((JBPMNode)executionContext.getContextInstance().getVariable("bpm_package")).getNodeRef();
            Pair<Integer, String> pkgPath = AVMNodeConverter.ToAVMVersionPath(pkg);
            String[] workflowStorePath = ((String)pkgPath.getSecond()).split(":");
            String workflowStoreName = workflowStorePath[0];
            PropertyValue propVal = this.avmService.getStoreProperty(workflowStoreName, SandboxConstants.PROP_WEBSITE_NAME);
            String store = propVal.getStringValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting auto deploy to store: " + store));
            }
            int snapshotVersionToDeploy = this.avmService.getLatestSnapshotID(store);
            String pathToDeploy = store + ":/" + "www" + '/' + "avm_webapps";
            NodeRef websiteRef = AVMNodeConverter.ToNodeRef(snapshotVersionToDeploy, pathToDeploy);
            String attemptId = GUID.generate();
            HashMap<QName, Object> props = new HashMap<QName, Object>(8, 1.0f);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTID, attemptId);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTTYPE, "live");
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTSTORE, store);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTVERSION, snapshotVersionToDeploy);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTTIME, new Date());
            NodeRef attempt = this.unprotectedNodeService.createNode(webProjectRef, WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, WCMAppModel.TYPE_DEPLOYMENTATTEMPT, props).getChildRef();
            this.unprotectedPermissionService.setPermission(attempt, "GROUP_EVERYONE", "AddChildren", true);
            ArrayList<String> selectedDeployToNames = new ArrayList<String>();
            for (NodeRef serverRef : servers) {
                if (!this.unprotectedNodeService.exists(serverRef)) continue;
                Map serverProps = this.unprotectedNodeService.getProperties(serverRef);
                String serverUri = AVMDeployWebsiteAction.calculateServerUri(serverProps);
                String serverName = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERNAME);
                if (serverName == null || serverName.length() == 0) {
                    serverName = serverUri;
                }
                selectedDeployToNames.add(serverName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Auto deploying '" + websiteRef.toString() + "' to server: " + serverName));
                }
                HashMap<String, Serializable> args = new HashMap<String, Serializable>(1, 1.0f);
                args.put("webproject", (Serializable)webProjectRef);
                args.put("server", (Serializable)serverRef);
                args.put("attempt", (Serializable)attempt);
                Action action = this.actionService.createAction("avm-deploy-website", args);
                this.actionService.executeAction(action, websiteRef, false, true);
            }
            this.unprotectedNodeService.setProperty(attempt, WCMAppModel.PROP_DEPLOYATTEMPTSERVERS, (Serializable)selectedDeployToNames);
            this.avmService.deleteStoreProperty(store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID);
            this.avmService.setStoreProperty(store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)attemptId)));
        }
    }
}

