/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.util.Map;
import org.alfresco.model.BlogIntegrationModel;
import org.alfresco.repo.blog.BlogIntegrationRuntimeException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class BlogDetails
implements BlogIntegrationModel {
    private NodeRef nodeRef;
    private String implementationName;
    private String blogId;
    private String url;
    private String userName;
    private String password;
    private String name;
    private String description;

    public static BlogDetails createBlogDetails(NodeService nodeService, NodeRef nodeRef) {
        if (!nodeService.hasAspect(nodeRef, ASPECT_BLOG_DETAILS)) {
            throw new BlogIntegrationRuntimeException("Can not create blog details object since node does not have blogDetails aspect.");
        }
        Map props = nodeService.getProperties(nodeRef);
        return new BlogDetails((String)props.get(PROP_BLOG_IMPLEMENTATION), (String)props.get(PROP_ID), (String)props.get(PROP_URL), (String)props.get(PROP_USER_NAME), (String)props.get(PROP_PASSWORD), (String)props.get(PROP_NAME), (String)props.get(PROP_DESCRIPTION), nodeRef);
    }

    public BlogDetails(String implementationName, String blogId, String url, String userName, String password, String name, String description) {
        this(implementationName, blogId, url, userName, password, name, description, null);
    }

    public BlogDetails(String implementationName, String blogId, String url, String userName, String password, String name, String description, NodeRef nodeRef) {
        this.implementationName = implementationName;
        this.blogId = blogId;
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.name = name;
        this.description = description;
        this.nodeRef = nodeRef;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public String getBlogId() {
        return this.blogId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

