/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class ImportableItem {
    private ContentAndMetadata headRevision = new ContentAndMetadata();
    private SortedSet<VersionedContentAndMetadata> versionEntries = null;
    private NodeRef nodeRef;
    private ImportableItem parent;
    private long numChildren = 0L;

    public boolean isValid() {
        return this.headRevision.contentFileExists() || this.headRevision.metadataFileExists();
    }

    public ContentAndMetadata getHeadRevision() {
        return this.headRevision;
    }

    public void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void clearParent() {
        --this.numChildren;
        if (this.numChildren <= 0L) {
            this.numChildren = 0L;
            this.parent = null;
        }
    }

    public void setParent(ImportableItem parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        this.parent = parent;
    }

    public ImportableItem getParent() {
        return this.parent;
    }

    public boolean hasVersionEntries() {
        return this.versionEntries != null && this.versionEntries.size() > 0;
    }

    public Set<VersionedContentAndMetadata> getVersionEntries() {
        return Collections.unmodifiableSet(this.versionEntries);
    }

    public void addVersionEntry(VersionedContentAndMetadata versionEntry) {
        if (versionEntry != null) {
            if (this.versionEntries == null) {
                this.versionEntries = new TreeSet<VersionedContentAndMetadata>();
            }
            this.versionEntries.add(versionEntry);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("HeadRevision", (Object)this.headRevision).append("Versions", this.versionEntries).toString();
    }

    public class VersionedContentAndMetadata
    extends ContentAndMetadata
    implements Comparable<VersionedContentAndMetadata> {
        private int version;

        public VersionedContentAndMetadata(int version) {
            this.version = version;
        }

        public final int getVersion() {
            return this.version;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append("version", this.version).appendSuper("").toString();
        }

        @Override
        public int compareTo(VersionedContentAndMetadata other) {
            return this.version < other.version ? -1 : (this.version == other.version ? 0 : 1);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionedContentAndMetadata)) {
                return false;
            }
            VersionedContentAndMetadata otherVCAM = (VersionedContentAndMetadata)other;
            return this.version == otherVCAM.version;
        }

        public int hashCode() {
            return this.version;
        }
    }

    public class ContentAndMetadata {
        private File contentFile = null;
        private boolean contentFileExists = false;
        private boolean contentFileIsReadable = false;
        private FileType contentFileType = null;
        private long contentFileSize = -1L;
        private Date contentFileCreated = null;
        private Date contentFileModified = null;
        private File metadataFile = null;
        private long metadataFileSize = -1L;

        public final File getContentFile() {
            return this.contentFile;
        }

        public final void setContentFile(File contentFile) {
            this.contentFile = contentFile;
            if (contentFile != null) {
                this.contentFileExists = contentFile.exists();
                if (this.contentFileExists) {
                    this.contentFileIsReadable = contentFile.canRead();
                    this.contentFileSize = contentFile.length();
                    this.contentFileCreated = this.contentFileModified = new Date(contentFile.lastModified());
                    this.contentFileType = contentFile.isFile() ? FileType.FILE : (contentFile.isDirectory() ? FileType.DIRECTORY : FileType.OTHER);
                }
            }
        }

        public final boolean contentFileExists() {
            return this.contentFileExists;
        }

        public final boolean isContentFileReadable() {
            return this.contentFileIsReadable;
        }

        public final FileType getContentFileType() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file type if content file doesn't exist.");
            }
            return this.contentFileType;
        }

        public final long getContentFileSize() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file size if content file doesn't exist.");
            }
            return this.contentFileSize;
        }

        public final Date getContentFileCreatedDate() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file creation date if content file doesn't exist.");
            }
            return this.contentFileCreated;
        }

        public final Date getContentFileModifiedDate() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file modification date if content file doesn't exist.");
            }
            return this.contentFileModified;
        }

        public final boolean metadataFileExists() {
            return this.metadataFile != null;
        }

        public final File getMetadataFile() {
            return this.metadataFile;
        }

        public final void setMetadataFile(File metadataFile) {
            if (metadataFile != null && metadataFile.exists()) {
                this.metadataFile = metadataFile;
                this.metadataFileSize = metadataFile.length();
            }
        }

        public final long getMetadataFileSize() {
            if (!this.metadataFileExists()) {
                throw new IllegalStateException("Cannot determine metadata file size if metadata file doesn't exist.");
            }
            return this.metadataFileSize;
        }

        public final int weight() {
            return (this.contentFile == null || !this.contentFileExists ? 0 : 1) + (this.metadataFile == null ? 0 : 1);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("contentFile", (Object)(this.contentFileExists ? this.contentFile : null)).append("metadatafile", (Object)this.metadataFile).toString();
        }
    }

    public static enum FileType {
        FILE,
        DIRECTORY,
        OTHER;

    }
}

