/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.AbstractBulkImportTests;
import org.alfresco.repo.bulkimport.impl.StreamingNodeImporterFactory;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.util.ResourceUtils;

public class BulkImportTest
extends AbstractBulkImportTests {
    private StreamingNodeImporterFactory streamingNodeImporterFactory;

    @BeforeClass
    public static void beforeTests() {
        BulkImportTest.startContext();
    }

    @Override
    @Before
    public void setup() throws SystemException, NotSupportedException {
        super.setup();
        this.streamingNodeImporterFactory = (StreamingNodeImporterFactory)ctx.getBean("streamingNodeImporterFactory");
    }

    @Test
    public void testCopyImportStriping() throws Throwable {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        try {
            NodeImporter nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport"));
            BulkImportParameters bulkImportParameters = new BulkImportParameters();
            bulkImportParameters.setTarget(folderNode);
            bulkImportParameters.setReplaceExisting(true);
            bulkImportParameters.setDisableRulesService(true);
            bulkImportParameters.setBatchSize(40);
            this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
        System.out.println(this.bulkImporter.getStatus());
        this.checkFiles(folderNode, null, 2, 9, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quickImg1.xls", "application/vnd.ms-excel"), new AbstractBulkImportTests.ExpectedFile("quickImg1.doc", "application/msword"), new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1"), new AbstractBulkImportTests.ExpectedFolder("folder2")});
        List<FileInfo> folders = this.getFolders(folderNode, "folder1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1, null, 1, 0, null, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1")});
        folders = this.getFolders(folderNode, "folder2");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2 = folders.get(0).getNodeRef();
        this.checkFiles(folder2, null, 1, 0, new AbstractBulkImportTests.ExpectedFile[0], new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder2.1")});
        folders = this.getFolders(folder1, "folder1.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1_1, null, 2, 12, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog"), new AbstractBulkImportTests.ExpectedFile("quick.sxw", "application/vnd.sun.xml.writer"), new AbstractBulkImportTests.ExpectedFile("quick.tar", "application/x-gtar")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1.1"), new AbstractBulkImportTests.ExpectedFolder("folder1.1.2")});
        folders = this.getFolders(folder2, "folder2.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder2_1, null, 0, 17, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.png", "image/png"), new AbstractBulkImportTests.ExpectedFile("quick.pdf", "application/pdf"), new AbstractBulkImportTests.ExpectedFile("quick.odt", "application/vnd.oasis.opendocument.text")}, new AbstractBulkImportTests.ExpectedFolder[0]);
    }

    protected Rule createCopyRule(NodeRef targetNode, boolean isAppliedToChildren) {
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        String title = "rule title " + System.currentTimeMillis();
        rule.setTitle(title);
        rule.setDescription(title);
        rule.applyToChildren(isAppliedToChildren);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", (Serializable)targetNode);
        Action action = this.actionService.createAction("copy", params);
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(condition);
        rule.setAction(action);
        return rule;
    }

    @Test
    public void testImportWithRules() throws Throwable {
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        NodeImporter nodeImporter = null;
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef targetNode = this.fileFolderService.create(this.top, "target", ContentModel.TYPE_FOLDER).getNodeRef();
        Rule newRule = this.createCopyRule(targetNode, false);
        this.ruleService.saveRule(folderNode, newRule);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        nodeImporter = this.streamingNodeImporterFactory.getNodeImporter(ResourceUtils.getFile((String)"classpath:bulkimport"));
        BulkImportParameters bulkImportParameters = new BulkImportParameters();
        bulkImportParameters.setTarget(folderNode);
        bulkImportParameters.setReplaceExisting(true);
        bulkImportParameters.setDisableRulesService(false);
        bulkImportParameters.setBatchSize(40);
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        System.out.println(this.bulkImporter.getStatus());
        Assert.assertEquals((String)"", (long)74L, (long)this.bulkImporter.getStatus().getNumberOfContentNodesCreated());
        this.checkFiles(folderNode, null, 2, 9, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quickImg1.xls", "application/vnd.ms-excel"), new AbstractBulkImportTests.ExpectedFile("quickImg1.doc", "application/msword"), new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1"), new AbstractBulkImportTests.ExpectedFolder("folder2")});
        List<FileInfo> folders = this.getFolders(folderNode, "folder1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1, null, 1, 0, null, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1")});
        folders = this.getFolders(folderNode, "folder2");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2 = folders.get(0).getNodeRef();
        this.checkFiles(folder2, null, 1, 0, new AbstractBulkImportTests.ExpectedFile[0], new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder2.1")});
        folders = this.getFolders(folder1, "folder1.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1_1, null, 2, 12, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.txt", "text/plain", "The quick brown fox jumps over the lazy dog"), new AbstractBulkImportTests.ExpectedFile("quick.sxw", "application/vnd.sun.xml.writer"), new AbstractBulkImportTests.ExpectedFile("quick.tar", "application/x-gtar")}, new AbstractBulkImportTests.ExpectedFolder[]{new AbstractBulkImportTests.ExpectedFolder("folder1.1.1"), new AbstractBulkImportTests.ExpectedFolder("folder1.1.2")});
        folders = this.getFolders(folder2, "folder2.1");
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder2_1 = folders.get(0).getNodeRef();
        this.checkFiles(folder2_1, null, 0, 17, new AbstractBulkImportTests.ExpectedFile[]{new AbstractBulkImportTests.ExpectedFile("quick.png", "image/png"), new AbstractBulkImportTests.ExpectedFile("quick.pdf", "application/pdf"), new AbstractBulkImportTests.ExpectedFile("quick.odt", "application/vnd.oasis.opendocument.text")}, new AbstractBulkImportTests.ExpectedFolder[0]);
    }
}

