/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSimpleCacheTest {
    private DefaultSimpleCache<Integer, String> cache;

    @Before
    public void setUp() throws Exception {
        this.cache = new DefaultSimpleCache(100, this.getClass().getName());
    }

    @Test
    public void boundedSizeCache() throws Exception {
        this.cache.setMaxItems(3);
        this.cache.put(1, "1");
        this.cache.put(2, "2");
        this.cache.put(3, "3");
        this.cache.put(4, "4");
        this.cache.put(5, "5");
        Assert.assertNull((Object)this.cache.get(1));
        Assert.assertFalse((boolean)this.cache.contains(1));
        Assert.assertNull((Object)this.cache.get(2));
        Assert.assertFalse((boolean)this.cache.contains(2));
        Assert.assertEquals((Object)"3", (Object)this.cache.get(3));
        Assert.assertEquals((Object)"4", (Object)this.cache.get(4));
        Assert.assertEquals((Object)"5", (Object)this.cache.get(5));
    }

    @Test
    public void canStoreNullValues() {
        this.cache.put(2, null);
        Assert.assertEquals(null, (Object)this.cache.get(2));
        Assert.assertTrue((boolean)this.cache.contains(2));
        Assert.assertEquals(null, (Object)this.cache.get(4));
        Assert.assertFalse((boolean)this.cache.contains(4));
    }

    @Test
    public void canRemoveItems() {
        this.cache.put(1, "hello");
        this.cache.put(2, "world");
        Assert.assertEquals((Object)"hello", (Object)this.cache.get(1));
        Assert.assertEquals((Object)"world", (Object)this.cache.get(2));
        this.cache.remove(2);
        Assert.assertEquals((Object)"hello", (Object)this.cache.get(1));
        Assert.assertEquals(null, (Object)this.cache.get(2));
        Assert.assertEquals((Object)false, (Object)this.cache.contains(2));
    }

    @Test
    public void canClearItems() {
        this.cache.put(1, "hello");
        this.cache.put(2, "world");
        Assert.assertEquals((Object)"hello", (Object)this.cache.get(1));
        Assert.assertEquals((Object)"world", (Object)this.cache.get(2));
        this.cache.clear();
        Assert.assertEquals(null, (Object)this.cache.get(1));
        Assert.assertEquals((Object)false, (Object)this.cache.contains(1));
        Assert.assertEquals(null, (Object)this.cache.get(2));
        Assert.assertEquals((Object)false, (Object)this.cache.contains(2));
    }

    @Test
    public void canGetKeys() {
        this.cache.put(3, "blue");
        this.cache.put(12, "red");
        this.cache.put(43, "olive");
        ArrayList<Integer> keys = new ArrayList<Integer>(this.cache.getKeys());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        Assert.assertEquals((long)3L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)43L, (long)((Integer)it.next()).intValue());
        Assert.assertFalse((String)"There should be no more keys.", (boolean)it.hasNext());
    }

    @Test
    public void noConcurrentModificationException() {
        this.cache.put(1, "1");
        this.cache.put(2, "2");
        this.cache.put(3, "3");
        this.cache.put(4, "4");
        Iterator<Integer> i = this.cache.getKeys().iterator();
        i.next();
        i.next();
        this.cache.put(5, "5");
        i.next();
    }
}

