/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.calendar;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.calendar.CalendarRecurrenceHelper;
import org.alfresco.service.cmr.calendar.CalendarTimezoneHelper;
import org.junit.Assert;
import org.junit.Test;

public class CalendarHelpersTest {
    private static SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
    private static final String ICAL_TZ_BRISBANE = "BEGIN:VTIMEZONE\nTZID:Brisbane\nBEGIN:STANDARD\nDTSTART:16010101T000000\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1000\nEND:STANDARD\nEND:VTIMEZONE\n";
    private static final String ICAL_TZ_SYDNEY = "BEGIN:VTIMEZONE\nTZID:Canberra\\, Melbourne\\, Sydney\nBEGIN:STANDARD\nDTSTART:16010401T030000\nRRULE:FREQ=YEARLY;BYDAY=1SU;BYMONTH=4\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1000\nEND:STANDARD\nBEGIN:DAYLIGHT\nDTSTART:16011007T020000\nRRULE:FREQ=YEARLY;BYDAY=1SU;BYMONTH=10\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nEND:DAYLIGHT\nEND:VTIMEZONE\n";
    private static final String ICAL_TZ_LONDON = "BEGIN:VTIMEZONE\nTZID:Europe/London\nX-LIC-LOCATION:Europe/London\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:BST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nEND:VTIMEZONE\n";

    @Test
    public void allDayDetection() {
        TimeZone UTC = TimeZone.getTimeZone("UTC");
        TimeZone NewYork = TimeZone.getTimeZone("America/New_York");
        Calendar c20110719_0000 = Calendar.getInstance(UTC);
        Calendar c20110719_1000 = Calendar.getInstance(UTC);
        Calendar c20110720_0000 = Calendar.getInstance(UTC);
        Calendar c20110721_0000 = Calendar.getInstance(UTC);
        c20110719_0000.set(2011, 7, 19, 0, 0, 0);
        c20110719_1000.set(2011, 7, 19, 1, 0, 0);
        c20110720_0000.set(2011, 7, 20, 0, 0, 0);
        c20110721_0000.set(2011, 7, 21, 0, 0, 0);
        Calendar c20110721_0000ny = Calendar.getInstance(NewYork);
        Calendar c20110721_2000ny = Calendar.getInstance(NewYork);
        c20110721_0000ny.set(2011, 7, 21, 0, 0, 0);
        c20110721_2000ny.set(2011, 7, 21, 2, 0, 0);
        CalendarEntryDTO entry = new CalendarEntryDTO();
        entry.setStart(c20110719_0000.getTime());
        entry.setEnd(c20110719_0000.getTime());
        Assert.assertTrue((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_0000.getTime());
        entry.setEnd(c20110720_0000.getTime());
        Assert.assertTrue((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_0000.getTime());
        entry.setEnd(c20110721_0000.getTime());
        Assert.assertTrue((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_0000.getTime());
        entry.setEnd(c20110719_1000.getTime());
        Assert.assertFalse((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_1000.getTime());
        entry.setEnd(c20110720_0000.getTime());
        Assert.assertFalse((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_1000.getTime());
        entry.setEnd(c20110719_1000.getTime());
        Assert.assertFalse((boolean)CalendarEntryDTO.isAllDay(entry));
        TimeZone defaultTimezone = TimeZone.getDefault();
        TimeZone.setDefault(NewYork);
        entry.setStart(c20110721_0000ny.getTime());
        entry.setEnd(c20110721_0000ny.getTime());
        Assert.assertTrue((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110721_2000ny.getTime());
        entry.setEnd(c20110721_2000ny.getTime());
        Assert.assertFalse((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_0000.getTime());
        entry.setEnd(c20110719_0000.getTime());
        Assert.assertTrue((boolean)CalendarEntryDTO.isAllDay(entry));
        entry.setStart(c20110719_0000.getTime());
        entry.setEnd(c20110719_1000.getTime());
        Assert.assertFalse((boolean)CalendarEntryDTO.isAllDay(entry));
        TimeZone.setDefault(defaultTimezone);
    }

    @Test
    public void dailyRecurrenceDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2011, 7, 25), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-19", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2011, 7, 25), false, 1);
        Assert.assertEquals((long)6L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-19", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-07-24", (Object)dateFmt.format((Date)dates.get(5)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 7, 30), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-20", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 7, 30), false, 1);
        Assert.assertEquals((long)10L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-20", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-07-29", (Object)dateFmt.format((Date)dates.get(9)));
        dates.clear();
        currentDate.set(2011, 10, 24, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 11, 22, 12, 30), CalendarHelpersTest.date(2011, 11, 27, 12, 30), false, 1);
        Assert.assertEquals((long)4L, (long)dates.size());
        Assert.assertEquals((Object)"2011-11-24", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-11-25", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2011-11-26", (Object)dateFmt.format((Date)dates.get(2)));
        Assert.assertEquals((Object)"2011-11-27", (Object)dateFmt.format((Date)dates.get(3)));
        dates.clear();
        currentDate.set(2011, 10, 24, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 11, 22, 12, 30), CalendarHelpersTest.date(2011, 11, 27, 12, 30), false, 3);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2011-11-24", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-11-27", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 19), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-19", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildDailyRecurrences(currentDate, dates, null, CalendarHelpersTest.date(2011, 7, 20), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-20", (Object)dateFmt.format((Date)dates.get(0)));
    }

    @Test
    public void weeklyRecurrenceDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BYDAY", "MO,TH");
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 17), CalendarHelpersTest.date(2011, 7, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2011, 7, 26), false, 1);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-07-25", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2011, 10, 24, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 11, 22, 12, 30), CalendarHelpersTest.date(2011, 11, 25, 12, 30), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-11-24", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2011, 7, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2011, 7, 26), false, 1);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-07-25", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 7, 30), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 7, 30), false, 1);
        Assert.assertEquals((long)3L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-07-25", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2011-07-28", (Object)dateFmt.format((Date)dates.get(2)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 8, 30), true, 3);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 8, 30), false, 3);
        Assert.assertEquals((long)4L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-08-08", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2011-08-11", (Object)dateFmt.format((Date)dates.get(2)));
        Assert.assertEquals((Object)"2011-08-29", (Object)dateFmt.format((Date)dates.get(3)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 22), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-25", (Object)dateFmt.format((Date)dates.get(0)));
    }

    @Test
    public void monthlyRecurrenceByDateInMonth() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BYMONTHDAY", "2");
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 1, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), CalendarHelpersTest.date(2011, 7, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 1, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), CalendarHelpersTest.date(2011, 7, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 2), CalendarHelpersTest.date(2011, 7, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 2), CalendarHelpersTest.date(2011, 7, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 9, 20), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 9, 20), false, 1);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-02", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-09-02", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 9, 20), false, 2);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-09-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-02", (Object)dateFmt.format((Date)dates.get(0)));
    }

    @Test
    public void reccurenceByLastDay() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(2012, 6, 15, 10, 30);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FREQ", "MONTHLY");
        params.put("BYDAY", "MO");
        params.put("INTERVAL", "1");
        params.put("BYSETPOS", "-1");
        dates.clear();
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 7, 1), CalendarHelpersTest.date(2012, 9, 30), false, 1);
        Assert.assertEquals((long)3L, (long)dates.size());
        Assert.assertEquals((Object)"2012-07-30", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2012-08-27", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2012-09-24", (Object)dateFmt.format((Date)dates.get(2)));
        params = new HashMap();
        params.put("BYMONTH", "7");
        params.put("BYDAY", "MO");
        params.put("BYSETPOS", "-1");
        dates.clear();
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 7, 1), CalendarHelpersTest.date(2015, 10, 1), false, 1);
        Assert.assertEquals((long)3L, (long)dates.size());
        Assert.assertEquals((Object)"2013-07-29", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2014-07-28", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2015-07-27", (Object)dateFmt.format((Date)dates.get(2)));
    }

    @Test
    public void monthlyRecurrenceByDayOfWeek() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BYSETPOS", "TU");
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 10), CalendarHelpersTest.date(2011, 7, 15), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2011, 6, 1, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), CalendarHelpersTest.date(2011, 7, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-05", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 1, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), CalendarHelpersTest.date(2011, 7, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-05", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 2), CalendarHelpersTest.date(2011, 7, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-05", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 2), CalendarHelpersTest.date(2011, 7, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-05", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 9, 20), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-02", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 20), CalendarHelpersTest.date(2011, 9, 20), false, 1);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-02", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-09-06", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-05", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-02", (Object)dateFmt.format((Date)dates.get(0)));
        params.clear();
        params.put("FREQ", "MONTHLY");
        params.put("COUNT", "10");
        params.put("INTERVAL", "1");
        params.put("BYDAY", "MO");
        params.put("BYSETPOS", "1");
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2012, 1, 5), false, 1);
        Assert.assertEquals((long)6L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-01", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-09-05", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2011-10-03", (Object)dateFmt.format((Date)dates.get(2)));
        Assert.assertEquals((Object)"2011-11-07", (Object)dateFmt.format((Date)dates.get(3)));
        Assert.assertEquals((Object)"2011-12-05", (Object)dateFmt.format((Date)dates.get(4)));
        Assert.assertEquals((Object)"2012-01-02", (Object)dateFmt.format((Date)dates.get(5)));
        params.clear();
        params.put("FREQ", "MONTHLY");
        params.put("COUNT", "10");
        params.put("INTERVAL", "1");
        params.put("BYDAY", "FR");
        params.put("BYSETPOS", "3");
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2012, 1, 25), false, 1);
        Assert.assertEquals((long)6L, (long)dates.size());
        Assert.assertEquals((Object)"2011-08-19", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-09-16", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2011-10-21", (Object)dateFmt.format((Date)dates.get(2)));
        Assert.assertEquals((Object)"2011-11-18", (Object)dateFmt.format((Date)dates.get(3)));
        Assert.assertEquals((Object)"2011-12-16", (Object)dateFmt.format((Date)dates.get(4)));
        Assert.assertEquals((Object)"2012-01-20", (Object)dateFmt.format((Date)dates.get(5)));
        params.clear();
        params.put("FREQ", "MONTHLY");
        params.put("COUNT", "10");
        params.put("INTERVAL", "3");
        params.put("BYDAY", "FR");
        params.put("BYSETPOS", "3");
        dates.clear();
        currentDate.set(2011, 6, 19, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), CalendarHelpersTest.date(2012, 1, 25), false, 3);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2011-10-21", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2012-01-20", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2011, 6, 14, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 14), CalendarHelpersTest.date(2012, 1, 25), false, 1);
        Assert.assertEquals((long)7L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-15", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-08-19", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2011-09-16", (Object)dateFmt.format((Date)dates.get(2)));
        Assert.assertEquals((Object)"2011-10-21", (Object)dateFmt.format((Date)dates.get(3)));
        Assert.assertEquals((Object)"2011-11-18", (Object)dateFmt.format((Date)dates.get(4)));
        Assert.assertEquals((Object)"2011-12-16", (Object)dateFmt.format((Date)dates.get(5)));
        Assert.assertEquals((Object)"2012-01-20", (Object)dateFmt.format((Date)dates.get(6)));
        dates.clear();
        currentDate.set(2011, 6, 14, 10, 30);
        RecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 14), CalendarHelpersTest.date(2012, 1, 25), false, 3);
        Assert.assertEquals((long)3L, (long)dates.size());
        Assert.assertEquals((Object)"2011-07-15", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2011-10-21", (Object)dateFmt.format((Date)dates.get(1)));
        Assert.assertEquals((Object)"2012-01-20", (Object)dateFmt.format((Date)dates.get(2)));
    }

    @Test
    public void monthlyRecurrenceByLastDayOfWeek() {
        ArrayList dates = new ArrayList();
        Calendar currentDate = Calendar.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("FREQ", "MONTHLY");
        params.put("INTERVAL", "2");
        params.put("BYDAY", "TU");
        params.put("BYSETPOS", "-1");
    }

    @Test
    public void yearlyRecurrenceByDateInMonth() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("COUNT", "10");
        params.put("BYMONTH", "2");
        params.put("BYMONTHDAY", "21");
        HashMap<String, String> paramsOUTLOOK = new HashMap<String, String>();
        paramsOUTLOOK.put("FREQ", "MONTHLY");
        paramsOUTLOOK.put("COUNT", "10");
        paramsOUTLOOK.put("BYMONTH", "2");
        paramsOUTLOOK.put("INTERVAL", "1");
        paramsOUTLOOK.put("BYSETPOS", "21");
        paramsOUTLOOK.put("BYDAY", "SU,MO,TU,WE,TH,FR,SA");
        Map<String, String> paramsFIXED = RecurrenceHelper.fixOutlookRecurrenceQuirks(paramsOUTLOOK);
        Assert.assertEquals((Object)"YEARLY", (Object)paramsFIXED.get("FREQ"));
        Assert.assertEquals((Object)"2", (Object)paramsFIXED.get("BYMONTH"));
        Assert.assertEquals((Object)"21", (Object)paramsFIXED.get("BYMONTHDAY"));
        Assert.assertEquals((Object)"10", (Object)paramsFIXED.get("COUNT"));
        Assert.assertEquals((Object)"1", (Object)paramsFIXED.get("INTERVAL"));
        Assert.assertEquals(null, (Object)paramsFIXED.get("BYDAY"));
        Assert.assertEquals(null, (Object)paramsFIXED.get("BYSETPOS"));
        dates.clear();
        currentDate.set(2012, 0, 19, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 10), CalendarHelpersTest.date(2012, 2, 15), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 10), CalendarHelpersTest.date(2012, 2, 15), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2012, 2, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2012, 2, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2012, 3, 26), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2012, 3, 26), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2013, 3, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2013, 3, 26), false, 1);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2013-02-21", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2013, 2, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2013-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2013, 3, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2013-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-21", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 6, 19, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2013-02-21", (Object)dateFmt.format((Date)dates.get(0)));
    }

    @Test
    public void yearlyRecurrenceByDayOfWeekInMonth() {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar currentDate = Calendar.getInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("COUNT", "7");
        params.put("BYMONTH", "2");
        params.put("BYDAY", "SA");
        params.put("BYSETPOS", "2");
        HashMap<String, String> paramsOUTLOOK = new HashMap<String, String>();
        paramsOUTLOOK.put("FREQ", "MONTHLY");
        paramsOUTLOOK.put("COUNT", "7");
        paramsOUTLOOK.put("BYMONTH", "2");
        paramsOUTLOOK.put("BYDAY", "SA");
        paramsOUTLOOK.put("BYSETPOS", "2");
        paramsOUTLOOK.put("INTERVAL", "1");
        Map<String, String> paramsFIXED = RecurrenceHelper.fixOutlookRecurrenceQuirks(paramsOUTLOOK);
        Assert.assertEquals((Object)"YEARLY", (Object)paramsFIXED.get("FREQ"));
        Assert.assertEquals((Object)"2", (Object)paramsFIXED.get("BYMONTH"));
        Assert.assertEquals((Object)"SA", (Object)paramsFIXED.get("BYDAY"));
        Assert.assertEquals((Object)"2", (Object)paramsFIXED.get("BYSETPOS"));
        Assert.assertEquals((Object)"7", (Object)paramsFIXED.get("COUNT"));
        Assert.assertEquals((Object)"1", (Object)paramsFIXED.get("INTERVAL"));
        Assert.assertEquals(null, (Object)paramsFIXED.get("BYMONTHDAY"));
        dates.clear();
        currentDate.set(2012, 0, 19, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 4), CalendarHelpersTest.date(2012, 2, 5), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 4), CalendarHelpersTest.date(2012, 2, 5), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2012, 2, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-11", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2012, 2, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-11", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2012, 3, 26), true, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2012, 3, 26), false, 1);
        Assert.assertEquals((long)0L, (long)dates.size());
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2013, 3, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-11", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 1, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 2, 1), CalendarHelpersTest.date(2013, 3, 26), false, 1);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-11", (Object)dateFmt.format((Date)dates.get(0)));
        Assert.assertEquals((Object)"2013-02-09", (Object)dateFmt.format((Date)dates.get(1)));
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2013, 2, 26), true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2013-02-09", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 2, 1, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2012, 3, 1), CalendarHelpersTest.date(2013, 3, 26), false, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2013-02-09", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2011, 6, 2, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 1), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2012-02-11", (Object)dateFmt.format((Date)dates.get(0)));
        dates.clear();
        currentDate.set(2012, 6, 19, 10, 30);
        RecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, CalendarHelpersTest.date(2011, 7, 19), null, true, 1);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertEquals((Object)"2013-02-09", (Object)dateFmt.format((Date)dates.get(0)));
    }

    @Test
    public void simpleTimeZoneNoDST() {
        SimpleTimeZone tz = CalendarTimezoneHelper.buildTimeZone(ICAL_TZ_BRISBANE);
        Assert.assertNotNull((Object)tz);
        Assert.assertEquals((Object)"Brisbane", (Object)tz.getID());
        Assert.assertEquals((Object)false, (Object)tz.useDaylightTime());
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 3, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 9, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 11, 1).getTime()));
    }

    @Test
    public void simpleTimeZoneNorthern() {
        SimpleTimeZone tz = CalendarTimezoneHelper.buildTimeZone(ICAL_TZ_LONDON);
        Assert.assertNotNull((Object)tz);
        Assert.assertEquals((Object)"Europe/London", (Object)tz.getID());
        Assert.assertEquals((Object)true, (Object)tz.useDaylightTime());
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2003, 3, 1).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2003, 3, 31).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2003, 9, 1).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2003, 10, 25).getTime()));
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2003, 11, 1).getTime()));
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 3, 1).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 3, 26).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 3, 31).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 9, 1).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 10, 28).getTime()));
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 10, 29).getTime()));
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2007, 11, 1).getTime()));
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 3, 1).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 3, 31).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 9, 1).getTime()));
        Assert.assertEquals((long)3600000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 10, 25).getTime()));
        Assert.assertEquals((long)0L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 11, 1).getTime()));
    }

    @Test
    public void simpleTimeZoneSouthern() {
        SimpleTimeZone tz = CalendarTimezoneHelper.buildTimeZone(ICAL_TZ_SYDNEY);
        Assert.assertNotNull((Object)tz);
        Assert.assertEquals((Object)"Canberra, Melbourne, Sydney", (Object)tz.getID());
        Assert.assertEquals((Object)true, (Object)tz.useDaylightTime());
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2008, 6, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2008, 10, 1).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2008, 10, 6).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2008, 12, 1).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 1, 5).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 4, 4).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 4, 6).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 5, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 6, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 10, 1).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 10, 6).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2009, 12, 1).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 1, 5).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 4, 3).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 4, 5).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 5, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 6, 1).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 10, 1).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 10, 6).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2010, 12, 1).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 1, 5).getTime()));
        Assert.assertEquals((long)39600000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 4, 2).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 4, 4).getTime()));
        Assert.assertEquals((long)36000000L, (long)tz.getOffset(CalendarHelpersTest.date(2011, 5, 1).getTime()));
    }

    private static Date date(int year, int month, int day) {
        return CalendarHelpersTest.date(year, month, day, 0, 0);
    }

    private static Date date(int year, int month, int day, int hour, int minute) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, hour, minute, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private static class RecurrenceHelper
    extends CalendarRecurrenceHelper {
        private RecurrenceHelper() {
        }

        protected static void buildDailyRecurrences(Calendar currentDate, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
            CalendarRecurrenceHelper.buildDailyRecurrences(currentDate, dates, params, onOrAfter, until, firstOnly, interval);
        }

        protected static void buildWeeklyRecurrences(Calendar currentDate, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
            CalendarRecurrenceHelper.buildWeeklyRecurrences(currentDate, dates, params, onOrAfter, until, firstOnly, interval);
        }

        protected static void buildMonthlyRecurrences(Calendar currentDate, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
            CalendarRecurrenceHelper.buildMonthlyRecurrences(currentDate, dates, params, onOrAfter, until, firstOnly, interval);
        }

        protected static void buildYearlyRecurrences(Calendar currentDate, List<Date> dates, Map<String, String> params, Date onOrAfter, Date until, boolean firstOnly, int interval) {
            CalendarRecurrenceHelper.buildYearlyRecurrences(currentDate, dates, params, onOrAfter, until, firstOnly, interval);
        }

        protected static Map<String, String> fixOutlookRecurrenceQuirks(Map<String, String> params) {
            return CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks(params);
        }
    }
}

