/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.util.Pair;

public class AVMCopyOut
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-r", 0, "-v", 0};
    private static String USAGE = "usage: AVMCopyOut [-r] [-v] nodepath@version fspath";
    private boolean fVerbose;

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        File dest;
        this.fVerbose = flags.containsKey("-v");
        Pair<String, Integer> versionPath = this.splitPathVersion(args.get(0));
        String path = (String)versionPath.getFirst();
        int version = (Integer)versionPath.getSecond();
        AVMNodeDescriptor desc = this.fAVMRemote.lookup(version, path);
        if (flags.containsKey("-r")) {
            this.recursiveCopy(desc, args.get(1));
            return;
        }
        if (desc == null) {
            System.err.println(path + " does not exist.");
            this.fContext.close();
            System.exit(1);
        }
        if (!desc.isFile()) {
            System.err.println(path + " is not a file.");
            this.fContext.close();
            System.exit(1);
        }
        if ((dest = new File(args.get(1))).exists()) {
            if (!dest.isDirectory()) {
                System.err.println("Destination must be a directory.");
                this.fContext.close();
                System.exit(1);
            }
            try {
                InputStream in = this.fAVMRemote.getFileInputStream(version, path);
                String[] parentBase = this.splitPath(path);
                FileOutputStream out = new FileOutputStream(args.get(1) + File.separator + parentBase[1]);
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        } else {
            try {
                InputStream in = this.fAVMRemote.getFileInputStream(version, path);
                FileOutputStream out = new FileOutputStream(args.get(1));
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        }
    }

    private void recursiveCopy(AVMNodeDescriptor src, String dst) {
        String newDst = dst + File.separator + src.getName();
        if (this.fVerbose) {
            System.out.println(src.getPath() + " -> " + dst);
        }
        if (src.isDirectory()) {
            File destFile = new File(newDst);
            destFile.mkdir();
            SortedMap<String, AVMNodeDescriptor> listing = this.fAVMRemote.getDirectoryListing(src);
            for (AVMNodeDescriptor child : listing.values()) {
                this.recursiveCopy(child, newDst);
            }
            return;
        }
        try {
            InputStream in = this.fAVMRemote.getFileInputStream(src);
            FileOutputStream out = new FileOutputStream(newDst);
            this.copyStream(in, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fContext.close();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        AVMCopyOut me = new AVMCopyOut();
        me.exec(args, flagDefs, 2, USAGE);
    }
}

