/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;

public class AVMMkDir
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-p", 0};
    private static String USAGE = "usage: AVMMkDir [-p] nodepath";

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        if (flags.containsKey("-p")) {
            this.mkdirp(args.get(0));
            return;
        }
        String[] parentBase = this.splitPath(args.get(0));
        if (parentBase.length == 1) {
            System.err.println(args.get(0) + " is a root path.");
            this.fContext.close();
            System.exit(1);
        }
        this.fAVMRemote.createDirectory(parentBase[0], parentBase[1]);
    }

    private void mkdirp(String path) {
        AVMNodeDescriptor desc = this.fAVMRemote.lookup(-1, path);
        if (desc != null) {
            return;
        }
        String[] parentBase = this.splitPath(path);
        if (parentBase.length == 1) {
            System.err.println(path + " does not exist.");
            this.fContext.close();
            System.exit(1);
        }
        this.mkdirp(parentBase[0]);
        this.fAVMRemote.createDirectory(parentBase[0], parentBase[1]);
    }

    public static void main(String[] args) {
        AVMMkDir me = new AVMMkDir();
        me.exec(args, flagDefs, 1, USAGE);
    }
}

