/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

public class RepoCopyIn
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-r", 0, "-v", 0};
    private static String USAGE = "usage: RepoCopyIn fspath repopath";
    private boolean fVerbose;

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        this.fVerbose = flags.containsKey("-v");
        NodeRef root = this.fRepoRemote.getRoot();
        String path = args.get(1);
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        Pair<NodeRef, Boolean> dst = this.fRepoRemote.lookup(root, path);
        if (flags.containsKey("-r")) {
            if (dst == null) {
                System.err.println(args.get(1) + " does not exist.");
                this.fContext.close();
                System.exit(1);
            }
            this.recursiveCopy(args.get(0), (NodeRef)dst.getFirst());
            return;
        }
        File file = new File(args.get(0));
        if (!file.isFile()) {
            System.err.println(args.get(0) + " not found, or not a file.");
            this.fContext.close();
            System.exit(1);
        }
        if (dst == null) {
            try {
                if (this.fVerbose) {
                    System.out.println(file.getName() + " -> " + args.get(1));
                }
                FileInputStream in = new FileInputStream(file);
                OutputStream out = this.fRepoRemote.createFile(root, path);
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        } else {
            if (!((Boolean)dst.getSecond()).booleanValue()) {
                System.err.println("Target must be a directory.");
                this.fContext.close();
                System.exit(1);
            }
            try {
                if (this.fVerbose) {
                    System.out.println(file.getName() + " -> " + args.get(1));
                }
                FileInputStream in = new FileInputStream(file);
                OutputStream out = this.fAVMRemote.createFile(args.get(1), file.getName());
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        }
    }

    private void recursiveCopy(String sourcePath, NodeRef dest) {
        File file = new File(sourcePath);
        if (this.fVerbose) {
            System.out.println(sourcePath + " -> " + dest);
        }
        if (file.isDirectory()) {
            String[] names;
            NodeRef dir = this.fRepoRemote.createDirectory(dest, file.getName());
            for (String name : names = file.list()) {
                this.recursiveCopy(sourcePath + File.separatorChar + name, dir);
            }
        } else {
            try {
                FileInputStream in = new FileInputStream(file);
                OutputStream out = this.fRepoRemote.createFile(dest, file.getName());
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        RepoCopyIn me = new RepoCopyIn();
        me.exec(args, flagDefs, 2, USAGE);
    }
}

