/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.TestWithUserUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class CheckOutCheckInServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private CheckOutCheckInService cociService;
    private ContentService contentService;
    private VersionService versionService;
    private MutableAuthenticationService authenticationService;
    private LockService lockService;
    private TransactionService transactionService;
    private PermissionService permissionService;
    private CopyService copyService;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private String userNodeRef;
    private NodeRef folderNodeRef;
    private NodeRef fileNodeRef;
    private static final String TEST_VALUE_NAME = "myDocument.doc";
    private static final String TEST_VALUE_2 = "testValue2";
    private static final String TEST_VALUE_3 = "testValue3";
    private static final QName PROP_NAME_QNAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"name");
    private static final QName PROP2_QNAME = ContentModel.PROP_DESCRIPTION;
    private static final String CONTENT_1 = "This is some content";
    private static final String CONTENT_2 = "This is the cotent modified.";
    private String userName;
    private static final String PWD = "password";

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.versionService = (VersionService)this.applicationContext.getBean("versionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.copyService = (CopyService)this.applicationContext.getBean("copyService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT);
        this.nodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TITLED, null);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)TEST_VALUE_NAME));
        this.nodeService.setProperty(this.nodeRef, PROP2_QNAME, (Serializable)((Object)TEST_VALUE_2));
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(CONTENT_1);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        this.userName = "cociTest" + GUID.generate();
        TestWithUserUtils.createUser(this.userName, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, this.authenticationService);
        this.userNodeRef = TestWithUserUtils.getCurrentUser(this.authenticationService);
        this.permissionService.setPermission(this.rootNodeRef, this.userName, "All", true);
        this.permissionService.setPermission(this.nodeRef, this.userName, "All", true);
        this.folderNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, "folder")).getChildRef();
        this.fileNodeRef = this.nodeService.createNode(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, "file")).getChildRef();
        contentWriter = this.contentService.getWriter(this.fileNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(CONTENT_1);
    }

    private Map<QName, Serializable> createTypePropertyBag() {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        result.put(PROP_NAME_QNAME, (Serializable)((Object)TEST_VALUE_NAME));
        return result;
    }

    public void testCheckOut() {
        this.checkout();
    }

    private NodeRef checkout() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_COPIEDFROM));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        String name = (String)((Object)this.nodeService.getProperty(this.nodeRef, PROP_NAME_QNAME));
        String expectedWorkingCopyLabel = I18NUtil.getMessage((String)"coci_service.working_copy_label");
        CheckOutCheckInServiceImpl cfr_ignored_0 = (CheckOutCheckInServiceImpl)this.cociService;
        String expectedWorkingCopyName = CheckOutCheckInServiceImpl.createWorkingCopyName(name, expectedWorkingCopyLabel);
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)expectedWorkingCopyName, (String)workingCopyName);
        CheckOutCheckInServiceImplTest.assertEquals((String)"No record of working copy label kept", (Object)expectedWorkingCopyLabel, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_LABEL));
        ContentReader contentReader = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader);
        ContentReader contentReader2 = this.contentService.getReader(workingCopy, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader2);
        CheckOutCheckInServiceImplTest.assertEquals((String)"The content string of the working copy should match the original immediatly after checkout.", (String)contentReader.getContentString(), (String)contentReader2.getContentString());
        return workingCopy;
    }

    public void testCheckIn() {
        NodeRef workingCopy = this.checkout();
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
        NodeRef workingCopy3 = this.checkout();
        this.nodeService.setProperty(workingCopy3, PROP_NAME_QNAME, (Serializable)((Object)TEST_VALUE_2));
        this.nodeService.setProperty(workingCopy3, PROP2_QNAME, (Serializable)((Object)TEST_VALUE_3));
        ContentWriter tempWriter = this.contentService.getWriter(workingCopy3, ContentModel.PROP_CONTENT, false);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)tempWriter);
        tempWriter.putContent(CONTENT_2);
        String contentUrl = tempWriter.getContentUrl();
        HashMap<String, Serializable> versionProperties3 = new HashMap<String, Serializable>();
        versionProperties3.put("description", (Serializable)((Object)"description"));
        versionProperties3.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        NodeRef origNodeRef = this.cociService.checkin(workingCopy3, versionProperties3, contentUrl, true);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)origNodeRef);
        ContentReader contentReader = this.contentService.getReader(origNodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader);
        CheckOutCheckInServiceImplTest.assertEquals((String)CONTENT_2, (String)contentReader.getContentString());
        Version version = this.versionService.getCurrentVersion(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)version);
        CheckOutCheckInServiceImplTest.assertEquals((String)"description", (String)version.getDescription());
        CheckOutCheckInServiceImplTest.assertEquals((Object)((Object)VersionType.MAJOR), (Object)((Object)version.getVersionType()));
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionNodeRef);
        ContentReader versionContentReader = this.contentService.getReader(versionNodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionContentReader);
        CheckOutCheckInServiceImplTest.assertEquals((String)CONTENT_2, (String)versionContentReader.getContentString());
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_2, (Object)this.nodeService.getProperty(versionNodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_2, (Object)this.nodeService.getProperty(origNodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_3, (Object)this.nodeService.getProperty(versionNodeRef, PROP2_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_3, (Object)this.nodeService.getProperty(origNodeRef, PROP2_QNAME));
        this.cociService.cancelCheckout(workingCopy3);
        NodeRef workingCopy2 = this.checkout();
        HashMap<String, Serializable> versionProperties2 = new HashMap<String, Serializable>();
        versionProperties2.put("description", (Serializable)((Object)"Another version test"));
        this.cociService.checkin(workingCopy2, versionProperties2, null, true);
        this.cociService.checkin(workingCopy2, new HashMap<String, Serializable>(), null, true);
    }

    public void testCheckOutCheckInWithDifferentLocales() {
        Locale.setDefault(Locale.FRANCE);
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy name not correct", (String)"myDocument (Copie de Travail).doc", (String)workingCopyName);
        Locale.setDefault(Locale.UK);
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
        String name = (String)((Object)this.nodeService.getProperty(this.nodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy label was not removed.", (String)TEST_VALUE_NAME, (String)name);
    }

    public void testCheckOutCheckInWithAlteredWorkingCopyName() {
        Locale.setDefault(Locale.FRANCE);
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy name not correct", (String)"myDocument (Copie de Travail).doc", (String)workingCopyName);
        this.nodeService.setProperty(workingCopy, PROP_NAME_QNAME, (Serializable)((Object)"newName (Copie de Travail).doc"));
        Locale.setDefault(Locale.UK);
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
        String name = (String)((Object)this.nodeService.getProperty(this.nodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((String)"File not renamed correctly.", (String)"newName.doc", (String)name);
    }

    public void testCheckInWithNameChange() {
        NodeRef fileWorkingCopyNodeRef = this.cociService.checkout(this.fileNodeRef);
        NodeRef fileWorkingCopyNodeRefCheck = this.cociService.getWorkingCopy(this.fileNodeRef);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Working copy not found ", (Object)fileWorkingCopyNodeRef, (Object)fileWorkingCopyNodeRefCheck);
        this.nodeService.setProperty(fileWorkingCopyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"renamed"));
        this.cociService.checkin(fileWorkingCopyNodeRef, null);
    }

    public void testCheckOutCheckInWithTranslatableAspect() {
        NodeRef translationNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"translation"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(this.nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"translatable"), null);
        this.nodeService.createAssociation(this.nodeRef, translationNodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"translations"));
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
    }

    public void testVersionAspectNotSetOnCheckIn() {
        Map<QName, Serializable> bagOfProps = this.createTypePropertyBag();
        bagOfProps.put(ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, "UTF-8"));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, bagOfProps);
        NodeRef noVersionNodeRef = childAssocRef.getChildRef();
        NodeRef workingCopy = this.cociService.checkout(noVersionNodeRef);
        this.cociService.checkin(workingCopy, new HashMap<String, Serializable>());
        CheckOutCheckInServiceImplTest.assertNull((Object)this.versionService.getVersionHistory(noVersionNodeRef));
    }

    public void testCancelCheckOut() {
        NodeRef workingCopy = this.checkout();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.lockService.checkForLock(this.nodeRef);
            CheckOutCheckInServiceImplTest.fail((String)"The origional should be locked now.");
        }
        catch (Throwable exception) {
            // empty catch block
        }
        NodeRef origNodeRef = this.cociService.cancelCheckout(workingCopy);
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.nodeRef, (Object)origNodeRef);
        this.lockService.checkForLock(origNodeRef);
    }

    public void testAutoCancelCheckOut() {
        Date modifiedDateBeforeCheckOut = (Date)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        NodeRef workingCopy = this.checkout();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.lockService.checkForLock(this.nodeRef);
            CheckOutCheckInServiceImplTest.fail((String)"The original should be locked now.");
        }
        catch (Throwable exception) {
            // empty catch block
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.nodeService.deleteNode(workingCopy);
        Date modifiedDateAfterCheckOut = (Date)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((Object)modifiedDateBeforeCheckOut, (Object)modifiedDateAfterCheckOut);
        this.lockService.checkForLock(this.nodeRef);
    }

    public void testBidirectionalReferences() {
        final NodeRef origNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test2"), ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef wk1 = this.cociService.getWorkingCopy(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk1);
        final NodeRef workingCopy = this.cociService.checkout(origNodeRef);
        CheckOutCheckInServiceImplTest.assertTrue((String)"Expect cm:workingcopy aspect", (boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((String)"Expect cm:checkedOut aspect", (boolean)this.nodeService.hasAspect(origNodeRef, ContentModel.ASPECT_CHECKED_OUT));
        List targetAssocs = this.nodeService.getTargetAssocs(origNodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Expect a 1:1 relationship", (int)1, (int)targetAssocs.size());
        List sourceAssocs = this.nodeService.getSourceAssocs(workingCopy, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Expect a 1:1 relationship", (int)1, (int)sourceAssocs.size());
        this.setComplete();
        this.endTransaction();
        final NodeRef finalNodeRef = origNodeRef;
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                NodeRef wk2 = CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(finalNodeRef);
                Assert.assertNotNull((Object)wk2);
                Assert.assertEquals((Object)workingCopy, (Object)wk2);
                NodeRef orig2 = CheckOutCheckInServiceImplTest.this.cociService.getCheckedOut(wk2);
                Assert.assertNotNull((Object)orig2);
                Assert.assertEquals((Object)origNodeRef, (Object)orig2);
                CheckOutCheckInServiceImplTest.this.cociService.cancelCheckout(workingCopy);
                return null;
            }
        });
        NodeRef wk3 = this.cociService.getWorkingCopy(this.nodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk3);
    }

    public void testETWOTWO_733() {
        NodeRef origNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test2"), ContentModel.TYPE_CONTENT).getChildRef();
        this.copyService.copyAndRename(origNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test6"), false);
        NodeRef wk1 = this.cociService.getWorkingCopy(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk1);
        final NodeRef workingCopy = this.cociService.checkout(origNodeRef);
        this.setComplete();
        this.endTransaction();
        final NodeRef finalNodeRef = origNodeRef;
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                NodeRef wk2 = CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(finalNodeRef);
                Assert.assertNotNull((Object)wk2);
                Assert.assertEquals((Object)workingCopy, (Object)wk2);
                CheckOutCheckInServiceImplTest.this.cociService.cancelCheckout(workingCopy);
                return null;
            }
        });
        NodeRef wk3 = this.cociService.getWorkingCopy(this.nodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk3);
    }

    public void testAR1056() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy2"));
            CheckOutCheckInServiceImplTest.fail((String)"This document has been checked out twice.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMultipleCheckoutsCheckInsWithPropChange() {
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, null);
        final NodeRef testNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(testNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.setComplete();
        this.endTransaction();
        final NodeRef workingCopy1 = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                return CheckOutCheckInServiceImplTest.this.cociService.checkout(testNodeRef);
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                CheckOutCheckInServiceImplTest.this.nodeService.setProperty(workingCopy1, ContentModel.PROP_AUTHOR, (Serializable)((Object)"author1"));
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
                versionProperties.put("description", (Serializable)((Object)"This is a test version 1"));
                CheckOutCheckInServiceImplTest.this.cociService.checkin(workingCopy1, versionProperties);
                return null;
            }
        });
        final NodeRef workingCopy2 = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                return CheckOutCheckInServiceImplTest.this.cociService.checkout(testNodeRef);
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                CheckOutCheckInServiceImplTest.this.nodeService.setProperty(workingCopy2, ContentModel.PROP_AUTHOR, (Serializable)((Object)"author2"));
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
                versionProperties.put("description", (Serializable)((Object)"This is a test version 2"));
                CheckOutCheckInServiceImplTest.this.cociService.checkin(workingCopy2, versionProperties);
                return null;
            }
        });
        final NodeRef workingCopy3 = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                return CheckOutCheckInServiceImplTest.this.cociService.checkout(testNodeRef);
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                CheckOutCheckInServiceImplTest.this.nodeService.setProperty(workingCopy3, ContentModel.PROP_AUTHOR, (Serializable)((Object)"author3"));
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
                versionProperties.put("description", (Serializable)((Object)"This is a test version 3"));
                CheckOutCheckInServiceImplTest.this.cociService.checkin(workingCopy3, versionProperties);
                return null;
            }
        });
    }

    public void testAlfrescoCheckoutDoesNotModifyNode() {
        String adminUser = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)adminUser);
        Serializable initModifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        Serializable initModified = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertFalse((String)"The initial modifier should not be Admin!", (boolean)adminUser.equals(initModifier));
        NodeRef copy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        Serializable modifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Checkout should not cause the modifier to change!", (Object)initModifier, (Object)modifier);
        Serializable modified = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Checkout should not cause the modified date to change!", (Object)initModified, (Object)modified);
        this.cociService.cancelCheckout(copy);
        modifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Cancel checkout should not cause the modifier to change!", (Object)initModifier, (Object)modifier);
        modified = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        CheckOutCheckInServiceImplTest.assertEquals((String)"Cancel checkout should not cause the modified date to change!", (Object)initModified, (Object)modified);
        copy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(copy, versionProperties);
        modifier = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER);
        CheckOutCheckInServiceImplTest.assertEquals((String)"The modifier should change to Admin after checkin!", (Object)adminUser, (Object)modifier);
    }

    public void testCheckOutPermissions_ALF7680_ALF535() {
        NodeRef folder1 = this.createFolderWithPermission(this.rootNodeRef, this.userName, "Consumer");
        NodeRef node = this.createNodeWithPermission(folder1, this.userName, "Editor");
        NodeRef workingCopy = this.cociService.checkout(node, folder1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        this.cociService.cancelCheckout(workingCopy);
        NodeRef folder2 = this.createFolderWithPermission(this.rootNodeRef, this.userName, "All");
        workingCopy = this.cociService.checkout(node, folder2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        this.cociService.cancelCheckout(workingCopy);
        NodeRef folder3 = this.createFolderWithPermission(this.rootNodeRef, this.userName, "Consumer");
        try {
            workingCopy = this.cociService.checkout(node, folder3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
            CheckOutCheckInServiceImplTest.fail((String)"Node can't be checked out to folder where user has no permissions to create children");
        }
        catch (Exception e) {
            // empty catch block
        }
        NodeRef node2 = this.createNodeWithPermission(folder3, this.userName, "Consumer");
        try {
            workingCopy = this.cociService.checkout(node2, folder3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
            CheckOutCheckInServiceImplTest.fail((String)"Node can't be checked out if user has no permissions to edit document");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testCheckInLockableAspectDoesntCopies_ALF16194() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
        if (this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            CheckOutCheckInServiceImplTest.fail((String)"Lockable aspect should not be copied from the working copy to the original document");
        }
    }

    private NodeRef createFolderWithPermission(NodeRef parent, String username, String permission) {
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        NodeRef folder = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("TestFolder" + GUID.generate())), ContentModel.TYPE_CONTENT).getChildRef();
        this.permissionService.deletePermissions(folder);
        this.permissionService.setInheritParentPermissions(folder, false);
        this.permissionService.setPermission(folder, this.userName, permission, true);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, this.authenticationService);
        return folder;
    }

    private NodeRef createNodeWithPermission(NodeRef parent, String username, String permission) {
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        NodeRef node = this.copyService.copy(this.nodeRef, parent, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT);
        this.permissionService.deletePermissions(node);
        this.permissionService.setInheritParentPermissions(node, false);
        this.permissionService.setPermission(node, this.userName, permission, true);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, this.authenticationService);
        return node;
    }
}

