/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.ContentMinimalContextTestSuite;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class AbstractContentReaderLimitTest {
    private static final int K = 1024;
    private static final int M = 0x100000;
    private static final long SIZE = 5120L;
    private static final long MS_PER_BYTE = 1L;
    private static final long LARGE_SIZE = 0x6400000L;
    private static final long MS_PER_MB = 5L;
    private static final int MARGIN_OF_ERROR_PERCENTAGE_SLOW = 50;
    private static final int MARGIN_OF_ERROR_PERCENTAGE_FAST = 900;
    private DummyAbstractContentReader reader;
    private TransformationOptionLimits limits;
    private TransformerDebug transformerDebug;
    private long minTime;
    private long maxTime;
    private long minLength;
    private long maxLength;

    @Before
    public void setUp() throws Exception {
        ApplicationContext ctx = ContentMinimalContextTestSuite.getContext();
        this.transformerDebug = (TransformerDebug)ctx.getBean("transformerDebug");
        this.limits = new TransformationOptionLimits();
        this.reader = new DummyAbstractContentReader(5120L, 1L);
        this.reader.setLimits(this.limits);
        this.reader.setTransformerDebug(this.transformerDebug);
        this.reader.setUseBufferedInputStream(false);
    }

    @Test
    public void noLimitTest() throws Exception {
        this.readAndCheck();
    }

    @Test(expected=ContentIOException.class)
    public void maxKBytesTest() throws Exception {
        this.limits.setMaxSourceSizeKBytes(1L);
        this.readAndCheck();
    }

    @Test(expected=ContentIOException.class)
    public void maxTimeTest() throws Exception {
        this.limits.setTimeoutMs(1000L);
        this.readAndCheck();
    }

    @Test(expected=ContentIOException.class)
    public void maxTimeAndKBytesTest() throws Exception {
        this.limits.setTimeoutMs(1000L);
        this.limits.setMaxSourceSizeKBytes(1L);
        this.readAndCheck();
    }

    @Test
    public void limitKBytesTest() throws Exception {
        this.limits.setReadLimitKBytes(1L);
        this.readAndCheck();
    }

    @Test
    public void limitTimeTest() throws Exception {
        this.limits.setReadLimitTimeMs(1000L);
        this.readAndCheck();
    }

    @Test
    public void limitTimeAndKBytesTest() throws Exception {
        this.limits.setReadLimitTimeMs(1000L);
        this.limits.setReadLimitKBytes(1L);
        this.readAndCheck();
    }

    @Test
    public void fullSpeedReader() throws Exception {
        this.reader = new DummyAbstractContentReader(0x6400000L, 0L);
        this.reader.setLimits(this.limits);
        this.reader.setTransformerDebug(this.transformerDebug);
        this.reader.setUseBufferedInputStream(true);
        this.readAndCheck();
    }

    private void readAndCheck() throws Exception {
        ContentIOException exception = null;
        long length = 0L;
        long time = System.currentTimeMillis();
        try {
            String content = this.reader.getContentString();
            length = content.length();
        }
        catch (ContentIOException e) {
            exception = e;
        }
        time = System.currentTimeMillis() - time;
        this.calcMaxMinValues();
        System.out.printf("Time %04d %04d..%04d length %04d %04d..%04d %s\n", time, this.minTime, this.maxTime, length, this.minLength, this.maxLength, exception == null ? "" : ((Object)((Object)exception)).getClass().getSimpleName());
        Assert.assertTrue((String)("Reader is too fast (" + time + "ms range is " + this.minTime + "..." + this.maxTime + "ms)"), (time >= this.minTime ? 1 : 0) != 0);
        Assert.assertTrue((String)("Reader is too slow (" + time + "ms range is " + this.minTime + "..." + this.maxTime + "ms)"), (time <= this.maxTime ? 1 : 0) != 0);
        if (exception != null) {
            throw exception;
        }
        Assert.assertTrue((String)("Content is too short (" + length + " bytes range is " + this.minLength + "..." + this.maxLength + ")"), (length >= this.minLength ? 1 : 0) != 0);
        Assert.assertTrue((String)("Content is too long (" + length + " bytes range is " + this.minLength + "..." + this.maxLength + ")"), (length <= this.maxLength ? 1 : 0) != 0);
    }

    private void calcMaxMinValues() {
        long size = this.reader.size;
        long timeout = this.limits.getTimePair().getValue();
        Assert.assertTrue((String)("The test time value (" + timeout + "ms) should be lowered given the file size (" + size + ") and the margin of error (of " + this.marginOfError(timeout) + "ms)"), (timeout <= 0L || this.msToBytes(timeout + this.marginOfError(timeout)) <= size ? 1 : 0) != 0);
        long readKBytes = this.limits.getKBytesPair().getValue();
        long readBytes = readKBytes * 1024L;
        Assert.assertTrue((String)("The test KByte value (" + readKBytes + "K) should be lowered given the file size (" + size + ") and the margin of error (of " + this.marginOfError(readBytes) + "bytes)"), (readBytes <= 0L || readBytes + this.marginOfError(readBytes) <= size ? 1 : 0) != 0);
        long bytes = readBytes > 0L ? readBytes : size;
        long readTime = this.bytesToMs(bytes);
        this.minTime = timeout > 0L ? Math.min(timeout, readTime) : readTime;
        this.maxTime = this.minTime + this.marginOfError(this.minTime);
        this.minLength = timeout > 0L ? this.msToBytes(this.minTime - this.marginOfError(this.minTime)) : bytes;
        this.maxLength = timeout > 0L ? Math.min(this.msToBytes(this.maxTime), size) : bytes;
    }

    private long msToBytes(long ms) {
        return this.reader.msPerByte > 0L ? ms / this.reader.msPerByte : ms / 5L * 0x100000L;
    }

    private long bytesToMs(long bytes) {
        return this.reader.msPerByte > 0L ? bytes * this.reader.msPerByte : bytes * 5L / 0x100000L;
    }

    private long marginOfError(long value) {
        return value * (long)(this.reader.msPerByte > 0L ? 50 : 900) / 100L;
    }

    public static class DummyAbstractContentReader
    extends AbstractContentReader {
        final long size;
        final long msPerByte;

        public DummyAbstractContentReader(long size, long msPerByte) {
            super("a");
            this.size = size;
            this.msPerByte = msPerByte;
        }

        @Override
        protected ContentReader createReader() throws ContentIOException {
            return new DummyAbstractContentReader(this.size, this.msPerByte);
        }

        @Override
        protected ReadableByteChannel getDirectReadableChannel() throws ContentIOException {
            InputStream is = new InputStream(){
                long read = 0L;
                long start = 0L;

                @Override
                public int read() throws IOException {
                    if (this.read >= DummyAbstractContentReader.this.size) {
                        return -1;
                    }
                    ++this.read;
                    if (DummyAbstractContentReader.this.msPerByte > 0L) {
                        long elapse = System.currentTimeMillis() - this.start;
                        if (this.read == 1L) {
                            this.start = elapse;
                        } else {
                            long delay = this.read * DummyAbstractContentReader.this.msPerByte - elapse;
                            if (delay > 0L) {
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    return 97;
                }

                @Override
                public boolean markSupported() {
                    return true;
                }
            };
            return Channels.newChannel(is);
        }

        public boolean exists() {
            return true;
        }

        public long getLastModified() {
            return 0L;
        }

        public long getSize() {
            return this.size;
        }
    }
}

