/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.Locale;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractWritableContentStoreTest
extends AbstractReadOnlyContentStoreTest {
    private static Log logger = LogFactory.getLog(AbstractWritableContentStoreTest.class);

    @Override
    protected String getExistingContentUrl() {
        ContentWriter writer = this.getWriter();
        writer.putContent("Content for " + this.getName());
        return writer.getContentUrl();
    }

    protected ContentWriter getWriter() {
        ContentStore store = this.getStore();
        return store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
    }

    @Override
    public void testSetUp() throws Exception {
        ContentStore store = this.getStore();
        AbstractWritableContentStoreTest.assertNotNull((String)"No store provided", (Object)store);
        AbstractWritableContentStoreTest.assertTrue((String)"The same instance of the store must be returned for getStore", (store == this.getStore() ? 1 : 0) != 0);
    }

    public void testWritable() throws Exception {
        ContentStore store = this.getStore();
        AbstractWritableContentStoreTest.assertTrue((String)"The store cannot be read-only", (boolean)store.isWriteSupported());
    }

    public void testSpaceUsed() throws Exception {
        ContentStore store = this.getStore();
        store.getSpaceUsed();
    }

    public void testSpaceFree() throws Exception {
        ContentStore store = this.getStore();
        store.getSpaceFree();
    }

    public void testSpaceTotal() throws Exception {
        ContentStore store = this.getStore();
        store.getSpaceTotal();
    }

    public void testRootLocation() throws Exception {
        ContentStore store = this.getStore();
        String rootLocation = store.getRootLocation();
        AbstractWritableContentStoreTest.assertNotNull((String)"The root location may not be null", (Object)rootLocation);
    }

    private void checkIllegalWritableContentUrl(ContentStore store, String contentUrl) {
        AbstractWritableContentStoreTest.assertFalse((String)"This check is for unsupported content URLs only", (boolean)store.isContentUrlSupported(contentUrl));
        ContentContext bogusContentCtx = new ContentContext(null, contentUrl);
        try {
            store.getWriter(bogusContentCtx);
            AbstractWritableContentStoreTest.fail((String)"Expected UnsupportedContentUrlException, but got nothing");
        }
        catch (UnsupportedContentUrlException e) {
            // empty catch block
        }
    }

    public void testIllegalWritableContentUrls() {
        ContentStore store = this.getStore();
        this.checkIllegalWritableContentUrl(store, "://bogus");
        this.checkIllegalWritableContentUrl(store, "bogus://");
        this.checkIllegalWritableContentUrl(store, "bogus://bogus");
    }

    public void testSimpleUse() {
        ContentStore store = this.getStore();
        String content = "Content for " + this.getName();
        ContentWriter writer = store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
        AbstractWritableContentStoreTest.assertNotNull((String)"Writer may not be null", (Object)writer);
        String contentUrlBefore = writer.getContentUrl();
        AbstractWritableContentStoreTest.assertNotNull((String)"Content URL may not be null for unused writer", (Object)contentUrlBefore);
        AbstractWritableContentStoreTest.assertTrue((String)("URL is not valid: " + contentUrlBefore), (boolean)AbstractContentStore.isValidContentUrl(contentUrlBefore));
        writer.putContent(content);
        String contentUrlAfter = writer.getContentUrl();
        AbstractWritableContentStoreTest.assertTrue((String)("URL is not valid: " + contentUrlBefore), (boolean)AbstractContentStore.isValidContentUrl(contentUrlAfter));
        AbstractWritableContentStoreTest.assertEquals((String)"The content URL may not change just because the writer has put content", (String)contentUrlBefore, (String)contentUrlAfter);
        ContentReader reader = store.getReader(contentUrlBefore);
        AbstractWritableContentStoreTest.assertNotNull((String)"Reader from store is null", (Object)reader);
        AbstractWritableContentStoreTest.assertEquals((String)reader.getContentUrl(), (String)writer.getContentUrl());
        String checkContent = reader.getContentString();
        AbstractWritableContentStoreTest.assertEquals((String)"Content is different", (String)content, (String)checkContent);
    }

    public synchronized void testGetReader() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
        String contentUrl = writer.getContentUrl();
        ContentReader readerFromStoreBeforeWrite = store.getReader(contentUrl);
        AbstractWritableContentStoreTest.assertNotNull((String)"A reader must always be available from the store", (Object)readerFromStoreBeforeWrite);
        ContentReader readerFromWriterBeforeWrite = writer.getReader();
        AbstractWritableContentStoreTest.assertNotNull((String)"A reader must always be available from the writer", (Object)readerFromWriterBeforeWrite);
        String content = "Content for " + this.getName();
        long before = System.currentTimeMillis();
        ((Object)((Object)this)).wait(1000L);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.setLocale(Locale.CHINESE);
        writer.putContent(content);
        ((Object)((Object)this)).wait(1000L);
        long after = System.currentTimeMillis();
        ContentReader readerFromStore = store.getReader(contentUrl);
        AbstractWritableContentStoreTest.assertNotNull((Object)readerFromStore);
        AbstractWritableContentStoreTest.assertTrue((boolean)readerFromStore.exists());
        AbstractWritableContentStoreTest.assertEquals((String)content, (String)readerFromStore.getContentString());
        ContentReader readerFromWriter = writer.getReader();
        AbstractWritableContentStoreTest.assertNotNull((Object)readerFromWriter);
        AbstractWritableContentStoreTest.assertTrue((boolean)readerFromWriter.exists());
        AbstractWritableContentStoreTest.assertEquals((Object)writer.getContentData(), (Object)readerFromWriter.getContentData());
        AbstractWritableContentStoreTest.assertEquals((String)content, (String)readerFromWriter.getContentString());
        ContentReader readerFromReader = readerFromWriter.getReader();
        AbstractWritableContentStoreTest.assertNotNull((Object)readerFromReader);
        AbstractWritableContentStoreTest.assertTrue((boolean)readerFromReader.exists());
        AbstractWritableContentStoreTest.assertEquals((Object)writer.getContentData(), (Object)readerFromReader.getContentData());
        AbstractWritableContentStoreTest.assertEquals((String)content, (String)readerFromReader.getContentString());
        int length = content.getBytes(writer.getEncoding()).length;
        AbstractWritableContentStoreTest.assertEquals((String)"Reader content length is incorrect", (long)length, (long)readerFromWriter.getSize());
        long modifiedTimeCheck = readerFromWriter.getLastModified();
        long beforeSeconds = before / 1000L;
        long afterSeconds = after / 1000L;
        long modifiedTimeCheckSeconds = modifiedTimeCheck / 1000L;
        AbstractWritableContentStoreTest.assertTrue((String)"Reader last modified is incorrect", (beforeSeconds <= modifiedTimeCheckSeconds ? 1 : 0) != 0);
        AbstractWritableContentStoreTest.assertTrue((String)"Reader last modified is incorrect", (modifiedTimeCheckSeconds <= afterSeconds ? 1 : 0) != 0);
    }

    public void testReaderImmutability() {
        ContentWriter writer = this.getWriter();
        ContentReader readerBeforeWrite = writer.getReader();
        AbstractWritableContentStoreTest.assertNotNull((Object)readerBeforeWrite);
        AbstractWritableContentStoreTest.assertFalse((boolean)readerBeforeWrite.exists());
        writer.putContent("Content for " + this.getName());
        AbstractWritableContentStoreTest.assertFalse((String)"Reader's state changed after write", (boolean)readerBeforeWrite.exists());
        try {
            readerBeforeWrite.getContentString();
            AbstractWritableContentStoreTest.fail((String)"Reader's state changed after write");
        }
        catch (ContentIOException e) {
            // empty catch block
        }
        ContentReader readerAfterWrite = writer.getReader();
        AbstractWritableContentStoreTest.assertTrue((String)"New reader after write should be directed to new content", (boolean)readerAfterWrite.exists());
    }

    public void testMimetypAndEncodingAndLocale() throws Exception {
        ContentWriter writer = this.getWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-16");
        writer.setLocale(Locale.CHINESE);
        String content = "A little bit o' this and a little bit o' that";
        byte[] bytesUtf16 = content.getBytes("UTF-16");
        OutputStream os = writer.getContentOutputStream();
        os.write(bytesUtf16);
        os.close();
        ContentReader reader = writer.getReader();
        AbstractWritableContentStoreTest.assertEquals((String)"Writer -> Reader content URL mismatch", (String)writer.getContentUrl(), (String)reader.getContentUrl());
        AbstractWritableContentStoreTest.assertEquals((String)"Writer -> Reader mimetype mismatch", (String)writer.getMimetype(), (String)reader.getMimetype());
        AbstractWritableContentStoreTest.assertEquals((String)"Writer -> Reader encoding mismatch", (String)writer.getEncoding(), (String)reader.getEncoding());
        AbstractWritableContentStoreTest.assertEquals((String)"Writer -> Reader locale mismatch", (Object)writer.getLocale(), (Object)reader.getLocale());
        String contentCheck = reader.getContentString();
        AbstractWritableContentStoreTest.assertEquals((String)"Encoding and decoding of strings failed", (String)content, (String)contentCheck);
    }

    public void testClosedState() throws Exception {
        ContentWriter writer = this.getWriter();
        ContentReader readerBeforeWrite = writer.getReader();
        AbstractWritableContentStoreTest.assertFalse((String)"Reader stream should not be closed", (boolean)readerBeforeWrite.isClosed());
        AbstractWritableContentStoreTest.assertFalse((String)"Writer stream should not be closed", (boolean)writer.isClosed());
        writer.putContent("ABC");
        AbstractWritableContentStoreTest.assertTrue((String)"Writer stream should be closed", (boolean)writer.isClosed());
        ContentReader readerAfterWrite = writer.getReader();
        AbstractWritableContentStoreTest.assertNotNull((String)"No reader given by closed writer", (Object)readerAfterWrite);
        AbstractWritableContentStoreTest.assertFalse((String)"Before-content reader should not be affected by content updates", (boolean)readerBeforeWrite.isClosed());
        AbstractWritableContentStoreTest.assertFalse((String)"After content reader should not be closed", (boolean)readerAfterWrite.isClosed());
        ContentReader newReaderA = writer.getReader();
        ContentReader newReaderB = writer.getReader();
        AbstractWritableContentStoreTest.assertFalse((String)"Reader must always be a new instance", (newReaderA == newReaderB ? 1 : 0) != 0);
        AbstractWritableContentStoreTest.assertEquals((String)"Readers should refer to same URL", (String)readerBeforeWrite.getContentUrl(), (String)readerAfterWrite.getContentUrl());
        try {
            readerBeforeWrite.getContentString();
        }
        catch (Throwable e) {
            // empty catch block
        }
        String contentCheck = readerAfterWrite.getContentString();
        AbstractWritableContentStoreTest.assertEquals((String)"Incorrect content", (String)"ABC", (String)contentCheck);
        AbstractWritableContentStoreTest.assertFalse((String)"Before-content reader stream should not be closed", (boolean)readerBeforeWrite.isClosed());
        AbstractWritableContentStoreTest.assertTrue((String)"After-content reader should be closed after reading", (boolean)readerAfterWrite.isClosed());
    }

    private boolean searchForUrl(ContentStore store, final String contentUrl, Date from, Date to) {
        final boolean[] found = new boolean[]{false};
        ContentStore.ContentUrlHandler handler = new ContentStore.ContentUrlHandler(){

            @Override
            public void handle(String checkContentUrl) {
                if (contentUrl.equals(checkContentUrl)) {
                    found[0] = true;
                }
            }
        };
        this.getStore().getUrls(from, to, handler);
        return found[0];
    }

    public void testGetUrls() {
        ContentWriter writer = this.getWriter();
        writer.putContent("Content for " + this.getName());
        String contentUrl = writer.getContentUrl();
        ContentStore store = this.getStore();
        boolean inStore = this.searchForUrl(store, contentUrl, null, null);
        AbstractWritableContentStoreTest.assertTrue((String)"New content not found in URL set", (boolean)inStore);
    }

    public void testDeleteSimple() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = this.getWriter();
        writer.putContent("Content for " + this.getName());
        String contentUrl = writer.getContentUrl();
        AbstractWritableContentStoreTest.assertTrue((String)"Content must now exist", (boolean)store.exists(contentUrl));
        try {
            store.delete(contentUrl);
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)("Store test " + this.getName() + " not possible on " + store.getClass().getName()));
            return;
        }
        AbstractWritableContentStoreTest.assertFalse((String)"Content must now be removed", (boolean)store.exists(contentUrl));
    }

    public void testDeleteReaderStates() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = this.getWriter();
        String content = "Content for " + this.getName();
        String contentUrl = writer.getContentUrl();
        OutputStream os = writer.getContentOutputStream();
        os.write(content.getBytes());
        os.flush();
        os.close();
        ContentReader reader = store.getReader(contentUrl);
        AbstractWritableContentStoreTest.assertNotNull((Object)reader);
        ContentReader readerCheck = writer.getReader();
        AbstractWritableContentStoreTest.assertNotNull((Object)readerCheck);
        AbstractWritableContentStoreTest.assertEquals((String)"Store and write provided readers onto different URLs", (String)writer.getContentUrl(), (String)reader.getContentUrl());
        InputStream is = reader.getContentInputStream();
        boolean deleted = store.delete(contentUrl);
        is.close();
        reader = store.getReader(contentUrl);
        AbstractWritableContentStoreTest.assertNotNull((Object)reader);
        if (deleted) {
            AbstractWritableContentStoreTest.assertFalse((String)"Content should not exist", (boolean)reader.exists());
            return;
        }
        AbstractWritableContentStoreTest.assertTrue((String)"Content should exist", (boolean)reader.exists());
        store.delete(contentUrl);
        try {
            is = reader.getContentInputStream();
            AbstractWritableContentStoreTest.fail((String)"Reader failed to detect underlying content deletion");
        }
        catch (ContentIOException e) {
            // empty catch block
        }
        reader = store.getReader(contentUrl);
        AbstractWritableContentStoreTest.assertNotNull((String)"Reader must be returned even when underlying content is missing", (Object)reader);
        AbstractWritableContentStoreTest.assertFalse((String)"Content should not exist", (boolean)reader.exists());
        try {
            is = reader.getContentInputStream();
            AbstractWritableContentStoreTest.fail((String)"Reader opened stream onto missing content");
        }
        catch (ContentIOException e) {
            // empty catch block
        }
    }

    public void testWriteStreamListener() throws Exception {
        ContentWriter writer = this.getWriter();
        final boolean[] streamClosed = new boolean[]{false};
        ContentStreamListener listener = new ContentStreamListener(){

            public void contentStreamClosed() throws ContentIOException {
                streamClosed[0] = true;
            }
        };
        writer.addListener(listener);
        writer.putContent("ABC");
        AbstractWritableContentStoreTest.assertTrue((String)"Write stream listener was not called for the stream close", (boolean)streamClosed[0]);
    }

    public void testWriteAndReadString() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        writer.putContent(content);
        AbstractWritableContentStoreTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        String check = reader.getContentString();
        AbstractWritableContentStoreTest.assertTrue((String)"Read and write may not share same resource", (check.length() > 0 ? 1 : 0) != 0);
        AbstractWritableContentStoreTest.assertEquals((String)"Write and read didn't work", (String)content, (String)check);
    }

    public void testStringTruncation() throws Exception {
        String content = "1234567890";
        ContentWriter writer = this.getWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        String checkContent = reader.getContentString(5);
        AbstractWritableContentStoreTest.assertEquals((String)"Truncated strings don't match", (String)"12345", (String)checkContent);
    }

    public void testReadAndWriteFile() throws Exception {
        ContentWriter writer = this.getWriter();
        File sourceFile = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
        sourceFile.deleteOnExit();
        String content = "ABC";
        FileOutputStream os = new FileOutputStream(sourceFile);
        os.write(content.getBytes());
        os.flush();
        os.close();
        writer.putContent(sourceFile);
        AbstractWritableContentStoreTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        File sinkFile = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
        sinkFile.deleteOnExit();
        ContentReader reader = writer.getReader();
        reader.getContent(sinkFile);
        FileInputStream is = new FileInputStream(sinkFile);
        byte[] buffer = new byte[100];
        int count = is.read(buffer);
        AbstractWritableContentStoreTest.assertEquals((String)"No content read", (int)3, (int)count);
        is.close();
        String check = new String(buffer, 0, count);
        AbstractWritableContentStoreTest.assertEquals((String)"Write out of and read into files failed", (String)content, (String)check);
    }

    public void testReadAndWriteStreamByPull() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        writer.putContent((InputStream)is);
        AbstractWritableContentStoreTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ByteArrayOutputStream os = new ByteArrayOutputStream(100);
        ContentReader reader = writer.getReader();
        reader.getContent((OutputStream)os);
        byte[] bytes = os.toByteArray();
        String check = new String(bytes);
        AbstractWritableContentStoreTest.assertEquals((String)"Write out and read in using streams failed", (String)content, (String)check);
    }

    public void testReadAndWriteStreamByPush() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        OutputStream os = writer.getContentOutputStream();
        os.write(content.getBytes());
        AbstractWritableContentStoreTest.assertFalse((String)"Stream has not been closed", (boolean)writer.isClosed());
        os.close();
        AbstractWritableContentStoreTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        InputStream is = reader.getContentInputStream();
        byte[] buffer = new byte[100];
        int count = is.read(buffer);
        AbstractWritableContentStoreTest.assertEquals((String)"No content read", (int)3, (int)count);
        is.close();
        String check = new String(buffer, 0, count);
        AbstractWritableContentStoreTest.assertEquals((String)"Write out of and read into files failed", (String)content, (String)check);
    }

    public void testListUrls() throws Exception {
        ContentStore store = this.getStore();
        try {
            this.searchForUrl(store, "abc", null, null);
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)("Store test " + this.getName() + " not possible on " + store.getClass().getName()));
            return;
        }
        ContentWriter writer = this.getWriter();
        String contentUrl = writer.getContentUrl();
        boolean inStore = this.searchForUrl(store, contentUrl, null, null);
        AbstractWritableContentStoreTest.assertTrue((String)"Writer URL not listed by store", (boolean)inStore);
        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
        writer.putContent("The quick brown fox...");
        inStore = this.searchForUrl(store, contentUrl, null, null);
        AbstractWritableContentStoreTest.assertTrue((String)"Writer URL not listed by store", (boolean)inStore);
        inStore = this.searchForUrl(store, contentUrl, null, yesterday);
        AbstractWritableContentStoreTest.assertFalse((String)"URL was younger than required, but still shows up", (boolean)inStore);
    }

    public void testRandomAccessWrite() throws Exception {
        ContentWriter writer = this.getWriter();
        FileChannel fileChannel = writer.getFileChannel(true);
        AbstractWritableContentStoreTest.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            writer.getWritableChannel();
            AbstractWritableContentStoreTest.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        byte[] content = new byte[]{1, 2, 3};
        for (int i = content.length - 1; i >= 0; --i) {
            ByteBuffer buffer = ByteBuffer.wrap(content, i, 1);
            fileChannel.write(buffer, i);
        }
        fileChannel.close();
        AbstractWritableContentStoreTest.assertTrue((String)"Writer not closed", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        ReadableByteChannel channelReader = reader.getReadableChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(3);
        int count = channelReader.read(buffer);
        AbstractWritableContentStoreTest.assertEquals((String)"Incorrect number of bytes read", (int)3, (int)count);
        for (int i = 0; i < content.length; ++i) {
            AbstractWritableContentStoreTest.assertEquals((String)"Content doesn't match", (byte)content[i], (byte)buffer.get(i));
        }
        ContentContext writerTruncateCtx = new ContentContext(writer.getReader(), null);
        ContentWriter writerTruncate = this.getStore().getWriter(writerTruncateCtx);
        AbstractWritableContentStoreTest.assertEquals((String)"Content size incorrect", (long)0L, (long)writerTruncate.getSize());
        FileChannel fcTruncate = writerTruncate.getFileChannel(true);
        fcTruncate.close();
        AbstractWritableContentStoreTest.assertEquals((String)"Content not truncated", (long)0L, (long)writerTruncate.getSize());
        ContentContext writerNoTruncateCtx = new ContentContext(writer.getReader(), null);
        ContentWriter writerNoTruncate = this.getStore().getWriter(writerNoTruncateCtx);
        AbstractWritableContentStoreTest.assertEquals((String)"Content size incorrect", (long)0L, (long)writerNoTruncate.getSize());
        FileChannel fcNoTruncate = writerNoTruncate.getFileChannel(false);
        fcNoTruncate.close();
        AbstractWritableContentStoreTest.assertEquals((String)"Content was truncated", (long)writer.getSize(), (long)writerNoTruncate.getSize());
    }

    @Override
    public void testRandomAccessRead() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        byte[] bytes = content.getBytes();
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        FileChannel fileChannel = reader.getFileChannel();
        AbstractWritableContentStoreTest.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            reader.getReadableChannel();
            AbstractWritableContentStoreTest.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        int count = fileChannel.read(buffer);
        AbstractWritableContentStoreTest.assertEquals((String)"Incorrect number of bytes read", (int)bytes.length, (int)count);
        buffer.rewind();
        buffer.get(bytes);
        String checkContent = new String(bytes);
        AbstractWritableContentStoreTest.assertEquals((String)"Content read failure", (String)content, (String)checkContent);
        fileChannel.close();
    }
}

