/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

public interface ContentLimitProvider {
    public static final long NO_LIMIT = -1L;

    public long getSizeLimit();

    public static class NoLimitProvider
    implements ContentLimitProvider {
        @Override
        public long getSizeLimit() {
            return -1L;
        }
    }

    public static class SimpleFixedLimitProvider
    implements ContentLimitProvider {
        private long limit;

        public SimpleFixedLimitProvider() {
        }

        public SimpleFixedLimitProvider(long limit) {
            this.limit = limit;
        }

        public void setSizeLimitString(String limit) {
            long longLimit = -1L;
            try {
                longLimit = Long.parseLong(limit);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            this.limit = longLimit;
        }

        @Override
        public long getSizeLimit() {
            return this.limit;
        }
    }
}

