/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.content.AbstractContentStreamListener;
import org.alfresco.repo.content.AbstractContentWriter;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.NodeContentContext;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContentServiceImpl
implements ContentService,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(ContentServiceImpl.class);
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private AVMService avmService;
    private MimetypeService mimetypeService;
    private RetryingTransactionHelper transactionHelper;
    private ApplicationContext applicationContext;
    protected TransformerDebug transformerDebug;
    private ContentTransformerRegistry transformerRegistry;
    private EagerContentStoreCleaner eagerContentStoreCleaner;
    private ContentStore store;
    private ContentStore tempStore;
    private ContentTransformer imageMagickContentTransformer;
    private boolean ignoreEmptyContent;
    private boolean transformerFailover;
    private PolicyComponent policyComponent;
    ClassPolicyDelegate<ContentServicePolicies.OnContentUpdatePolicy> onContentUpdateDelegate;
    ClassPolicyDelegate<ContentServicePolicies.OnContentPropertyUpdatePolicy> onContentPropertyUpdateDelegate;
    ClassPolicyDelegate<ContentServicePolicies.OnContentReadPolicy> onContentReadDelegate;

    public void setRetryingTransactionHelper(RetryingTransactionHelper helper) {
        this.transactionHelper = helper;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setTransformerRegistry(ContentTransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    public void setEagerContentStoreCleaner(EagerContentStoreCleaner eagerContentStoreCleaner) {
        this.eagerContentStoreCleaner = eagerContentStoreCleaner;
    }

    public void setStore(ContentStore store) {
        this.store = store;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAvmService(AVMService service) {
        this.avmService = service;
    }

    public void setImageMagickContentTransformer(ContentTransformer imageMagickContentTransformer) {
        this.imageMagickContentTransformer = imageMagickContentTransformer;
    }

    public void setIgnoreEmptyContent(boolean ignoreEmptyContent) {
        this.ignoreEmptyContent = ignoreEmptyContent;
    }

    public void setTransformerFailover(boolean transformerFailover) {
        this.transformerFailover = transformerFailover;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void init() {
        this.tempStore = new FileContentStore(this.applicationContext, TempFileProvider.getTempDir().getAbsolutePath());
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.onContentUpdateDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentUpdatePolicy.class);
        this.onContentPropertyUpdateDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentPropertyUpdatePolicy.class);
        this.onContentReadDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentReadPolicy.class);
    }

    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
            return;
        }
        Set<QName> types = null;
        ContentServicePolicies.OnContentPropertyUpdatePolicy propertyPolicy = null;
        boolean fire = false;
        boolean isNewContent = false;
        for (QName propertyQName : after.keySet()) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            if (propertyDef == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) || propertyDef.isMultiValued()) continue;
            try {
                boolean hasContentAfter;
                ContentData beforeValue = (ContentData)before.get(propertyQName);
                ContentData afterValue = (ContentData)after.get(propertyQName);
                boolean hasContentBefore = ContentData.hasContent((ContentData)beforeValue) && (!this.ignoreEmptyContent || beforeValue.getSize() > 0L);
                boolean bl = hasContentAfter = ContentData.hasContent((ContentData)afterValue) && (!this.ignoreEmptyContent || afterValue.getSize() > 0L);
                if (!hasContentBefore && !hasContentAfter || EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) continue;
                boolean bl2 = isNewContent = isNewContent || !hasContentBefore && hasContentAfter;
                if (!hasContentBefore) {
                    beforeValue = null;
                }
                if (!hasContentAfter) {
                    afterValue = null;
                }
                if (logger.isDebugEnabled()) {
                    String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    logger.debug((Object)("Content property updated: \n   Node Name:   " + name + "\n" + "   Property:    " + propertyQName + "\n" + "   Is new:      " + isNewContent + "\n" + "   Before:      " + beforeValue + "\n" + "   After:       " + afterValue));
                }
                types = this.getTypes(nodeRef, types);
                if (propertyPolicy == null) {
                    propertyPolicy = this.onContentPropertyUpdateDelegate.get(nodeRef, types);
                }
                propertyPolicy.onContentPropertyUpdate(nodeRef, propertyQName, beforeValue, afterValue);
                fire = true;
            }
            catch (ClassCastException e) {}
        }
        if (fire) {
            types = this.getTypes(nodeRef, types);
            ContentServicePolicies.OnContentUpdatePolicy policy = this.onContentUpdateDelegate.get(nodeRef, types);
            policy.onContentUpdate(nodeRef, isNewContent);
        }
    }

    private Set<QName> getTypes(NodeRef nodeRef, Set<QName> types) {
        if (types != null) {
            return types;
        }
        types = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
        types.add(this.nodeService.getType(nodeRef));
        return types;
    }

    @Override
    public long getStoreFreeSpace() {
        return this.store.getSpaceFree();
    }

    @Override
    public long getStoreTotalSpace() {
        return this.store.getSpaceTotal();
    }

    @Override
    public ContentReader getRawReader(String contentUrl) {
        ContentReader reader = null;
        try {
            reader = this.store.getReader(contentUrl);
        }
        catch (UnsupportedContentUrlException e) {
            reader = new EmptyContentReader(contentUrl);
        }
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentStore implementations may not return null ContentReaders");
        }
        reader.setMimetype("application/octet-stream");
        reader.setEncoding("UTF-8");
        reader.setLocale(I18NUtil.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Direct request for reader: \n   Content URL: " + contentUrl + "\n" + "   Reader:      " + reader));
        }
        return reader;
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef, QName propertyQName) {
        return this.getReader(nodeRef, propertyQName, true);
    }

    private ContentReader getReader(NodeRef nodeRef, QName propertyQName, boolean fireContentReadPolicy) {
        PropertyDefinition contentPropDef;
        Collection colPropValue;
        ContentData contentData = null;
        Serializable propValue = this.nodeService.getProperty(nodeRef, propertyQName);
        if (propValue instanceof Collection && (colPropValue = (Collection)((Object)propValue)).size() > 0) {
            propValue = (Serializable)colPropValue.iterator().next();
        }
        if (propValue instanceof ContentData) {
            contentData = (ContentData)propValue;
        }
        if (contentData == null && (contentPropDef = this.dictionaryService.getProperty(propertyQName)) != null && !contentPropDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) && !contentPropDef.getDataType().getName().equals((Object)DataTypeDefinition.ANY)) {
            throw new InvalidTypeException("The node property must be of type content: \n   node: " + nodeRef + "\n" + "   property name: " + propertyQName + "\n" + "   property type: " + (contentPropDef == null ? "unknown" : contentPropDef.getDataType()), propertyQName);
        }
        if (contentData == null || contentData.getContentUrl() == null) {
            return null;
        }
        String contentUrl = contentData.getContentUrl();
        ContentReader reader = this.store.getReader(contentUrl);
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentStore implementations may not return null ContentReaders");
        }
        reader.setMimetype(contentData.getMimetype());
        reader.setEncoding(contentData.getEncoding());
        reader.setLocale(contentData.getLocale());
        if (reader != null && fireContentReadPolicy) {
            HashSet<QName> types = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
            types.add(this.nodeService.getType(nodeRef));
            ContentServicePolicies.OnContentReadPolicy policy = this.onContentReadDelegate.get(nodeRef, types);
            policy.onContentRead(nodeRef);
        }
        return reader;
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef, QName propertyQName, boolean update) {
        if (nodeRef == null) {
            ContentContext ctx = new ContentContext(null, null);
            ContentWriter writer = this.store.getWriter(ctx);
            this.eagerContentStoreCleaner.registerNewContentUrl(writer.getContentUrl());
            return writer;
        }
        ContentReader existingContentReader = this.getReader(nodeRef, propertyQName, false);
        NodeContentContext ctx = new NodeContentContext(existingContentReader, null, nodeRef, propertyQName);
        ContentWriter writer = this.store.getWriter(ctx);
        this.eagerContentStoreCleaner.registerNewContentUrl(writer.getContentUrl());
        Serializable contentValue = null;
        if (nodeRef.getStoreRef().getProtocol().equals("avm")) {
            Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
            contentValue = this.avmService.getContentDataForWrite((String)avmVersionPath.getSecond());
        } else {
            contentValue = this.nodeService.getProperty(nodeRef, propertyQName);
        }
        if (contentValue != null && contentValue instanceof ContentData) {
            ContentData contentData = (ContentData)contentValue;
            writer.setMimetype(contentData.getMimetype());
            writer.setEncoding(contentData.getEncoding());
            writer.setLocale(contentData.getLocale());
        }
        if (update) {
            WriteStreamListener listener = new WriteStreamListener(this.nodeService, nodeRef, propertyQName, writer);
            listener.setRetryingTransactionHelper(this.transactionHelper);
            writer.addListener((ContentStreamListener)listener);
        }
        if (writer instanceof AbstractContentWriter) {
            ((AbstractContentWriter)writer).setMimetypeService(this.mimetypeService);
        }
        return writer;
    }

    @Override
    public ContentWriter getTempWriter() {
        return this.tempStore.getWriter(ContentContext.NULL_CONTEXT);
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer) {
        TransformationOptions options = new TransformationOptions();
        this.transform(reader, writer, options);
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws NoTransformerException, ContentIOException {
        this.transform(reader, writer, new TransformationOptions(options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws NoTransformerException, ContentIOException {
        if (reader == null) {
            throw new AlfrescoRuntimeException("The content reader must be set");
        }
        String sourceMimetype = reader.getMimetype();
        if (sourceMimetype == null) {
            throw new AlfrescoRuntimeException("The content reader mimetype must be set: " + reader);
        }
        String targetMimetype = writer.getMimetype();
        if (targetMimetype == null) {
            throw new AlfrescoRuntimeException("The content writer mimetype must be set: " + writer);
        }
        long sourceSize = reader.getSize();
        try {
            this.transformerDebug.pushAvailable(reader.getContentUrl(), sourceMimetype, targetMimetype, options);
            List<ContentTransformer> transformers = this.getActiveTransformers(sourceMimetype, sourceSize, targetMimetype, options);
            this.transformerDebug.availableTransformers(transformers, sourceSize, "ContentService.transform(...)");
            int count = transformers.size();
            if (count == 0) {
                throw new NoTransformerException(sourceMimetype, targetMimetype);
            }
            if (count == 1 || !this.transformerFailover) {
                ContentTransformer transformer = transformers.size() == 0 ? null : transformers.get(0);
                transformer.transform(reader, writer, options);
            } else {
                this.failoverTransformers(reader, writer, options, targetMimetype, transformers);
            }
        }
        finally {
            if (this.transformerDebug.isEnabled()) {
                this.transformerDebug.popAvailable();
                this.debugActiveTransformers(sourceMimetype, targetMimetype, sourceSize, options);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void failoverTransformers(ContentReader reader, ContentWriter writer, TransformationOptions options, String targetMimetype, List<ContentTransformer> transformers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.getTransformer(null, sourceMimetype, -1L, targetMimetype, new TransformationOptions());
    }

    @Override
    public ContentTransformer getTransformer(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.getTransformer(null, sourceMimetype, -1L, targetMimetype, options);
    }

    @Override
    public ContentTransformer getTransformer(String sourceUrl, String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.getTransformers(sourceUrl, sourceMimetype, sourceSize, targetMimetype, options);
        return transformers == null ? null : transformers.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentTransformer> getTransformers(String sourceUrl, String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        try {
            this.transformerDebug.pushAvailable(sourceUrl, sourceMimetype, targetMimetype, options);
            List<ContentTransformer> transformers = this.getActiveTransformers(sourceMimetype, sourceSize, targetMimetype, options);
            this.transformerDebug.availableTransformers(transformers, sourceSize, "ContentService.getTransformer(...)");
            List<ContentTransformer> list = transformers.isEmpty() ? null : transformers;
            return list;
        }
        finally {
            this.transformerDebug.popAvailable();
        }
    }

    private void debugActiveTransformers(String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions transformOptions) {
        if ("text/plain".equals(sourceMimetype) && "image/png".equals(targetMimetype) && "debugTransformers.txt".equals(this.transformerDebug.getFileName(transformOptions, true, 0L))) {
            Map<String, Set<String>> explicitTransforms = this.debugExplicitTransforms();
            this.debugActiveTransformersByTransformer(explicitTransforms);
            this.debugActiveTransformersByMimetypes(explicitTransforms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugActiveTransformersByTransformer(Map<String, Set<String>> explicitTransforms) {
        try {
            this.transformerDebug.pushMisc();
            this.transformerDebug.debug("Active and inactive transformers");
            TransformationOptions options = new TransformationOptions();
            for (ContentTransformer transformer : this.transformerRegistry.getTransformers()) {
                try {
                    this.transformerDebug.pushMisc();
                    int mimetypePairCount = 0;
                    boolean first = true;
                    for (String sourceMimetype : this.mimetypeService.getMimetypes()) {
                        for (String targetMimetype : this.mimetypeService.getMimetypes()) {
                            if (!transformer.isTransformable(sourceMimetype, -1L, targetMimetype, options)) continue;
                            long maxSourceSizeKBytes = transformer.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
                            Boolean explicit = transformer.isExplicitTransformation(sourceMimetype, targetMimetype, options);
                            if (!explicit.booleanValue()) {
                                Set<String> targetMimetypes = explicitTransforms.get(sourceMimetype);
                                explicit = targetMimetypes == null || !targetMimetypes.contains(targetMimetype) ? null : Boolean.FALSE;
                            }
                            this.transformerDebug.activeTransformer(++mimetypePairCount, transformer, sourceMimetype, targetMimetype, maxSourceSizeKBytes, explicit, first);
                            first = false;
                        }
                    }
                    if (!first) continue;
                    this.transformerDebug.inactiveTransformer(transformer);
                }
                finally {
                    this.transformerDebug.popMisc();
                }
            }
        }
        finally {
            this.transformerDebug.popMisc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugActiveTransformersByMimetypes(Map<String, Set<String>> explicitTransforms) {
        try {
            this.transformerDebug.pushMisc();
            this.transformerDebug.debug("Transformers for each mimetype combination");
            TransformationOptions options = new TransformationOptions();
            for (String sourceMimetype : this.mimetypeService.getMimetypes()) {
                for (String targetMimetype : this.mimetypeService.getMimetypes()) {
                    try {
                        this.transformerDebug.pushMisc();
                        int transformerCount = 0;
                        for (ContentTransformer transformer : this.transformerRegistry.getTransformers()) {
                            if (!transformer.isTransformable(sourceMimetype, -1L, targetMimetype, options)) continue;
                            long maxSourceSizeKBytes = transformer.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
                            Boolean explicit = transformer.isExplicitTransformation(sourceMimetype, targetMimetype, options);
                            if (!explicit.booleanValue()) {
                                Set<String> targetMimetypes = explicitTransforms.get(sourceMimetype);
                                explicit = targetMimetypes == null || !targetMimetypes.contains(targetMimetype) ? null : Boolean.FALSE;
                            }
                            this.transformerDebug.activeTransformer(sourceMimetype, targetMimetype, transformerCount, transformer, maxSourceSizeKBytes, explicit, transformerCount++ == 0);
                        }
                    }
                    finally {
                        this.transformerDebug.popMisc();
                    }
                }
            }
        }
        finally {
            this.transformerDebug.popMisc();
        }
    }

    private Map<String, Set<String>> debugExplicitTransforms() {
        HashMap<String, Set<String>> explicitTransforms = new HashMap<String, Set<String>>();
        TransformationOptions options = new TransformationOptions();
        for (String sourceMimetype : this.mimetypeService.getMimetypes()) {
            block1: for (String targetMimetype : this.mimetypeService.getMimetypes()) {
                for (ContentTransformer transformer : this.transformerRegistry.getTransformers()) {
                    if (!transformer.isTransformable(sourceMimetype, -1L, targetMimetype, options) || !transformer.isExplicitTransformation(sourceMimetype, targetMimetype, options)) continue;
                    HashSet<String> targetMimetypes = (HashSet<String>)explicitTransforms.get(sourceMimetype);
                    if (targetMimetypes == null) {
                        targetMimetypes = new HashSet<String>();
                        explicitTransforms.put(sourceMimetype, targetMimetypes);
                    }
                    targetMimetypes.add(targetMimetype);
                    continue block1;
                }
            }
        }
        return explicitTransforms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxSourceSizeBytes(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        try {
            long maxSourceSize = 0L;
            this.transformerDebug.pushAvailable(null, sourceMimetype, targetMimetype, options);
            List<ContentTransformer> transformers = this.getActiveTransformers(sourceMimetype, -1L, targetMimetype, options);
            for (ContentTransformer transformer : transformers) {
                long maxSourceSizeKBytes = transformer.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
                if (maxSourceSize < 0L) continue;
                if (maxSourceSizeKBytes < 0L) {
                    maxSourceSize = -1L;
                    continue;
                }
                if (maxSourceSizeKBytes <= 0L || maxSourceSize >= maxSourceSizeKBytes) continue;
                maxSourceSize = maxSourceSizeKBytes;
            }
            if (this.transformerDebug.isEnabled()) {
                this.transformerDebug.availableTransformers(transformers, -1L, "ContentService.getMaxSourceSizeBytes() = " + this.transformerDebug.fileSize(maxSourceSize * 1024L));
            }
            long l = maxSourceSize > 0L ? maxSourceSize * 1024L : maxSourceSize;
            return l;
        }
        finally {
            this.transformerDebug.popAvailable();
        }
    }

    @Override
    public List<ContentTransformer> getActiveTransformers(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.getActiveTransformers(sourceMimetype, -1L, targetMimetype, options);
    }

    @Override
    public List<ContentTransformer> getActiveTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return this.transformerRegistry.getActiveTransformers(sourceMimetype, sourceSize, targetMimetype, options);
    }

    @Override
    public ContentTransformer getImageTransformer() {
        return this.imageMagickContentTransformer;
    }

    @Override
    public boolean isTransformable(ContentReader reader, ContentWriter writer) {
        return this.isTransformable(reader, writer, new TransformationOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTransformable(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        String sourceMimetype = reader.getMimetype();
        if (sourceMimetype == null) {
            throw new AlfrescoRuntimeException("The content reader mimetype must be set: " + reader);
        }
        String targetMimetype = writer.getMimetype();
        if (targetMimetype == null) {
            throw new AlfrescoRuntimeException("The content writer mimetype must be set: " + writer);
        }
        long sourceSize = reader.getSize();
        try {
            this.transformerDebug.pushAvailable(reader.getContentUrl(), sourceMimetype, targetMimetype, options);
            List<ContentTransformer> transformers = this.getActiveTransformers(sourceMimetype, sourceSize, targetMimetype, options);
            this.transformerDebug.availableTransformers(transformers, sourceSize, "ContentService.isTransformable(...)");
            boolean bl = transformers.size() > 0;
            return bl;
        }
        finally {
            this.transformerDebug.popAvailable();
        }
    }

    private static class WriteStreamListener
    extends AbstractContentStreamListener {
        private NodeService nodeService;
        private NodeRef nodeRef;
        private QName propertyQName;
        private ContentWriter writer;

        public WriteStreamListener(NodeService nodeService, NodeRef nodeRef, QName propertyQName, ContentWriter writer) {
            this.nodeService = nodeService;
            this.nodeRef = nodeRef;
            this.propertyQName = propertyQName;
            this.writer = writer;
        }

        @Override
        public void contentStreamClosedImpl() throws ContentIOException {
            try {
                ContentData contentData = this.writer.getContentData();
                if (this.nodeRef.getStoreRef().getProtocol().equals("avm")) {
                    this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                } else {
                    this.nodeService.setProperty(this.nodeRef, this.propertyQName, (Serializable)contentData);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Stream listener updated node: \n   node: " + this.nodeRef + "\n" + "   property: " + this.propertyQName + "\n" + "   value: " + contentData));
                }
            }
            catch (ContentQuotaException qe) {
                throw qe;
            }
            catch (Throwable e) {
                throw new ContentIOException("Failed to set content property on stream closure: \n   node: " + this.nodeRef + "\n" + "   property: " + this.propertyQName + "\n" + "   writer: " + this.writer + "\n" + e.toString(), e);
            }
        }
    }
}

