/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.AbstractRoutingContentStore;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;

public class RoutingContentStoreTest
extends AbstractWritableContentStoreTest {
    private ContentStore storeA;
    private ContentStore storeB;
    private ContentStore storeC;
    private ContentStore storeD;
    private ContentStore routingStore;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        File storeADir = new File(tempDir, "A");
        this.storeA = new FileContentStore(ctx, storeADir);
        File storeBDir = new File(tempDir, "B");
        this.storeB = new FileContentStore(ctx, storeBDir);
        File storeCDir = new File(tempDir, "C");
        this.storeC = new DumbReadOnlyFileStore(new FileContentStore(ctx, storeCDir));
        this.storeD = new SupportsNoUrlFormatStore();
        this.routingStore = new RandomRoutingContentStore(this.storeA, this.storeB, this.storeC, this.storeD);
    }

    @Override
    protected ContentStore getStore() {
        return this.routingStore;
    }

    @Override
    public void testSetUp() throws Exception {
        RoutingContentStoreTest.assertNotNull((Object)this.routingStore);
    }

    private void checkForContent(String contentUrl, String content) {
        for (ContentStore store : new ContentStore[]{this.storeA, this.storeB}) {
            if (!store.exists(contentUrl)) continue;
            ContentReader reader = store.getReader(contentUrl);
            String checkContent = reader.getContentString();
            RoutingContentStoreTest.assertEquals((String)"Content found but is incorrect", (String)content, (String)checkContent);
            return;
        }
        RoutingContentStoreTest.fail((String)("Content not found in any of the stores: " + contentUrl));
    }

    public void testMissingUrl() {
        String missingContentUrl = FileContentStore.createNewFileStoreUrl();
        ContentReader reader = this.routingStore.getReader(missingContentUrl);
        RoutingContentStoreTest.assertNotNull((String)"Missing URL should not return null", (Object)reader);
        RoutingContentStoreTest.assertFalse((String)"Empty reader should say content doesn't exist.", (boolean)reader.exists());
        try {
            reader.getContentString();
            RoutingContentStoreTest.fail((String)"Empty reader cannot return content.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testGeneralUse() {
        for (int i = 0; i < 20; ++i) {
            ContentContext contentContext = new ContentContext(null, null);
            ContentWriter writer = this.routingStore.getWriter(contentContext);
            String content = "This was generated by " + ((Object)((Object)this)).getClass().getName() + "#" + this.getName() + " number " + i;
            writer.putContent(content);
            String contentUrl = writer.getContentUrl();
            this.checkForContent(contentUrl, content);
            ContentReader reader = this.routingStore.getReader(contentUrl);
            RoutingContentStoreTest.assertNotNull((String)"Null reader returned", (Object)reader);
            RoutingContentStoreTest.assertTrue((String)"Reader should be onto live content", (boolean)reader.exists());
        }
    }

    private static class SupportsNoUrlFormatStore
    extends AbstractContentStore {
        @Override
        public boolean isWriteSupported() {
            return false;
        }

        @Override
        public ContentReader getReader(String contentUrl) {
            throw new UnsupportedContentUrlException(this, contentUrl);
        }

        @Override
        public void getUrls(Date createdAfter, Date createdBefore, ContentStore.ContentUrlHandler handler) throws ContentIOException {
            throw new UnsupportedOperationException("getUrls not supported");
        }
    }

    private static class DumbReadOnlyFileStore
    extends AbstractContentStore {
        FileContentStore fileStore;

        public DumbReadOnlyFileStore(FileContentStore fileStore) {
            this.fileStore = fileStore;
        }

        @Override
        public boolean isWriteSupported() {
            return false;
        }

        @Override
        public ContentReader getReader(String contentUrl) {
            return this.fileStore.getReader(contentUrl);
        }

        @Override
        public void getUrls(Date createdAfter, Date createdBefore, ContentStore.ContentUrlHandler handler) throws ContentIOException {
            this.fileStore.getUrls(createdAfter, createdBefore, handler);
        }
    }

    private static class RandomRoutingContentStore
    extends AbstractRoutingContentStore {
        private List<ContentStore> stores = new ArrayList<ContentStore>(5);

        public RandomRoutingContentStore(ContentStore ... stores) {
            for (ContentStore store : stores) {
                this.stores.add(store);
            }
            DefaultSimpleCache<Pair<String, String>, ContentStore> cache = new DefaultSimpleCache<Pair<String, String>, ContentStore>(11, this.getClass().getName());
            super.setStoresCache(cache);
        }

        @Override
        protected List<ContentStore> getAllStores() {
            return this.stores;
        }

        @Override
        protected ContentStore selectWriteStore(ContentContext ctx) {
            ArrayList<ContentStore> shuffled = new ArrayList<ContentStore>(this.stores);
            Collections.shuffle(shuffled);
            for (ContentStore store : shuffled) {
                if (!store.isWriteSupported()) continue;
                return store;
            }
            Assert.fail((String)"A request came for a writer when there is no writable store to choose from");
            return null;
        }
    }
}

