/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.util.Date;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.caching.CacheMissException;
import org.alfresco.repo.content.caching.CachingContentStoreCreatedEvent;
import org.alfresco.repo.content.caching.ContentCache;
import org.alfresco.repo.content.caching.quota.QuotaManagerStrategy;
import org.alfresco.repo.content.caching.quota.UnlimitedQuotaStrategy;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class CachingContentStore
implements ContentStore,
ApplicationEventPublisherAware,
BeanNameAware {
    private static final Log log = LogFactory.getLog(CachingContentStore.class);
    private static final int numLocks = 256;
    private static final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[256];
    private ContentStore backingStore;
    private ContentCache cache;
    private QuotaManagerStrategy quota = new UnlimitedQuotaStrategy();
    private boolean cacheOnInbound;
    private int maxCacheTries = 2;
    private ApplicationEventPublisher eventPublisher;
    private String beanName;

    public CachingContentStore() {
    }

    public CachingContentStore(ContentStore backingStore, ContentCache cache, boolean cacheOnInbound) {
        this.backingStore = backingStore;
        this.cache = cache;
        this.cacheOnInbound = cacheOnInbound;
    }

    public void init() {
        this.eventPublisher.publishEvent((ApplicationEvent)new CachingContentStoreCreatedEvent(this));
    }

    @Override
    public boolean isContentUrlSupported(String contentUrl) {
        return this.backingStore.isContentUrlSupported(contentUrl);
    }

    @Override
    public boolean isWriteSupported() {
        return this.backingStore.isWriteSupported();
    }

    @Override
    public long getTotalSize() {
        return this.backingStore.getTotalSize();
    }

    @Override
    public long getSpaceUsed() {
        return this.backingStore.getSpaceUsed();
    }

    @Override
    public long getSpaceFree() {
        return this.backingStore.getSpaceFree();
    }

    @Override
    public long getSpaceTotal() {
        return this.backingStore.getSpaceTotal();
    }

    @Override
    public String getRootLocation() {
        return this.backingStore.getRootLocation();
    }

    @Override
    public boolean exists(String contentUrl) {
        return this.backingStore.exists(contentUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentReader getReader(String contentUrl) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock(contentUrl).readLock();
        readLock.lock();
        try {
            if (this.cache.contains(contentUrl)) {
                ContentReader contentReader = this.cache.getReader(contentUrl);
                return contentReader;
            }
        }
        catch (CacheMissException cacheMissException) {
        }
        finally {
            readLock.unlock();
        }
        return this.cacheAndRead(contentUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentReader cacheAndRead(String url) {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock(url).writeLock();
        writeLock.lock();
        try {
            for (int i = 0; i < this.maxCacheTries; ++i) {
                ContentReader backingStoreReader = this.backingStore.getReader(url);
                long contentSize = backingStoreReader.getSize();
                if (!this.quota.beforeWritingCacheFile(contentSize)) {
                    ContentReader contentReader = backingStoreReader;
                    return contentReader;
                }
                ContentReader reader = this.attemptCacheAndRead(url);
                if (reader == null) continue;
                boolean keepCacheFile = this.quota.afterWritingCacheFile(contentSize);
                if (keepCacheFile) {
                    ContentReader contentReader = reader;
                    return contentReader;
                }
                this.cache.deleteFile(url);
                this.cache.remove(url);
                ContentReader contentReader = this.backingStore.getReader(url);
                return contentReader;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Attempted " + this.maxCacheTries + " times to cache content item and failed - " + "returning reader from backing store instead [" + "backingStore=" + this.backingStore + ", url=" + url + "]"));
            }
            ContentReader contentReader = this.backingStore.getReader(url);
            return contentReader;
        }
        finally {
            writeLock.unlock();
        }
    }

    private ContentReader attemptCacheAndRead(String url) {
        ContentReader reader = null;
        try {
            if (!this.cache.contains(url)) {
                if (this.cache.put(url, this.backingStore.getReader(url))) {
                    reader = this.cache.getReader(url);
                }
            } else {
                reader = this.cache.getReader(url);
            }
        }
        catch (CacheMissException e) {
            this.cache.remove(url);
        }
        return reader;
    }

    @Override
    public ContentWriter getWriter(ContentContext context) {
        if (this.cacheOnInbound) {
            final ContentWriter bsWriter = this.backingStore.getWriter(context);
            if (!this.quota.beforeWritingCacheFile(0L)) {
                return bsWriter;
            }
            final String url = bsWriter.getContentUrl();
            final ContentWriter cacheWriter = this.cache.getWriter(url);
            cacheWriter.addListener(new ContentStreamListener(){

                public void contentStreamClosed() throws ContentIOException {
                    bsWriter.setEncoding(cacheWriter.getEncoding());
                    bsWriter.setLocale(cacheWriter.getLocale());
                    bsWriter.setMimetype(cacheWriter.getMimetype());
                    bsWriter.putContent(cacheWriter.getReader());
                    if (!CachingContentStore.this.quota.afterWritingCacheFile(cacheWriter.getSize())) {
                        CachingContentStore.this.cache.deleteFile(url);
                        CachingContentStore.this.cache.remove(url);
                    }
                }
            });
            return cacheWriter;
        }
        return this.backingStore.getWriter(context);
    }

    @Override
    public ContentWriter getWriter(ContentReader existingContentReader, String newContentUrl) {
        ContentContext ctx = new ContentContext(existingContentReader, newContentUrl);
        return this.getWriter(ctx);
    }

    @Override
    public void getUrls(ContentStore.ContentUrlHandler handler) throws ContentIOException {
        this.backingStore.getUrls(handler);
    }

    @Override
    public void getUrls(Date createdAfter, Date createdBefore, ContentStore.ContentUrlHandler handler) throws ContentIOException {
        this.backingStore.getUrls(createdAfter, createdBefore, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String contentUrl) {
        ReentrantReadWriteLock readWriteLock = this.readWriteLock(contentUrl);
        ReentrantReadWriteLock.ReadLock readLock = readWriteLock.readLock();
        readLock.lock();
        try {
            if (!this.cache.contains(contentUrl)) {
                boolean bl = this.backingStore.delete(contentUrl);
                return bl;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.cache.contains(contentUrl)) {
                this.cache.remove(contentUrl);
            }
            boolean bl = this.backingStore.delete(contentUrl);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public ReentrantReadWriteLock readWriteLock(String url) {
        return locks[this.lockIndex(url)];
    }

    private int lockIndex(String url) {
        return url.hashCode() & 0xFF;
    }

    @Required
    public void setBackingStore(ContentStore backingStore) {
        this.backingStore = backingStore;
    }

    public String getBackingStoreType() {
        return this.backingStore.getClass().getName();
    }

    public String getBackingStoreDescription() {
        return this.backingStore.toString();
    }

    @Required
    public void setCache(ContentCache cache) {
        this.cache = cache;
    }

    public ContentCache getCache() {
        return this.cache;
    }

    public void setCacheOnInbound(boolean cacheOnInbound) {
        this.cacheOnInbound = cacheOnInbound;
    }

    public boolean isCacheOnInbound() {
        return this.cacheOnInbound;
    }

    public int getMaxCacheTries() {
        return this.maxCacheTries;
    }

    public void setMaxCacheTries(int maxCacheTries) {
        this.maxCacheTries = maxCacheTries;
    }

    @Required
    public void setQuota(QuotaManagerStrategy quota) {
        this.quota = quota;
    }

    public QuotaManagerStrategy getQuota() {
        return this.quota;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CachingContentStore.locks[i] = new ReentrantReadWriteLock();
        }
    }
}

