/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.test;

import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SlowContentStoreTest {
    private ClassPathXmlApplicationContext ctx;
    private CachingContentStore cachingStore;
    private static final Log logger = LogFactory.getLog(SlowContentStoreTest.class);

    public SlowContentStoreTest() {
        String conf = "classpath:cachingstore/test-context.xml";
        String slowconf = "classpath:cachingstore/test-slow-context.xml";
        this.ctx = (ClassPathXmlApplicationContext)ApplicationContextHelper.getApplicationContext((String[])new String[]{conf, slowconf});
        this.cachingStore = (CachingContentStore)this.ctx.getBean("cachingContentStore");
        this.cachingStore.setCacheOnInbound(false);
    }

    @Test
    public void readsAreFasterFromCache() {
        TimedStoreReader storeReader = new TimedStoreReader();
        storeReader.execute();
        Assert.assertTrue((String)"First read should take a while", (storeReader.timeTakenMillis() > 1000L ? 1 : 0) != 0);
        logger.debug((Object)String.format("First read took %ds", storeReader.timeTakenMillis()));
        Assert.assertEquals((Object)"This is the content for my slow ReadableByteChannel", (Object)storeReader.content);
        for (int i = 0; i < 5; ++i) {
            storeReader = new TimedStoreReader();
            storeReader.execute();
            Assert.assertTrue((String)"Subsequent reads should be fast", (storeReader.timeTakenMillis() < 100L ? 1 : 0) != 0);
            logger.debug((Object)String.format("Cache read took %ds", storeReader.timeTakenMillis()));
            Assert.assertEquals((Object)"This is the content for my slow ReadableByteChannel", (Object)storeReader.content);
        }
    }

    @Test
    public void writeThroughCacheResultsInFastReadFirstTime() {
        this.cachingStore.setCacheOnInbound(true);
        this.cachingStore.getWriter(new ContentContext(null, "any-url")).putContent("Content written from " + this.getClass().getSimpleName());
        TimedStoreReader storeReader = new TimedStoreReader();
        storeReader.execute();
        Assert.assertTrue((String)"First read should be fast", (storeReader.timeTakenMillis() < 100L ? 1 : 0) != 0);
        logger.debug((Object)String.format("First read took %ds", storeReader.timeTakenMillis()));
        Assert.assertEquals((Object)("Content written from " + this.getClass().getSimpleName()), (Object)storeReader.content);
        for (int i = 0; i < 5; ++i) {
            storeReader = new TimedStoreReader();
            storeReader.execute();
            Assert.assertTrue((String)"Subsequent reads should be fast", (storeReader.timeTakenMillis() < 100L ? 1 : 0) != 0);
            logger.debug((Object)String.format("Cache read took %ds", storeReader.timeTakenMillis()));
            Assert.assertEquals((Object)("Content written from " + this.getClass().getSimpleName()), (Object)storeReader.content);
        }
    }

    private abstract class TimedExecutor {
        private long start;
        private long finish;

        private TimedExecutor() {
        }

        public void execute() {
            this.start = System.currentTimeMillis();
            this.doExecute();
            this.finish = System.currentTimeMillis();
        }

        public long timeTakenMillis() {
            return this.finish - this.start;
        }

        protected abstract void doExecute();
    }

    private class TimedStoreReader
    extends TimedExecutor {
        String content;

        private TimedStoreReader() {
        }

        @Override
        protected void doExecute() {
            this.content = SlowContentStoreTest.this.cachingStore.getReader("any-url").getContentString();
            logger.debug((Object)("Read content: " + this.content));
        }
    }
}

