/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.MetadataEmbedder;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MalformedNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractMappingMetadataExtracter
implements MetadataExtracter,
MetadataEmbedder,
BeanNameAware {
    public static final String NAMESPACE_PROPERTY_PREFIX = "namespace.prefix.";
    private static final String ERR_TYPE_CONVERSION = "metadata.extraction.err.type_conversion";
    protected static Log logger = LogFactory.getLog(AbstractMappingMetadataExtracter.class);
    private MetadataExtracterRegistry registry;
    private MimetypeService mimetypeService;
    private DictionaryService dictionaryService;
    private boolean initialized;
    private Set<String> supportedMimetypes;
    private Set<String> supportedEmbedMimetypes;
    private MetadataExtracter.OverwritePolicy overwritePolicy;
    private boolean failOnTypeConversion;
    protected Set<DateFormat> supportedDateFormats = new HashSet<DateFormat>(0);
    private Map<String, Set<QName>> mapping;
    private Map<QName, Set<String>> embedMapping;
    private boolean inheritDefaultMapping;
    private boolean inheritDefaultEmbedMapping;
    private boolean enableStringTagging;
    private String beanName;
    private Properties properties;

    protected AbstractMappingMetadataExtracter() {
        this(Collections.emptySet());
    }

    protected AbstractMappingMetadataExtracter(Set<String> supportedMimetypes) {
        this.supportedMimetypes = supportedMimetypes;
        this.overwritePolicy = MetadataExtracter.OverwritePolicy.PRAGMATIC;
        this.failOnTypeConversion = true;
        this.mapping = null;
        this.embedMapping = null;
        this.inheritDefaultMapping = false;
        this.inheritDefaultEmbedMapping = false;
        this.initialized = false;
    }

    protected AbstractMappingMetadataExtracter(Set<String> supportedMimetypes, Set<String> supportedEmbedMimetypes) {
        this(supportedMimetypes);
        this.supportedEmbedMimetypes = supportedEmbedMimetypes;
    }

    public void setRegistry(MetadataExtracterRegistry registry) {
        this.registry = registry;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setSupportedMimetypes(Collection<String> supportedMimetypes) {
        this.supportedMimetypes.clear();
        this.supportedMimetypes.addAll(supportedMimetypes);
    }

    public void setSupportedEmbedMimetypes(Collection<String> supportedEmbedMimetypes) {
        this.supportedEmbedMimetypes.clear();
        this.supportedEmbedMimetypes.addAll(supportedEmbedMimetypes);
    }

    @Override
    public boolean isSupported(String sourceMimetype) {
        return this.supportedMimetypes.contains(sourceMimetype) && this.isEnabled(sourceMimetype);
    }

    @Override
    public boolean isEmbeddingSupported(String sourceMimetype) {
        if (this.supportedEmbedMimetypes == null) {
            return false;
        }
        return this.supportedEmbedMimetypes.contains(sourceMimetype);
    }

    private boolean isEnabled(String mimetype) {
        return this.properties == null || this.mimetypeService == null || this.getBooleanProperty(this.beanName + ".enabled", true) && this.getBooleanProperty(this.beanName + '.' + this.mimetypeService.getExtension(mimetype) + ".enabled", true);
    }

    private boolean getBooleanProperty(String name, boolean defaultValue) {
        String property;
        boolean value = defaultValue;
        if (this.properties != null && (property = this.properties.getProperty(name)) != null) {
            value = property.trim().equalsIgnoreCase("true");
        }
        return value;
    }

    @Override
    public double getReliability(String mimetype) {
        return this.isSupported(mimetype) ? 1.0 : 0.0;
    }

    public void setOverwritePolicy(MetadataExtracter.OverwritePolicy overwritePolicy) {
        this.overwritePolicy = overwritePolicy;
    }

    public void setOverwritePolicy(String overwritePolicyStr) {
        this.overwritePolicy = MetadataExtracter.OverwritePolicy.valueOf(overwritePolicyStr);
    }

    public void setFailOnTypeConversion(boolean failOnTypeConversion) {
        this.failOnTypeConversion = failOnTypeConversion;
    }

    public void setSupportedDateFormats(List<String> supportedDateFormats) {
        this.supportedDateFormats = new HashSet<DateFormat>(5);
        for (String dateFormatStr : supportedDateFormats) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
                this.supportedDateFormats.add(df);
                SimpleDateFormat englishFormat = new SimpleDateFormat(dateFormatStr, Locale.US);
                this.supportedDateFormats.add(englishFormat);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Unable to set supported date format: " + dateFormatStr, e);
            }
        }
    }

    public void setInheritDefaultMapping(boolean inheritDefaultMapping) {
        this.inheritDefaultMapping = inheritDefaultMapping;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setEnableStringTagging(boolean enableStringTagging) {
        this.enableStringTagging = enableStringTagging;
    }

    public void setInheritDefaultEmbedMapping(boolean inheritDefaultEmbedMapping) {
        this.inheritDefaultEmbedMapping = inheritDefaultEmbedMapping;
    }

    public void setMapping(Map<String, Set<QName>> mapping) {
        this.mapping = mapping;
    }

    public void setEmbedMapping(Map<QName, Set<String>> embedMapping) {
        this.embedMapping = embedMapping;
    }

    public void setMappingProperties(Properties mappingProperties) {
        this.mapping = this.readMappingProperties(mappingProperties);
    }

    public void setEmbedMappingProperties(Properties embedMappingProperties) {
        this.embedMapping = this.readEmbedMappingProperties(embedMappingProperties);
    }

    protected final Map<String, Set<QName>> getMapping() {
        if (!this.initialized) {
            throw new UnsupportedOperationException("The complete mapping is only available after initialization.");
        }
        return Collections.unmodifiableMap(this.mapping);
    }

    protected final Map<QName, Set<String>> getEmbedMapping() {
        if (!this.initialized) {
            throw new UnsupportedOperationException("The complete embed mapping is only available after initialization.");
        }
        return Collections.unmodifiableMap(this.embedMapping);
    }

    protected Map<String, Set<QName>> readMappingProperties(String propertiesUrl) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(propertiesUrl);
            if (is == null) {
                throw new AlfrescoRuntimeException("Metadata Extracter mapping properties not found: \n   Extracter:  " + this + "\n" + "   Bundle:     " + propertiesUrl);
            }
            Properties props = new Properties();
            props.load(is);
            Map<String, Set<QName>> map = this.readMappingProperties(props);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loaded mapping properties from resource: " + propertiesUrl));
            }
            Map<String, Set<QName>> map2 = map;
            return map2;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to load properties file to read extracter mapping properties: \n   Extracter:  " + this + "\n" + "   Bundle:     " + propertiesUrl, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    protected Map<String, Set<QName>> readMappingProperties(Properties mappingProperties) {
        HashMap<String, String> namespacesByPrefix = new HashMap<String, String>(5);
        for (Map.Entry<Object, Object> entry : mappingProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            String prefix = propertyName.substring(17);
            String namespace = (String)entry.getValue();
            namespacesByPrefix.put(prefix, namespace);
        }
        HashMap<String, Set<QName>> convertedMapping = new HashMap<String, Set<QName>>(17);
        for (Map.Entry<Object, Object> entry : mappingProperties.entrySet()) {
            String documentProperty = (String)entry.getKey();
            String qnamesStr = (String)entry.getValue();
            if (documentProperty.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            HashSet<QName> qnames = new HashSet<QName>(3);
            convertedMapping.put(documentProperty, qnames);
            StringTokenizer tokenizer = new StringTokenizer(qnamesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                String qnameStr = tokenizer.nextToken().trim();
                int index = qnameStr.indexOf(58);
                if (index > -1 && qnameStr.charAt(0) != '{') {
                    String prefix = qnameStr.substring(0, index);
                    String suffix = qnameStr.substring(index + 1);
                    String uri = (String)namespacesByPrefix.get(prefix);
                    if (uri == null) {
                        throw new AlfrescoRuntimeException("No prefix mapping for extracter property mapping: \n   Extracter: " + this + "\n" + "   Mapping: " + entry);
                    }
                    qnameStr = '{' + uri + '}' + suffix;
                }
                try {
                    QName qname = QName.createQName((String)qnameStr);
                    qnames.add(qname);
                }
                catch (InvalidQNameException e) {
                    throw new AlfrescoRuntimeException("Can't create metadata extracter property mapping: \n   Extracter: " + this + "\n" + "   Mapping: " + entry);
                }
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Added mapping from " + documentProperty + " to " + qnames));
        }
        return convertedMapping;
    }

    protected Map<QName, Set<String>> readEmbedMappingProperties(String propertiesUrl) {
        Map<QName, Set<String>> map;
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(propertiesUrl);
            if (is == null) {
                Map<QName, Set<String>> map2 = null;
                return map2;
            }
            Properties props = new Properties();
            props.load(is);
            Map<QName, Set<String>> map3 = this.readEmbedMappingProperties(props);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loaded embed mapping properties from resource: " + propertiesUrl));
            }
            map = map3;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to load properties file to read extracter embed mapping properties: \n   Extracter:  " + this + "\n" + "   Bundle:     " + propertiesUrl, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        return map;
    }

    protected Map<QName, Set<String>> readEmbedMappingProperties(Properties mappingProperties) {
        HashMap<String, String> namespacesByPrefix = new HashMap<String, String>(5);
        for (Map.Entry<Object, Object> entry : mappingProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            String prefix = propertyName.substring(17);
            String namespace = (String)entry.getValue();
            namespacesByPrefix.put(prefix, namespace);
        }
        HashMap<QName, Set<String>> convertedMapping = new HashMap<QName, Set<String>>(17);
        for (Map.Entry<Object, Object> entry : mappingProperties.entrySet()) {
            String modelProperty = (String)entry.getKey();
            String metadataKeysString = (String)entry.getValue();
            if (modelProperty.startsWith(NAMESPACE_PROPERTY_PREFIX)) continue;
            int index = modelProperty.indexOf(58);
            if (index > -1 && modelProperty.charAt(0) != '{') {
                String prefix = modelProperty.substring(0, index);
                String suffix = modelProperty.substring(index + 1);
                String uri = (String)namespacesByPrefix.get(prefix);
                if (uri == null) {
                    throw new AlfrescoRuntimeException("No prefix mapping for embed property mapping: \n   Extracter: " + this + "\n" + "   Mapping: " + entry);
                }
                modelProperty = '{' + uri + '}' + suffix;
            }
            try {
                QName qname = QName.createQName((String)modelProperty);
                String[] metadataKeysArray = metadataKeysString.split(",");
                HashSet<String> metadataKeys = new HashSet<String>(metadataKeysArray.length);
                for (String metadataKey : metadataKeysArray) {
                    metadataKeys.add(metadataKey.trim());
                }
                convertedMapping.put(qname, metadataKeys);
            }
            catch (InvalidQNameException e) {
                throw new AlfrescoRuntimeException("Can't create metadata embedding property mapping: \n   Extracter: " + this + "\n" + "   Mapping: " + entry);
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Added mapping from " + modelProperty + " to " + metadataKeysString));
        }
        return convertedMapping;
    }

    public final void register() {
        this.init();
        if (this.registry != null) {
            this.registry.register(this);
        }
    }

    protected void init() {
        Map<String, Set<QName>> defaultMapping = this.getDefaultMapping();
        if (defaultMapping == null) {
            throw new AlfrescoRuntimeException("The metadata extracter must provide a default mapping: " + this);
        }
        if (this.mapping == null) {
            this.mapping = defaultMapping;
        } else if (this.inheritDefaultMapping) {
            for (String documentKey : defaultMapping.keySet()) {
                Set<QName> systemQNames = this.mapping.get(documentKey);
                if (systemQNames == null) {
                    systemQNames = new HashSet<QName>(3);
                    this.mapping.put(documentKey, systemQNames);
                }
                Set<QName> defaultQNames = defaultMapping.get(documentKey);
                systemQNames.addAll(defaultQNames);
            }
        }
        if (this.mapping.size() == 0 && defaultMapping.size() > 0) {
            logger.warn((Object)("There are no property mappings for the metadata extracter.\n  Nothing will be extracted by: " + this));
        }
        Map<QName, Set<String>> defaultEmbedMapping = this.getDefaultEmbedMapping();
        if (this.embedMapping == null) {
            this.embedMapping = defaultEmbedMapping;
        } else if (this.inheritDefaultEmbedMapping) {
            for (QName modelProperty : defaultEmbedMapping.keySet()) {
                Set<String> metadataKeys = this.embedMapping.get(modelProperty);
                if (metadataKeys == null) {
                    metadataKeys = new HashSet<String>(3);
                    this.embedMapping.put(modelProperty, metadataKeys);
                }
                Set<String> defaultMetadataKeys = defaultEmbedMapping.get(modelProperty);
                metadataKeys.addAll(defaultMetadataKeys);
            }
        }
        this.initialized = true;
    }

    @Override
    public long getExtractionTime() {
        return 1000L;
    }

    protected void checkIsSupported(ContentReader reader) {
        String mimetype = reader.getMimetype();
        if (!this.isSupported(mimetype)) {
            throw new AlfrescoRuntimeException("Metadata extracter does not support mimetype: \n   reader: " + reader + "\n" + "   supported: " + this.supportedMimetypes + "\n" + "   extracter: " + this);
        }
    }

    protected void checkIsEmbedSupported(ContentWriter writer) {
        String mimetype = writer.getMimetype();
        if (!this.isSupported(mimetype)) {
            throw new AlfrescoRuntimeException("Metadata extracter does not support embedding mimetype: \n   writer: " + writer + "\n" + "   supported: " + this.supportedEmbedMimetypes + "\n" + "   extracter: " + this);
        }
    }

    @Override
    public final Map<QName, Serializable> extract(ContentReader reader, Map<QName, Serializable> destination) {
        return this.extract(reader, this.overwritePolicy, destination, this.mapping);
    }

    @Override
    public final Map<QName, Serializable> extract(ContentReader reader, MetadataExtracter.OverwritePolicy overwritePolicy, Map<QName, Serializable> destination) {
        return this.extract(reader, overwritePolicy, destination, this.mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<QName, Serializable> extract(ContentReader reader, MetadataExtracter.OverwritePolicy overwritePolicy, Map<QName, Serializable> destination, Map<String, Set<QName>> mapping) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting metadata extraction: \n   reader: " + reader + "\n" + "   extracter: " + this));
        }
        if (!this.initialized) {
            throw new AlfrescoRuntimeException("Metadata extracter not initialized.\n  Call the 'register' method on: " + this + "\n" + "  Implementations of the 'init' method must call the base implementation.");
        }
        this.checkIsSupported(reader);
        Map<Object, Object> changedProperties = null;
        try {
            Map<Object, Object> rawMetadata = null;
            rawMetadata = reader.getSize() > 0L && reader.exists() ? this.extractRaw(reader) : new HashMap(1);
            Map<QName, Serializable> systemProperties = this.mapRawToSystem(rawMetadata);
            systemProperties = this.convertSystemPropertyValues(systemProperties);
            this.filterSystemProperties(systemProperties, destination);
            changedProperties = overwritePolicy.applyProperties(systemProperties, destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Extracted Metadata from " + reader + "\n  Found: " + rawMetadata + "\n  Mapped and Accepted: " + changedProperties));
            }
        }
        catch (Throwable e) {
            String typeErrorMessage = null;
            String differentType = null;
            if (this.mimetypeService != null) {
                differentType = this.mimetypeService.getMimetypeIfNotMatches(reader.getReader());
            } else {
                logger.info((Object)("Unable to verify mimetype of " + reader.getReader() + " as no MimetypeService available to " + this.getClass().getName()));
            }
            if (differentType != null) {
                typeErrorMessage = "\n   claimed mime type: " + reader.getMimetype() + "\n" + "   detected mime type: " + differentType;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Metadata extraction failed: \n   Extracter: " + this + "\n" + "   Content:   " + reader + typeErrorMessage), e);
            } else {
                logger.warn((Object)("Metadata extraction failed (turn on DEBUG for full error): \n   Extracter: " + this + "\n" + "   Content:   " + reader + "\n" + "   Failure:   " + e.getMessage() + typeErrorMessage));
            }
        }
        finally {
            if (reader.isChannelOpen()) {
                logger.error((Object)("Content reader not closed by metadata extracter: \n   reader: " + reader + "\n" + "   extracter: " + this));
            }
            if (changedProperties == null) {
                changedProperties = new HashMap(0);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completed metadata extraction: \n   reader:    " + reader + "\n" + "   extracter: " + this + "\n" + "   changed:   " + changedProperties));
        }
        return changedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void embed(Map<QName, Serializable> properties, ContentReader reader, ContentWriter writer) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting metadata embedding: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   extracter: " + this));
        }
        if (!this.initialized) {
            throw new AlfrescoRuntimeException("Metadata extracter not initialized.\n  Call the 'register' method on: " + this + "\n" + "  Implementations of the 'init' method must call the base implementation.");
        }
        this.checkIsEmbedSupported(writer);
        try {
            this.embedInternal(this.mapSystemToRaw(properties), reader, writer);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Embedded Metadata into " + writer));
            }
        }
        catch (Throwable e) {
            String typeErrorMessage = null;
            String differentType = null;
            if (this.mimetypeService != null) {
                differentType = this.mimetypeService.getMimetypeIfNotMatches(writer.getReader());
            } else {
                logger.info((Object)("Unable to verify mimetype of " + writer.getReader() + " as no MimetypeService available to " + this.getClass().getName()));
            }
            if (differentType != null) {
                typeErrorMessage = "\n   claimed mime type: " + writer.getMimetype() + "\n" + "   detected mime type: " + differentType;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Metadata embedding failed: \n   Extracter: " + this + "\n" + "   Content:   " + writer + typeErrorMessage), e);
            } else {
                logger.warn((Object)("Metadata embedding failed (turn on DEBUG for full error): \n   Extracter: " + this + "\n" + "   Content:   " + writer + "\n" + "   Failure:   " + e.getMessage() + typeErrorMessage));
            }
        }
        finally {
            if (writer.isChannelOpen()) {
                logger.error((Object)("Content writer not closed by metadata extracter: \n   writer: " + writer + "\n" + "   extracter: " + this));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completed metadata embedding: \n   writer:    " + writer + "\n" + "   extracter: " + this));
        }
    }

    private Map<QName, Serializable> mapRawToSystem(Map<String, Serializable> rawMetadata) {
        HashMap<QName, Serializable> systemProperties = new HashMap<QName, Serializable>(rawMetadata.size() * 2 + 1);
        for (Map.Entry<String, Serializable> entry : rawMetadata.entrySet()) {
            String documentKey = entry.getKey();
            if (!this.mapping.containsKey(documentKey)) continue;
            Serializable documentValue = entry.getValue();
            Set<QName> systemQNames = this.mapping.get(documentKey);
            for (QName systemQName : systemQNames) {
                systemProperties.put(systemQName, documentValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converted extracted raw values to system values: \n   Raw Properties:    " + rawMetadata + "\n" + "   System Properties: " + systemProperties));
        }
        return systemProperties;
    }

    private Map<String, Serializable> mapSystemToRaw(Map<QName, Serializable> systemMetadata) {
        HashMap<String, Serializable> metadataProperties = new HashMap<String, Serializable>(systemMetadata.size() * 2 + 1);
        for (Map.Entry<QName, Serializable> entry : systemMetadata.entrySet()) {
            QName modelProperty = entry.getKey();
            if (!this.embedMapping.containsKey(modelProperty)) continue;
            Serializable documentValue = entry.getValue();
            Set<String> metadataKeys = this.embedMapping.get(modelProperty);
            for (String metadataKey : metadataKeys) {
                metadataProperties.put(metadataKey, documentValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converted system model values to metadata values: \n   System Properties:    " + systemMetadata + "\n" + "   Metadata Properties: " + metadataProperties));
        }
        return metadataProperties;
    }

    protected void filterSystemProperties(Map<QName, Serializable> systemProperties, Map<QName, Serializable> targetProperties) {
    }

    private Map<QName, Serializable> convertSystemPropertyValues(Map<QName, Serializable> systemProperties) {
        HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(systemProperties.size() + 7);
        for (Map.Entry<QName, Serializable> entry : systemProperties.entrySet()) {
            PropertyDefinition propertyDef;
            QName propertyQName = entry.getKey();
            Serializable propertyValue = entry.getValue();
            PropertyDefinition propertyDefinition = propertyDef = this.dictionaryService == null ? null : this.dictionaryService.getProperty(propertyQName);
            if (propertyDef == null) {
                convertedProperties.put(propertyQName, propertyValue);
                continue;
            }
            DataTypeDefinition propertyTypeDef = propertyDef.getDataType();
            Serializable convertedPropertyValue = null;
            try {
                if (propertyTypeDef.getName().equals((Object)DataTypeDefinition.DATE) || propertyTypeDef.getName().equals((Object)DataTypeDefinition.DATETIME)) {
                    if (propertyValue instanceof Date) {
                        convertedPropertyValue = propertyValue;
                    } else if (propertyValue instanceof Collection) {
                        convertedPropertyValue = (Serializable)((Object)this.makeDates((Collection)((Object)propertyValue)));
                    } else if (propertyValue instanceof String) {
                        convertedPropertyValue = this.makeDate((String)((Object)propertyValue));
                    } else if (propertyValue == null) {
                        convertedPropertyValue = null;
                    } else if (logger.isWarnEnabled()) {
                        StringBuilder mesg = new StringBuilder();
                        mesg.append("Unable to convert Date property: ").append(propertyQName).append(", value: ").append(propertyValue).append(", type: ").append(propertyTypeDef.getName());
                        logger.warn((Object)mesg.toString());
                    }
                } else {
                    convertedPropertyValue = propertyValue instanceof Collection ? (Serializable)((Object)DefaultTypeConverter.INSTANCE.convert(propertyTypeDef, (Collection)((Object)propertyValue))) : (propertyValue instanceof Object[] ? (Serializable)((Object)DefaultTypeConverter.INSTANCE.convert(propertyTypeDef, (Object[])propertyValue)) : (Serializable)DefaultTypeConverter.INSTANCE.convert(propertyTypeDef, (Object)propertyValue));
                }
                convertedProperties.put(propertyQName, convertedPropertyValue);
            }
            catch (TypeConversionException e) {
                logger.warn((Object)("Type conversion failed during metadata extraction: \n   Failure:   " + e.getMessage() + "\n" + "   Type:      " + propertyTypeDef + "\n" + "   Value:     " + propertyValue));
                if (!this.failOnTypeConversion) continue;
                throw AlfrescoRuntimeException.create((Throwable)e, (String)ERR_TYPE_CONVERSION, (Object[])new Object[]{this, propertyQName, propertyTypeDef.getName(), propertyValue});
            }
            catch (MalformedNodeRefException e) {
                if (propertyQName.equals((Object)ContentModel.PROP_TAGS)) {
                    if (this.enableStringTagging) {
                        ArrayList<Object> list = new ArrayList<Object>(1);
                        for (Object value : (Object[])propertyValue) {
                            list.add(value);
                        }
                        convertedProperties.put(propertyQName, list);
                        continue;
                    }
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("enableStringTagging is false and could not convert " + propertyQName.toString() + ": " + e.getMessage()));
                    continue;
                }
                if (!this.failOnTypeConversion) continue;
                throw e;
            }
        }
        return convertedProperties;
    }

    private Collection<Date> makeDates(Collection<String> dateStrs) {
        ArrayList<Date> dates = new ArrayList<Date>(dateStrs.size());
        for (String dateStr : dateStrs) {
            Date date = this.makeDate(dateStr);
            dates.add(date);
        }
        return dates;
    }

    protected Date makeDate(String dateStr) {
        Date date;
        block6: {
            if (dateStr == null || dateStr.length() == 0) {
                return null;
            }
            date = null;
            try {
                date = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)dateStr);
            }
            catch (TypeConversionException e) {
                for (DateFormat df : this.supportedDateFormats) {
                    try {
                        date = df.parse(dateStr);
                    }
                    catch (ParseException ee) {}
                }
                if (date != null) break block6;
                throw new TypeConversionException("Unable to convert string to date: " + dateStr);
            }
        }
        return date;
    }

    protected boolean putRawValue(String key, Serializable value, Map<String, Serializable> destination) {
        if (value != null) {
            if (value instanceof String) {
                String valueStr = ((String)value).trim();
                if (valueStr.length() == 0) {
                    value = null;
                } else {
                    if (valueStr.indexOf("\u0000") != -1) {
                        valueStr = valueStr.replaceAll("\u0000", "");
                    }
                    value = valueStr;
                }
            } else if (value instanceof Collection) {
                Collection valueCollection = (Collection)value;
                if (valueCollection.isEmpty()) {
                    value = null;
                }
            } else if (value.getClass().isArray() && Array.getLength(value) == 0) {
                value = null;
            }
        }
        destination.put(key, (Serializable)value);
        return true;
    }

    protected final Map<String, Serializable> newRawMap() {
        return new HashMap<String, Serializable>(17);
    }

    protected Map<String, Set<QName>> getDefaultMapping() {
        String className = this.getClass().getName();
        className = className.replace('$', '-');
        className = className.replace('.', '/');
        String propertiesUrl = className + ".properties";
        return this.readMappingProperties(propertiesUrl);
    }

    protected Map<QName, Set<String>> getDefaultEmbedMapping() {
        String className = this.getClass().getName();
        className = className.replace('$', '-');
        String propertiesUrl = (className = className.replace('.', '/')) + ".embed.properties";
        Map<QName, Set<String>> embedMapping = this.readEmbedMappingProperties(propertiesUrl);
        if (embedMapping == null) {
            Map<String, Set<QName>> extractMapping;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No explicit embed mapping properties found at: " + propertiesUrl + ", assuming reverse of extract mapping"));
            }
            if ((extractMapping = this.mapping) == null || extractMapping.size() == 0) {
                extractMapping = this.getDefaultMapping();
            }
            embedMapping = new HashMap<QName, Set<String>>(extractMapping.size());
            for (String metadataKey : extractMapping.keySet()) {
                if (extractMapping.get(metadataKey) == null || extractMapping.get(metadataKey).size() <= 0) continue;
                QName modelProperty = extractMapping.get(metadataKey).iterator().next();
                Set<String> metadataKeys = embedMapping.get(modelProperty);
                if (metadataKeys == null) {
                    metadataKeys = new HashSet<String>(1);
                    embedMapping.put(modelProperty, metadataKeys);
                }
                metadataKeys.add(metadataKey);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Added mapping from " + modelProperty + " to " + metadataKeys.toString()));
            }
        }
        return embedMapping;
    }

    protected abstract Map<String, Serializable> extractRaw(ContentReader var1) throws Throwable;

    protected void embedInternal(Map<String, Serializable> metadata, ContentReader reader, ContentWriter writer) throws Throwable {
    }
}

