/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.HtmlMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.service.namespace.QName;

public class HtmlMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private HtmlMetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new HtmlMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : HtmlMetadataExtracter.MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            HtmlMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testHtmlExtraction() throws Exception {
        this.testExtractFromMimetype("text/html");
    }

    @Override
    public void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
    }
}

