/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.content.metadata.TikaAudioMetadataExtracter;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mp3.Mp3Parser;

public class MP3MetadataExtracter
extends TikaAudioMetadataExtracter {
    private static final String KEY_SONG_TITLE = "songTitle";
    private static final String KEY_ALBUM_TITLE = "albumTitle";
    private static final String KEY_ARTIST = "artist";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_YEAR_RELEASED = "yearReleased";
    private static final String KEY_TRACK_NUMBER = "trackNumber";
    private static final String KEY_GENRE = "genre";
    private static final String KEY_COMPOSER = "composer";
    public static ArrayList<String> SUPPORTED_MIMETYPES = MP3MetadataExtracter.buildSupportedMimetypes(new String[]{"audio/mpeg"}, new Parser[]{new Mp3Parser()});

    public MP3MetadataExtracter() {
        super(SUPPORTED_MIMETYPES);
    }

    @Override
    protected Parser getParser() {
        return new Mp3Parser();
    }

    @Override
    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        super.extractSpecific(metadata, properties, headers);
        this.putRawValue(KEY_ALBUM_TITLE, (Serializable)((Object)metadata.get(XMPDM.ALBUM)), properties);
        this.putRawValue(KEY_SONG_TITLE, (Serializable)((Object)metadata.get("title")), properties);
        this.putRawValue(KEY_ARTIST, (Serializable)((Object)metadata.get(XMPDM.ARTIST)), properties);
        this.putRawValue(KEY_COMMENT, (Serializable)((Object)metadata.get(XMPDM.LOG_COMMENT)), properties);
        this.putRawValue(KEY_TRACK_NUMBER, (Serializable)((Object)metadata.get(XMPDM.TRACK_NUMBER)), properties);
        this.putRawValue(KEY_GENRE, (Serializable)((Object)metadata.get(XMPDM.GENRE)), properties);
        this.putRawValue(KEY_YEAR_RELEASED, (Serializable)((Object)metadata.get(XMPDM.RELEASE_DATE)), properties);
        this.putRawValue(KEY_COMPOSER, (Serializable)((Object)metadata.get(XMPDM.COMPOSER)), properties);
        return properties;
    }
}

