/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.OfficeMetadataExtracter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class OfficeMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private OfficeMetadataExtracter extracter;
    private static final QName WORD_COUNT_TEST_PROPERTY = QName.createQName((String)"WordCountTest");
    private static final QName LAST_AUTHOR_TEST_PROPERTY = QName.createQName((String)"LastAuthorTest");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new OfficeMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
        HashMap<String, Set<QName>> newMap = new HashMap<String, Set<QName>>(this.extracter.getMapping());
        HashSet<QName> wcSet = new HashSet<QName>();
        wcSet.add(WORD_COUNT_TEST_PROPERTY);
        newMap.put("wordCount", wcSet);
        HashSet<QName> laSet = new HashSet<QName>();
        laSet.add(LAST_AUTHOR_TEST_PROPERTY);
        newMap.put("lastAuthor", laSet);
        this.extracter.setMapping(newMap);
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : OfficeMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            OfficeMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testSupportedMimetypes() throws Exception {
        for (String mimetype : OfficeMetadataExtracter.SUPPORTED_MIMETYPES) {
            this.testExtractFromMimetype(mimetype);
        }
    }

    @Override
    public void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        if (mimetype.equals("application/msword")) {
            OfficeMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)"2005-05-26T13:57:00.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
            OfficeMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_MODIFIED + " not found for mimetype " + mimetype), (String)"2005-09-20T18:25:00.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIED))));
        } else if (mimetype.equals("application/vnd.ms-excel")) {
            OfficeMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)"1996-10-15T00:33:28.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
            OfficeMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_MODIFIED + " not found for mimetype " + mimetype), (String)"2005-09-20T19:22:32.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIED))));
        } else if (mimetype.equals("application/vnd.ms-powerpoint")) {
            OfficeMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)"1601-01-01T00:00:00.000Z", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
            OfficeMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_MODIFIED + " not found for mimetype " + mimetype), (String)"2005-09-20T19:23:41.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIED))));
        }
        OfficeMetadataExtracterTest.assertTrue((String)("Test Property " + LAST_AUTHOR_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(LAST_AUTHOR_TEST_PROPERTY));
        if (mimetype.equals("application/msword")) {
            OfficeMetadataExtracterTest.assertTrue((String)("Test Property " + WORD_COUNT_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(WORD_COUNT_TEST_PROPERTY));
            OfficeMetadataExtracterTest.assertEquals((String)("Test Property " + WORD_COUNT_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"9", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(WORD_COUNT_TEST_PROPERTY))));
            OfficeMetadataExtracterTest.assertEquals((String)("Test Property " + LAST_AUTHOR_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"Derek Hulley", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(LAST_AUTHOR_TEST_PROPERTY))));
        } else if (mimetype.equals("application/vnd.ms-excel")) {
            OfficeMetadataExtracterTest.assertEquals((String)("Test Property " + LAST_AUTHOR_TEST_PROPERTY + " not found for mimetype " + mimetype), (String)"Derek Hulley", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(LAST_AUTHOR_TEST_PROPERTY))));
        } else if (mimetype.equals("application/vnd.ms-powerpoint")) {
            OfficeMetadataExtracterTest.assertTrue((String)("Test Property " + WORD_COUNT_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(WORD_COUNT_TEST_PROPERTY));
            OfficeMetadataExtracterTest.assertEquals((String)("Test Property " + WORD_COUNT_TEST_PROPERTY + " not found for mimetype " + mimetype), (String)"9", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(WORD_COUNT_TEST_PROPERTY))));
            OfficeMetadataExtracterTest.assertEquals((String)("Test Property " + LAST_AUTHOR_TEST_PROPERTY + " not found for mimetype " + mimetype), (String)"Derek Hulley", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(LAST_AUTHOR_TEST_PROPERTY))));
        }
    }
}

