/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.OpenOfficeMetadataWorker;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.PropertyCheck;

public class OpenOfficeMetadataExtracter
extends AbstractMappingMetadataExtracter
implements OpenOfficeMetadataWorker {
    public static String[] SUPPORTED_MIMETYPES = new String[]{"application/vnd.stardivision.writer", "application/vnd.stardivision.impress", "application/vnd.sun.xml.writer", "application/vnd.sun.xml.impress"};
    private OpenOfficeMetadataWorker worker;

    public OpenOfficeMetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(SUPPORTED_MIMETYPES)));
    }

    public void setWorker(OpenOfficeMetadataWorker worker) {
        this.worker = worker;
    }

    @Override
    public synchronized void init() {
        PropertyCheck.mandatory((Object)"OpenOfficeMetadataExtracter", (String)"worker", (Object)this.worker);
        super.init();
    }

    @Override
    public boolean isConnected() {
        return this.worker.isConnected();
    }

    @Override
    public boolean isSupported(String sourceMimetype) {
        if (!this.isConnected()) {
            return false;
        }
        return super.isSupported(sourceMimetype);
    }

    @Override
    public Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        Map<String, Serializable> rawProperties = this.newRawMap();
        Map<String, Serializable> result = this.worker.extractRaw(reader);
        for (Map.Entry<String, Serializable> entry : result.entrySet()) {
            this.putRawValue(entry.getKey(), entry.getValue(), rawProperties);
        }
        return rawProperties;
    }
}

