/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataEmbedder;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.embedder.Embedder;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class TikaPoweredMetadataExtracter
extends AbstractMappingMetadataExtracter
implements MetadataEmbedder {
    protected static Log logger = LogFactory.getLog(TikaPoweredMetadataExtracter.class);
    protected static final String KEY_AUTHOR = "author";
    protected static final String KEY_TITLE = "title";
    protected static final String KEY_SUBJECT = "subject";
    protected static final String KEY_CREATED = "created";
    protected static final String KEY_DESCRIPTION = "description";
    protected static final String KEY_COMMENTS = "comments";
    private DateFormat[] tikaDateFormats;

    protected static ArrayList<String> buildSupportedMimetypes(String[] explicitTypes, Parser ... tikaParsers) {
        ArrayList<String> types = new ArrayList<String>();
        for (String string : explicitTypes) {
            if (types.contains(string)) continue;
            types.add(string);
        }
        if (tikaParsers != null) {
            for (String string : tikaParsers) {
                for (MediaType mt : string.getSupportedTypes(new ParseContext())) {
                    String type = mt.toString();
                    if (types.contains(type)) continue;
                    types.add(type);
                }
            }
        }
        return types;
    }

    public TikaPoweredMetadataExtracter(ArrayList<String> supportedMimeTypes) {
        this(new HashSet<String>(supportedMimeTypes), (HashSet<String>)null);
    }

    public TikaPoweredMetadataExtracter(ArrayList<String> supportedMimeTypes, ArrayList<String> supportedEmbedMimeTypes) {
        this(new HashSet<String>(supportedMimeTypes), new HashSet<String>(supportedEmbedMimeTypes));
    }

    public TikaPoweredMetadataExtracter(HashSet<String> supportedMimeTypes) {
        this(supportedMimeTypes, (HashSet<String>)null);
    }

    public TikaPoweredMetadataExtracter(HashSet<String> supportedMimeTypes, HashSet<String> supportedEmbedMimeTypes) {
        super(supportedMimeTypes, supportedEmbedMimeTypes);
        for (DateFormat df : this.tikaDateFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM-dd", Locale.US), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy/MM/dd", Locale.US), new SimpleDateFormat("EEE MMM dd hh:mm:ss zzz yyyy"), new SimpleDateFormat("EEE MMM dd hh:mm:ss zzz yyyy", Locale.US)}) {
            SimpleDateFormat sdf;
            if (!(df instanceof SimpleDateFormat) || !(sdf = (SimpleDateFormat)df).toPattern().endsWith("'Z'")) continue;
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    @Override
    protected Date makeDate(String dateStr) {
        for (DateFormat df : this.tikaDateFormats) {
            try {
                return df.parse(dateStr);
            }
            catch (ParseException ee) {
            }
        }
        return super.makeDate(dateStr);
    }

    protected abstract Parser getParser();

    protected Embedder getEmbedder() {
        return null;
    }

    protected boolean needHeaderContents() {
        return false;
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        return properties;
    }

    protected InputStream getInputStream(ContentReader reader) throws IOException {
        if (reader instanceof FileContentReader) {
            return TikaInputStream.get((File)((FileContentReader)reader).getFile());
        }
        InputStream input = reader.getContentInputStream();
        if ("image/jpeg".equals(reader.getMimetype()) || "image/tiff".equals(reader.getMimetype())) {
            TemporaryResources tmp = new TemporaryResources();
            TikaInputStream stream = TikaInputStream.get((InputStream)input, (TemporaryResources)tmp);
            stream.getFile();
            return stream;
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        Map<String, Serializable> rawProperties = this.newRawMap();
        InputStream is = null;
        try {
            Object handler;
            is = this.getInputStream(reader);
            Parser parser = this.getParser();
            ParseContext context = new ParseContext();
            Metadata metadata = new Metadata();
            metadata.add("Content-Type", reader.getMimetype());
            Map<String, String> headers = null;
            if (this.needHeaderContents()) {
                MapCaptureContentHandler headerCapture = new MapCaptureContentHandler();
                headers = headerCapture.tags;
                handler = new HeadContentHandler(headerCapture);
            } else {
                handler = new NullContentHandler();
            }
            parser.parse(is, (ContentHandler)handler, metadata, context);
            for (String tikaKey : metadata.names()) {
                this.putRawValue(tikaKey, (Serializable)((Object)metadata.get(tikaKey)), rawProperties);
            }
            this.putRawValue(KEY_AUTHOR, (Serializable)((Object)metadata.get("Author")), rawProperties);
            this.putRawValue(KEY_TITLE, (Serializable)((Object)metadata.get(KEY_TITLE)), rawProperties);
            this.putRawValue(KEY_COMMENTS, (Serializable)((Object)metadata.get("Comments")), rawProperties);
            String subject = metadata.get(KEY_SUBJECT);
            String description = metadata.get(KEY_DESCRIPTION);
            if (subject != null && description != null) {
                this.putRawValue(KEY_DESCRIPTION, (Serializable)((Object)description), rawProperties);
                this.putRawValue(KEY_SUBJECT, (Serializable)((Object)subject), rawProperties);
            } else if (subject != null) {
                this.putRawValue(KEY_DESCRIPTION, (Serializable)((Object)subject), rawProperties);
                this.putRawValue(KEY_SUBJECT, (Serializable)((Object)subject), rawProperties);
            } else if (description != null) {
                this.putRawValue(KEY_DESCRIPTION, (Serializable)((Object)description), rawProperties);
                this.putRawValue(KEY_SUBJECT, (Serializable)((Object)description), rawProperties);
            }
            if (metadata.get(Metadata.CREATION_DATE) != null) {
                this.putRawValue(KEY_CREATED, (Serializable)((Object)metadata.get(Metadata.CREATION_DATE)), rawProperties);
            } else if (metadata.get(Metadata.DATE) != null) {
                this.putRawValue(KEY_CREATED, (Serializable)((Object)metadata.get(Metadata.DATE)), rawProperties);
            }
            rawProperties = this.extractSpecific(metadata, rawProperties, headers);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return rawProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void embedInternal(Map<String, Serializable> properties, ContentReader reader, ContentWriter writer) throws Throwable {
        Embedder embedder = this.getEmbedder();
        if (embedder == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            Metadata metadataToEmbed = new Metadata();
            for (String metadataKey : properties.keySet()) {
                Serializable value = properties.get(metadataKey);
                if (value == null) continue;
                if (value instanceof Collection) {
                    for (Object singleValue : (Collection)((Object)value)) {
                        try {
                            metadataToEmbed.add(metadataKey, (String)DefaultTypeConverter.INSTANCE.convert(String.class, singleValue));
                        }
                        catch (TypeConversionException e) {
                            logger.info((Object)("Could not convert " + metadataKey + ": " + e.getMessage()));
                        }
                    }
                    continue;
                }
                try {
                    metadataToEmbed.add(metadataKey, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value));
                }
                catch (TypeConversionException e) {
                    logger.info((Object)("Could not convert " + metadataKey + ": " + e.getMessage()));
                }
            }
            InputStream inputStream = this.getInputStream(reader);
            outputStream = writer.getContentOutputStream();
            embedder.embed(metadataToEmbed, inputStream, outputStream, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    protected static class NullContentHandler
    implements ContentHandler {
        protected NullContentHandler() {
        }

        @Override
        public void characters(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String paramString1, String paramString2, String paramString3) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String paramString) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws SAXException {
        }

        @Override
        public void processingInstruction(String paramString1, String paramString2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator paramLocator) {
        }

        @Override
        public void skippedEntity(String paramString) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String paramString1, String paramString2, String paramString3, Attributes paramAttributes) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String paramString1, String paramString2) throws SAXException {
        }
    }

    protected static class MapCaptureContentHandler
    implements ContentHandler {
        protected Map<String, String> tags = new HashMap<String, String>();
        private StringBuffer text;

        protected MapCaptureContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int len) {
            if (this.text != null) {
                this.text.append(ch, start, len);
            }
        }

        @Override
        public void endElement(String namespace, String localname, String qname) {
            if (this.text != null && this.text.length() > 0) {
                this.tags.put(qname, this.text.toString());
            }
            this.text = null;
        }

        @Override
        public void startElement(String namespace, String localname, String qname, Attributes attrs) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.tags.put(attrs.getQName(i), attrs.getValue(i));
            }
            this.text = new StringBuffer();
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String paramString) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws SAXException {
        }

        @Override
        public void processingInstruction(String paramString1, String paramString2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator paramLocator) {
        }

        @Override
        public void skippedEntity(String paramString) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String paramString1, String paramString2) throws SAXException {
        }
    }

    protected static class HeadContentHandler
    extends ContentHandlerDecorator {
        private static final XPathParser PARSER = new XPathParser("xhtml", "http://www.w3.org/1999/xhtml");
        private static final Matcher MATCHER = PARSER.parse("/xhtml:html/xhtml:head/descendant:node()");

        protected HeadContentHandler(ContentHandler handler) {
            super((ContentHandler)new MatchingContentHandler(handler, MATCHER));
        }
    }
}

