/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Map;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractContentTransformerLimits
extends ContentTransformerHelper
implements ContentTransformer,
BeanNameAware {
    private TransformationOptionLimits limits = new TransformationOptionLimits();
    private Map<String, Map<String, TransformationOptionLimits>> mimetypeLimits;
    private boolean pageLimitsSupported;
    protected TransformerDebug transformerDebug;
    private String beanName;

    protected boolean isPageLimitSupported(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.pageLimitsSupported;
    }

    public void setPageLimitsSuported(boolean pageLimitsSupported) {
        this.pageLimitsSupported = pageLimitsSupported;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        throw new IllegalStateException("Method should no longer be called. Override isTransformableMimetype in subclass.");
    }

    @Override
    public boolean isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        return this.isSupportedTransformation(sourceMimetype, targetMimetype, options) && this.isTransformableMimetype(sourceMimetype, targetMimetype, options) && this.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options);
    }

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.isTransformable(sourceMimetype, targetMimetype, options);
    }

    @Override
    public boolean isTransformableSize(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        boolean sizeOkay = true;
        if (sourceSize >= 0L) {
            long maxSourceSizeKBytes = this.getMaxSourceSizeKBytes(sourceMimetype, targetMimetype, options);
            boolean bl = sizeOkay = maxSourceSizeKBytes < 0L || maxSourceSizeKBytes > 0L && sourceSize <= maxSourceSizeKBytes * 1024L;
            if (!sizeOkay && this.transformerDebug.isEnabled()) {
                this.transformerDebug.unavailableTransformer(this, maxSourceSizeKBytes);
            }
        }
        return sizeOkay;
    }

    @Override
    public long getMaxSourceSizeKBytes(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        long maxSourceSizeKBytes = -1L;
        TransformationOptionLimits limits = this.getLimits(sourceMimetype, targetMimetype, options);
        if (!this.isPageLimitSupported(sourceMimetype, targetMimetype, options) || limits.getPageLimit() <= 0) {
            maxSourceSizeKBytes = limits.getMaxSourceSizeKBytes();
        }
        return maxSourceSizeKBytes;
    }

    protected long getTimeoutMs() {
        return this.limits.getTimeoutMs();
    }

    public void setTimeoutMs(long timeoutMs) {
        this.limits.setTimeoutMs(timeoutMs);
    }

    protected long getReadLimitTimeMs() {
        return this.limits.getReadLimitTimeMs();
    }

    public void setReadLimitTimeMs(long readLimitTimeMs) {
        this.limits.setReadLimitTimeMs(readLimitTimeMs);
    }

    protected long getMaxSourceSizeKBytes() {
        return this.limits.getMaxSourceSizeKBytes();
    }

    public void setMaxSourceSizeKBytes(long maxSourceSizeKBytes) {
        this.limits.setMaxSourceSizeKBytes(maxSourceSizeKBytes);
    }

    protected long getReadLimitKBytes() {
        return this.limits.getReadLimitKBytes();
    }

    public void setReadLimitKBytes(long readLimitKBytes) {
        this.limits.setReadLimitKBytes(readLimitKBytes);
    }

    protected int getMaxPages() {
        return this.limits.getMaxPages();
    }

    public void setMaxPages(int maxPages) {
        this.limits.setMaxPages(maxPages);
    }

    protected int getPageLimit() {
        return this.limits.getPageLimit();
    }

    public void setPageLimit(int pageLimit) {
        this.limits.setPageLimit(pageLimit);
    }

    protected TransformationOptionLimits getLimits() {
        return this.limits;
    }

    public void setLimits(TransformationOptionLimits limits) {
        this.limits = limits;
    }

    protected Map<String, Map<String, TransformationOptionLimits>> getMimetypeLimits() {
        return this.mimetypeLimits;
    }

    public void setMimetypeLimits(Map<String, Map<String, TransformationOptionLimits>> mimetypeLimits) {
        this.mimetypeLimits = mimetypeLimits;
    }

    protected TransformationOptionLimits getLimits(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        return reader == null || writer == null ? this.limits.combine(options.getLimits()) : this.getLimits(reader.getMimetype(), writer.getMimetype(), options);
    }

    protected TransformationOptionLimits getLimits(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        TransformationOptionLimits mimetypeLimits = null;
        if (this.mimetypeLimits != null) {
            boolean anySource = false;
            Map<String, TransformationOptionLimits> targetLimits = this.mimetypeLimits.get(sourceMimetype);
            if (targetLimits == null) {
                targetLimits = this.mimetypeLimits.get("*");
                anySource = true;
            }
            if (targetLimits != null && (mimetypeLimits = targetLimits.get(targetMimetype)) == null && (mimetypeLimits = targetLimits.get("*")) == null && !anySource && (targetLimits = this.mimetypeLimits.get("*")) != null && (mimetypeLimits = targetLimits.get(targetMimetype)) == null) {
                mimetypeLimits = targetLimits.get("*");
            }
        }
        TransformationOptionLimits combined = mimetypeLimits == null ? this.limits : this.limits.combine(mimetypeLimits);
        return options == null ? combined : combined.combine(options.getLimits());
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    protected void setReaderLimits(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        if (reader instanceof AbstractContentReader) {
            AbstractContentReader abstractContentReader = (AbstractContentReader)reader;
            TransformationOptionLimits limits = this.getLimits(reader, writer, options);
            abstractContentReader.setLimits(limits);
            abstractContentReader.setTransformerDebug(this.transformerDebug);
        }
    }
}

