/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.content.AbstractContentReaderLimitTest;
import org.alfresco.repo.content.ContentMinimalContextTestSuite;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.AbstractContentTransformerLimits;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class AbstractContentTransformerLimitsTest {
    private static final String A = "a";
    private static final String B = "b";
    private static final String C = "c";
    private AbstractContentTransformerLimits transformer;
    private TransformationOptionLimits limits;
    private Map<String, Map<String, TransformationOptionLimits>> mimetypeLimits;
    private TransformationOptions options;

    @Before
    public void setUp() throws Exception {
        ApplicationContext ctx = ContentMinimalContextTestSuite.getContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        MimetypeService mimetypeService = serviceRegistry.getMimetypeService();
        TransformerDebug transformerDebug = (TransformerDebug)ctx.getBean("transformerDebug");
        this.transformer = new AbstractContentTransformer2(){

            @Override
            public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
                return false;
            }

            @Override
            protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
            }
        };
        this.transformer.setMimetypeService(mimetypeService);
        this.transformer.setTransformerDebug(transformerDebug);
        this.limits = new TransformationOptionLimits();
        this.options = new TransformationOptions();
    }

    private void addMimetypeLimits(String source, String target, TransformationOptionLimits limits) {
        Map<String, TransformationOptionLimits> targetLimits;
        if (this.mimetypeLimits == null) {
            this.mimetypeLimits = new HashMap<String, Map<String, TransformationOptionLimits>>();
        }
        if ((targetLimits = this.mimetypeLimits.get(source)) == null) {
            targetLimits = new HashMap<String, TransformationOptionLimits>();
            this.mimetypeLimits.put(source, targetLimits);
        }
        targetLimits.put(target, limits);
    }

    @Test
    public void testTimeoutMs() throws Exception {
        long value = 1234L;
        this.transformer.setTimeoutMs(value);
        long actual = this.transformer.getTimeoutMs();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testReadLimitTimeMs() throws Exception {
        long value = 1234L;
        this.transformer.setReadLimitTimeMs(value);
        long actual = this.transformer.getReadLimitTimeMs();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testMaxSourceSizeKBytes() throws Exception {
        long value = 1234L;
        this.transformer.setMaxSourceSizeKBytes(value);
        long actual = this.transformer.getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testReadLimitKBytes() throws Exception {
        long value = 1234L;
        this.transformer.setReadLimitKBytes(value);
        long actual = this.transformer.getReadLimitKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testMaxPages() throws Exception {
        int value = 1234;
        this.transformer.setMaxPages(value);
        int actual = this.transformer.getMaxPages();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testPageLimit() throws Exception {
        int value = 1234;
        this.transformer.setPageLimit(value);
        int actual = this.transformer.getPageLimit();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testMimetypeLimit() throws Exception {
        long value = 1234L;
        this.limits.setMaxSourceSizeKBytes(value);
        this.addMimetypeLimits(A, B, this.limits);
        this.transformer.setMimetypeLimits(this.mimetypeLimits);
        long actual = this.transformer.getLimits(A, B, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
        actual = this.transformer.getLimits(A, C, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Other values should not be set", (long)-1L, (long)actual);
    }

    @Test
    public void testMimetypeLimitTargetWildcard() throws Exception {
        long value = 1234L;
        this.limits.setMaxSourceSizeKBytes(value);
        this.addMimetypeLimits(A, "*", this.limits);
        this.transformer.setMimetypeLimits(this.mimetypeLimits);
        long actual = this.transformer.getLimits(A, B, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
        actual = this.transformer.getLimits(B, A, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Other values should not be set", (long)-1L, (long)actual);
    }

    @Test
    public void testMimetypeLimitSourceWildcard() throws Exception {
        long value = 1234L;
        this.limits.setMaxSourceSizeKBytes(value);
        this.addMimetypeLimits("*", B, this.limits);
        this.transformer.setMimetypeLimits(this.mimetypeLimits);
        long actual = this.transformer.getLimits(A, B, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
        actual = this.transformer.getLimits(B, A, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Other values should not be set", (long)-1L, (long)actual);
    }

    @Test
    public void testPassedInOptions() throws Exception {
        long value = 1234L;
        this.limits.setMaxSourceSizeKBytes(value + 1L);
        this.addMimetypeLimits(A, B, this.limits);
        this.transformer.setMimetypeLimits(this.mimetypeLimits);
        long actual = this.transformer.getLimits(A, B, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)(value + 1L), (long)actual);
        this.options.setMaxSourceSizeKBytes(value);
        actual = this.transformer.getLimits(A, B, this.options).getMaxSourceSizeKBytes();
        Assert.assertEquals((String)"Getter did not return set value", (long)value, (long)actual);
    }

    @Test
    public void testGetMaxSourceSizeKBytes() throws Exception {
        long kValue = 12L;
        long byteValue = kValue * 1024L;
        Assert.assertTrue((String)"No limits so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        this.limits.setMaxSourceSizeKBytes(kValue);
        this.addMimetypeLimits(A, B, this.limits);
        this.transformer.setMimetypeLimits(this.mimetypeLimits);
        Assert.assertEquals((String)"Expected to have set value returned", (long)kValue, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
        Assert.assertEquals((String)"Expected to have -1 (unlimited) returned", (long)-1L, (long)this.transformer.getMaxSourceSizeKBytes(C, B, this.options));
        this.limits.setMaxSourceSizeKBytes(-1L);
        Assert.assertEquals((String)"Expected to have -1 (unlimited) returned", (long)-1L, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue);
        Assert.assertEquals((String)"Expected to have transformer set value returned", (long)kValue, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue);
        this.limits.setMaxSourceSizeKBytes(kValue + 1L);
        Assert.assertEquals((String)"Expected to have transformer set value returned", (long)kValue, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue + 1L);
        this.limits.setMaxSourceSizeKBytes(kValue);
        Assert.assertEquals((String)"Expected to have transformer set value returned", (long)kValue, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue);
        this.limits.setMaxSourceSizeKBytes(kValue + 1L);
        this.limits.setPageLimit(1);
        Assert.assertEquals((String)"Expected to ignore the page limit as the transformer does not support it", (long)kValue, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue);
        this.limits.setMaxSourceSizeKBytes(kValue + 1L);
        this.transformer.setPageLimitsSuported(true);
        this.limits.setPageLimit(1);
        Assert.assertEquals((String)"Expected to have -1 (unlimited) returned when there are page limits", (long)-1L, (long)this.transformer.getMaxSourceSizeKBytes(A, B, this.options));
    }

    @Test
    public void testIsTransformableSize() throws Exception {
        long kValue = 12L;
        long byteValue = kValue * 1024L;
        Assert.assertTrue((String)"No limits so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        this.limits.setMaxSourceSizeKBytes(kValue);
        this.addMimetypeLimits(A, B, this.limits);
        this.transformer.setMimetypeLimits(this.mimetypeLimits);
        Assert.assertTrue((String)"Size is less than limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue - 1L, B, this.options));
        Assert.assertTrue((String)"Size is equal to limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue, B, this.options));
        Assert.assertFalse((String)"Size is greater than limit so should not have failed", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        Assert.assertTrue((String)"No limits so should have been ok", (boolean)this.transformer.isTransformableSize(C, byteValue + 1L, B, this.options));
        Assert.assertTrue((String)"No limits so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, C, this.options));
        Assert.assertTrue((String)"No limits so should have been ok", (boolean)this.transformer.isTransformableSize(C, byteValue + 1L, C, this.options));
        this.limits.setMaxSourceSizeKBytes(-1L);
        Assert.assertTrue((String)"No limits so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue);
        Assert.assertTrue((String)"Size is equal to limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue, B, this.options));
        Assert.assertFalse((String)"Size is greater than limit so should not have failed", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue);
        this.limits.setMaxSourceSizeKBytes(kValue + 1L);
        Assert.assertTrue((String)"Size is equal to limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue, B, this.options));
        Assert.assertFalse((String)"Size is greater than limit so should not have failed", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        this.transformer.setMaxSourceSizeKBytes(kValue + 1L);
        this.limits.setMaxSourceSizeKBytes(kValue);
        Assert.assertTrue((String)"Size is equal to limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue, B, this.options));
        Assert.assertFalse((String)"Size is greater than limit so should not have failed", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
    }

    @Test
    public void testIsTransformableSizeWithPageLimit() throws Exception {
        long kValue = 12L;
        long byteValue = kValue * 1024L;
        this.transformer.setMaxSourceSizeKBytes(kValue);
        this.transformer.setPageLimitsSuported(true);
        Assert.assertTrue((String)"Size is less than limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue - 1L, B, this.options));
        Assert.assertTrue((String)"Size is equal to limit so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue, B, this.options));
        Assert.assertFalse((String)"Size is greater than limit so should not have failed", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
        this.options.getLimits().setPageLimit(1);
        Assert.assertTrue((String)"Size is greater than limit BUT pageLimit is set so should have been ok", (boolean)this.transformer.isTransformableSize(A, byteValue + 1L, B, this.options));
    }

    @Test
    public void testSetReaderLimits() throws Exception {
        AbstractContentReaderLimitTest.DummyAbstractContentReader reader = new AbstractContentReaderLimitTest.DummyAbstractContentReader(0L, 0L);
        long value = 1234L;
        this.transformer.setTimeoutMs(value);
        Assert.assertEquals((String)"Limit should not have been set in the reader", null, (Object)reader.getLimits());
        this.transformer.setReaderLimits(reader, null, this.options);
        Assert.assertEquals((String)"Limit should have been set in the reader", (long)value, (long)reader.getLimits().getTimeoutMs());
        this.options.setTimeoutMs(--value);
        this.transformer.setReaderLimits(reader, null, this.options);
        Assert.assertEquals((String)"Limit should have been set in the reader", (long)value, (long)reader.getLimits().getTimeoutMs());
    }
}

