/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.alfresco.repo.content.ContentMinimalContextTestSuite;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

public abstract class AbstractContentTransformerTest
extends TestCase {
    protected static String QUICK_CONTENT = "The quick brown fox jumps over the lazy dog";
    private static String[] QUICK_WORDS = new String[]{"quick", "brown", "fox", "jumps", "lazy", "dog"};
    private static Log logger = LogFactory.getLog(AbstractContentTransformerTest.class);
    protected ApplicationContext ctx;
    protected ServiceRegistry serviceRegistry;
    protected MimetypeService mimetypeService;
    protected TransformerDebug transformerDebug;

    protected abstract ContentTransformer getTransformer(String var1, String var2);

    protected void setUp() throws Exception {
        this.ctx = ContentMinimalContextTestSuite.getContext();
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.mimetypeService = this.serviceRegistry.getMimetypeService();
        this.transformerDebug = (TransformerDebug)this.ctx.getBean("transformerDebug");
        long now = System.currentTimeMillis();
        TempFileProvider.TempFileCleanerJob.removeFiles((long)now);
    }

    public void testSetUp() throws Exception {
        AbstractContentTransformerTest.assertNotNull((String)"MimetypeMap not present", (Object)this.mimetypeService);
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
        AbstractContentTransformerTest.assertNotNull((Object)sourceFile);
    }

    public static File loadNamedQuickTestFile(String quickname) throws IOException {
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/" + quickname);
        if (url == null) {
            return null;
        }
        return ResourceUtils.getFile((URL)url);
    }

    public static File loadQuickTestFile(String extension) throws IOException {
        return AbstractContentTransformerTest.loadNamedQuickTestFile("quick." + extension);
    }

    protected String[] getQuickFilenames(String sourceMimetype) {
        String sourceExtension = this.mimetypeService.getExtension(sourceMimetype);
        return new String[]{"quick." + sourceExtension};
    }

    protected static ContentReader buildContentReader(String text, Charset encoding) throws IOException {
        File tmpFile = TempFileProvider.createTempFile((String)"AlfrescoTest_", (String)".txt");
        FileOutputStream out = new FileOutputStream(tmpFile);
        OutputStreamWriter wout = new OutputStreamWriter((OutputStream)out, encoding);
        wout.write(text);
        wout.close();
        out.close();
        FileContentReader reader = new FileContentReader(tmpFile);
        reader.setEncoding(encoding.displayName());
        reader.setMimetype("text/plain");
        return reader;
    }

    public void testAllConversions() throws Exception {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("Mimetype Conversion Tests \n").append("========================= \n").append("   Date: ").append(new Date()).append("\n").append("\n");
        TreeSet mimetypes = new TreeSet(this.mimetypeService.getMimetypes());
        for (String sourceMimetype : mimetypes) {
            String[] quickFiles = this.getQuickFilenames(sourceMimetype);
            sb.append("   Source Files: ");
            for (String quickFile : quickFiles) {
                sb.append(quickFile);
                sb.append(' ');
            }
            sb.append("\n");
            for (String quickFile : quickFiles) {
                String sourceExtension = quickFile.substring(quickFile.lastIndexOf(46) + 1);
                for (String targetMimetype : mimetypes) {
                    if (sourceMimetype.equals(targetMimetype)) continue;
                    FileContentWriter targetWriter = null;
                    String targetExtension = this.mimetypeService.getExtension(targetMimetype);
                    ContentTransformer transformer = this.getTransformer(sourceMimetype, targetMimetype);
                    if (transformer == null || !transformer.isTransformable(sourceMimetype, -1L, targetMimetype, null) || this.isTransformationExcluded(sourceExtension, targetExtension)) continue;
                    sb.append("      Target Extension: ").append(targetExtension);
                    sb.append(" <").append(transformer.getClass().getSimpleName()).append(">");
                    File sourceFile = AbstractContentTransformerTest.loadNamedQuickTestFile(quickFile);
                    if (sourceFile == null) {
                        sb.append(" <no source test file>\n");
                        continue;
                    }
                    FileContentReader sourceReader = new FileContentReader(sourceFile);
                    int count = 0;
                    long before = System.currentTimeMillis();
                    HashSet<String> transformerClasses = new HashSet<String>(2);
                    for (int i = 0; i < 5; ++i) {
                        String checkContent;
                        ContentReader targetReader;
                        transformer = this.getTransformer(sourceMimetype, targetMimetype);
                        if (!transformerClasses.contains(transformer.getClass().getName())) {
                            transformerClasses.add(transformer.getClass().getName());
                            sb.append(" <").append(transformer.getClass().getSimpleName()).append(">");
                        }
                        File targetFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_" + sourceExtension + "_"), (String)("." + targetExtension));
                        targetWriter = new FileContentWriter(targetFile);
                        sourceReader.setMimetype(sourceMimetype);
                        targetWriter.setMimetype(targetMimetype);
                        transformer.transform(sourceReader.getReader(), targetWriter);
                        if (this.isQuickPhraseExpected(targetMimetype)) {
                            targetReader = targetWriter.getReader();
                            checkContent = targetReader.getContentString();
                            AbstractContentTransformerTest.assertTrue((String)("Quick phrase not present in document converted to text: \n   transformer: " + transformer + "\n" + "   source: " + sourceReader + "\n" + "   target: " + targetWriter), (boolean)checkContent.contains(QUICK_CONTENT));
                            this.additionalContentCheck(sourceMimetype, targetMimetype, checkContent);
                        } else if (this.isQuickWordsExpected(targetMimetype)) {
                            targetReader = targetWriter.getReader();
                            checkContent = targetReader.getContentString();
                            for (int word = 0; word < QUICK_WORDS.length; ++word) {
                                AbstractContentTransformerTest.assertTrue((String)("Quick phrase word not present in document converted to text: \n   transformer: " + transformer + "\n" + "   source: " + sourceReader + "\n" + "   target: " + targetWriter + "\n" + "   word: " + word), (boolean)checkContent.contains(QUICK_WORDS[word]));
                            }
                        }
                        ++count;
                    }
                    long after = System.currentTimeMillis();
                    double average = (double)(after - before) / (double)count;
                    sb.append(String.format(" average %10.0f ms", average)).append("\n");
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Transformation performed " + count + " time: " + sourceMimetype + " --> " + targetMimetype + "\n" + "   source: " + sourceReader + "\n" + "   target: " + targetWriter + "\n" + "   transformer: " + this.getTransformer(sourceMimetype, targetMimetype)));
                }
            }
        }
        File outputFile = TempFileProvider.createTempFile((String)"AbstractContentTransformerTest-results-", (String)".txt");
        FileContentWriter outputWriter = new FileContentWriter(outputFile);
        outputWriter.setEncoding("UTF8");
        outputWriter.putContent(sb.toString());
    }

    protected void additionalContentCheck(String sourceMimetype, String targetMimetype, String contents) {
    }

    protected boolean isQuickPhraseExpected(String targetMimetype) {
        return targetMimetype.equals("text/plain");
    }

    protected boolean isQuickWordsExpected(String targetMimetype) {
        return targetMimetype.startsWith("text/");
    }

    protected boolean isTransformationExcluded(String sourceExtension, String targetExtension) {
        return false;
    }
}

