/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppleIWorksContentTransformer
extends AbstractContentTransformer2 {
    private static final Log log = LogFactory.getLog(AppleIWorksContentTransformer.class);
    private static final String QUICK_LOOK_PREVIEW_PDF = "QuickLook/Preview.pdf";
    private static final String QUICK_LOOK_THUMBNAIL_JPG = "QuickLook/Thumbnail.jpg";
    private static final List<String> IWORKS_MIMETYPES = Arrays.asList("application/vnd.apple.keynote", "application/vnd.apple.numbers", "application/vnd.apple.pages");
    private static final List<String> TARGET_MIMETYPES = Arrays.asList("image/jpeg", "application/pdf");

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return TARGET_MIMETYPES.contains(targetMimetype) && IWORKS_MIMETYPES.contains(sourceMimetype);
    }

    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        String sourceMimetype = reader.getMimetype();
        String sourceExtension = this.getMimetypeService().getExtension(sourceMimetype);
        String targetMimetype = writer.getMimetype();
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Transforming from ").append(sourceMimetype).append(" to ").append(targetMimetype);
            log.debug((Object)msg.toString());
        }
        ZipArchiveInputStream iWorksZip = null;
        try {
            iWorksZip = new ZipArchiveInputStream(reader.getContentInputStream());
            ZipArchiveEntry entry = null;
            boolean found = false;
            while (!found && (entry = iWorksZip.getNextZipEntry()) != null) {
                if ("image/jpeg".equals(targetMimetype) && entry.getName().equals(QUICK_LOOK_THUMBNAIL_JPG)) {
                    writer.putContent((InputStream)iWorksZip);
                    found = true;
                    continue;
                }
                if (!"application/pdf".equals(targetMimetype) || !entry.getName().equals(QUICK_LOOK_PREVIEW_PDF)) continue;
                writer.putContent((InputStream)iWorksZip);
                found = true;
            }
            if (!found) {
                throw new AlfrescoRuntimeException("Unable to transform " + sourceExtension + " file to " + targetMimetype);
            }
        }
        catch (FileNotFoundException e1) {
            throw new AlfrescoRuntimeException("Unable to transform " + sourceExtension + " file.", (Throwable)e1);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unable to transform " + sourceExtension + " file.", (Throwable)e);
        }
        finally {
            if (iWorksZip != null) {
                iWorksZip.close();
            }
        }
    }
}

