/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.pkg.PackageParser;

public class ArchiveContentTransformer
extends TikaPoweredContentTransformer {
    private static Log logger = LogFactory.getLog(ArchiveContentTransformer.class);
    private boolean includeContents = false;
    private TikaConfig tikaConfig;
    public static ArrayList<String> SUPPORTED_MIMETYPES = new ArrayList();

    public ArchiveContentTransformer() {
        super(SUPPORTED_MIMETYPES);
    }

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    public void setIncludeContents(String includeContents) {
        this.includeContents = false;
        if (includeContents != null && includeContents.length() > 0) {
            this.includeContents = (Boolean)TransformationOptions.relaxedBooleanTypeConverter.convert((Object)includeContents);
        }
    }

    @Override
    protected Parser getParser() {
        return new PackageParser();
    }

    @Override
    protected ParseContext buildParseContext(Metadata metadata, String targetMimeType, TransformationOptions options) {
        ParseContext context = super.buildParseContext(metadata, targetMimeType, options);
        boolean recurse = this.includeContents;
        if (options.getIncludeEmbedded() != null) {
            recurse = options.getIncludeEmbedded();
        }
        if (recurse) {
            if (this.tikaConfig == null) {
                this.tikaConfig = TikaConfig.getDefaultConfig();
            }
            context.set(Parser.class, (Object)new AutoDetectParser(this.tikaConfig));
        }
        return context;
    }

    static {
        PackageParser p = new PackageParser();
        for (MediaType mt : p.getSupportedTypes(null)) {
            SUPPORTED_MIMETYPES.add(mt.toString());
        }
    }
}

