/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ExplictTransformationDetails;
import org.alfresco.repo.content.transform.SupportedTransformation;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class ContentTransformerHelper {
    private MimetypeService mimetypeService;
    private List<ExplictTransformationDetails> explicitTransformations;
    private List<SupportedTransformation> supportedTransformations;
    private List<SupportedTransformation> unsupportedTransformations;

    public ContentTransformerHelper() {
        this.setExplicitTransformations(Collections.<ExplictTransformationDetails>emptyList());
        this.setSupportedTransformations(null);
        this.setUnsupportedTransformations(null);
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setExplicitTransformations(List<ExplictTransformationDetails> explicitTransformations) {
        this.explicitTransformations = explicitTransformations;
    }

    public void setSupportedTransformations(List<SupportedTransformation> supportedTransformations) {
        this.supportedTransformations = supportedTransformations;
    }

    public void setUnsupportedTransformations(List<SupportedTransformation> unsupportedTransformations) {
        this.unsupportedTransformations = unsupportedTransformations;
    }

    protected String getMimetype(ContentAccessor content) {
        String mimetype = content.getMimetype();
        if (mimetype == null) {
            throw new AlfrescoRuntimeException("Mimetype is mandatory for transformation: " + content);
        }
        return mimetype;
    }

    public boolean isExplicitTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = false;
        for (ExplictTransformationDetails explicitTransformation : this.explicitTransformations) {
            if (!sourceMimetype.equals(explicitTransformation.getSourceMimetype()) || !targetMimetype.equals(explicitTransformation.getTargetMimetype())) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isSupportedTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean supported = true;
        if (this.supportedTransformations != null) {
            supported = false;
            for (SupportedTransformation suportedTransformation : this.supportedTransformations) {
                String supportedSourceMimetype = suportedTransformation.getSourceMimetype();
                String supportedTargetMimetype = suportedTransformation.getTargetMimetype();
                if (supportedSourceMimetype != null && !sourceMimetype.equals(supportedSourceMimetype) || supportedTargetMimetype != null && !targetMimetype.equals(supportedTargetMimetype)) continue;
                supported = true;
                break;
            }
        }
        if (supported && this.unsupportedTransformations != null) {
            for (SupportedTransformation unsuportedTransformation : this.unsupportedTransformations) {
                String unsupportedSourceMimetype = unsuportedTransformation.getSourceMimetype();
                String unsupportedTargetMimetype = unsuportedTransformation.getTargetMimetype();
                if (unsupportedSourceMimetype != null && !sourceMimetype.equals(unsupportedSourceMimetype) || unsupportedTargetMimetype != null && !targetMimetype.equals(unsupportedTargetMimetype)) continue;
                supported = false;
                break;
            }
        }
        return supported;
    }
}

