/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.MailContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class MailContentTransformerTest
extends AbstractContentTransformerTest {
    private MailContentTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new MailContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        MailContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.ms-outlook", new TransformationOptions()));
        MailContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", -1L, "text/plain", new TransformationOptions()));
    }

    public void testMsgToText() throws Exception {
        File msgSourceFile = MailContentTransformerTest.loadQuickTestFile("msg");
        File txtTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-1"), (String)".txt");
        FileContentReader reader = new FileContentReader(msgSourceFile);
        reader.setMimetype("application/vnd.ms-outlook");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        MailContentTransformerTest.assertTrue((boolean)reader2.getContentString().contains(QUICK_CONTENT));
    }

    public void testUnicodeMsgToText() throws Exception {
        File msgSourceFile = MailContentTransformerTest.loadQuickTestFile("unicode.msg");
        File txtTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-2"), (String)".txt");
        FileContentReader reader = new FileContentReader(msgSourceFile);
        reader.setMimetype("application/vnd.ms-outlook");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        MailContentTransformerTest.assertTrue((boolean)reader2.getContentString().contains(QUICK_CONTENT));
    }

    public void testNonUnicodeChineseMsgToText() throws Exception {
        File msgSourceFile = MailContentTransformerTest.loadQuickTestFile("chinese.msg");
        File txtTargetFile = TempFileProvider.createTempFile((String)(this.getName() + "-target-2"), (String)".txt");
        FileContentReader reader = new FileContentReader(msgSourceFile);
        reader.setMimetype("application/vnd.ms-outlook");
        FileContentWriter writer = new FileContentWriter(txtTargetFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        FileContentReader reader2 = new FileContentReader(txtTargetFile);
        reader2.setMimetype("text/plain");
        String text = reader2.getContentString();
        MailContentTransformerTest.assertTrue((boolean)text.contains(QUICK_CONTENT));
        MailContentTransformerTest.assertTrue((boolean)text.contains("(\u5f35\u6bd3\u502b)"));
        MailContentTransformerTest.assertTrue((boolean)text.contains("\u683c\u5f0f\u6e2c\u8a66 )"));
    }
}

