/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import net.sf.jooreports.openoffice.converter.OpenOfficeDocumentConverter;
import org.alfresco.repo.content.transform.ContentTransformerWorker;
import org.alfresco.repo.content.transform.OOoContentTransformerHelper;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.SocketOpenOfficeConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class OpenOfficeContentTransformerWorker
extends OOoContentTransformerHelper
implements ContentTransformerWorker,
InitializingBean {
    private static Log logger = LogFactory.getLog(OpenOfficeContentTransformerWorker.class);
    private OpenOfficeConnection connection;
    private AbstractOpenOfficeDocumentConverter converter;

    public void setConnection(OpenOfficeConnection connection) {
        this.connection = connection;
    }

    public void setConverter(AbstractOpenOfficeDocumentConverter converter) {
        this.converter = converter;
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected String getTempFilePrefix() {
        return "OpenOfficeContentTransformer";
    }

    @Override
    public boolean isAvailable() {
        return this.connection.isConnected();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)"OpenOfficeContentTransformerWorker", (String)"connection", (Object)this.connection);
        super.afterPropertiesSet();
        if (this.converter == null) {
            this.converter = this.getDefaultConverter(this.connection);
        }
    }

    protected AbstractOpenOfficeDocumentConverter getDefaultConverter(OpenOfficeConnection connection) {
        return connection instanceof SocketOpenOfficeConnection ? ((SocketOpenOfficeConnection)connection).getDefaultConverter() : new OpenOfficeDocumentConverter(connection);
    }

    @Override
    protected void convert(File tempFromFile, DocumentFormat sourceFormat, File tempToFile, DocumentFormat targetFormat) {
        this.converter.convert(tempFromFile, sourceFormat, tempToFile, targetFormat);
    }

    @Override
    public void saveContentInFile(String sourceMimetype, ContentReader reader, File file) throws ContentIOException {
        this.converter.setTextUtf8("text/plain".equals(sourceMimetype));
        super.saveContentInFile(sourceMimetype, reader, file);
    }
}

