/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;

public class TikaAutoContentTransformer
extends TikaPoweredContentTransformer {
    private static AutoDetectParser parser;
    private static TikaConfig config;
    public static ArrayList<String> SUPPORTED_MIMETYPES;

    private static ArrayList<String> buildMimeTypes(TikaConfig tikaConfig) {
        config = tikaConfig;
        parser = new AutoDetectParser(config);
        SUPPORTED_MIMETYPES = new ArrayList();
        for (MediaType baseType : parser.getParsers().keySet()) {
            ArrayList<MediaType> types = new ArrayList<MediaType>();
            types.add(baseType);
            types.addAll(config.getMediaTypeRegistry().getAliases(baseType));
            for (MediaType mt : types) {
                if (mt.toString().startsWith("application/vnd.oasis.opendocument.formula") || mt.toString().startsWith("application/vnd.oasis.opendocument.graphics") || mt.getType().equals("image") || mt.getType().equals("audio") || mt.getType().equals("video") || mt.toString().equals("application/zip") || mt.toString().equals("application/tar") || mt.toString().equals("application/x-tar") || mt.toString().equals("message/rfc822") || mt.toString().equals("application/vnd.ms-outlook")) continue;
                SUPPORTED_MIMETYPES.add(mt.toString());
            }
        }
        return SUPPORTED_MIMETYPES;
    }

    public TikaAutoContentTransformer(TikaConfig tikaConfig) {
        super(TikaAutoContentTransformer.buildMimeTypes(tikaConfig));
    }

    @Override
    protected Parser getParser() {
        return parser;
    }
}

