/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.AbstractContentTransformerLimits;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.FailoverContentTransformer;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformerWorker;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformerDebug {
    private static final Log logger = LogFactory.getLog(TransformerDebug.class);
    private static final TransformerLog info = new TransformerLog();
    private static final String NO_TRANSFORMERS = "No transformers";
    private final NodeService nodeService;
    private final MimetypeService mimetypeService;

    public TransformerDebug(NodeService nodeService, MimetypeService mimetypeService) {
        this.nodeService = nodeService;
        this.mimetypeService = mimetypeService;
    }

    public void pushAvailable(String fromUrl, String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (this.isEnabled()) {
            this.push(null, fromUrl, sourceMimetype, targetMimetype, -1L, options, Call.AVAILABLE);
        }
    }

    public void pushTransform(ContentTransformer transformer, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions options) {
        if (this.isEnabled()) {
            this.push(this.getName(transformer), fromUrl, sourceMimetype, targetMimetype, sourceSize, options, Call.TRANSFORM);
        }
    }

    public void pushMisc() {
        if (this.isEnabled()) {
            this.push(null, null, null, null, -1L, null, Call.AVAILABLE);
        }
    }

    public void pushIsTransformableSize(ContentTransformer transformer) {
        if (this.isEnabled()) {
            ThreadInfo.getIsTransformableStack().push(this.getName(transformer));
        }
    }

    private void push(String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions options, Call callType) {
        Deque<Frame> ourStack = ThreadInfo.getStack();
        Frame frame = ourStack.peek();
        if (callType == Call.TRANSFORM && frame != null && frame.callType == Call.AVAILABLE) {
            frame.setTransformerName(transformerName);
            frame.setSourceSize(sourceSize);
            frame.callType = Call.AVAILABLE_AND_TRANSFORM;
        }
        boolean origDebugOutput = ThreadInfo.setDebugOutput(ThreadInfo.getDebugOutput() && sourceSize != 0L);
        frame = new Frame(frame, transformerName, fromUrl, sourceMimetype, targetMimetype, sourceSize, options, callType, origDebugOutput);
        ourStack.push(frame);
        if (callType == Call.TRANSFORM) {
            this.logBasicDetails(frame, sourceSize, transformerName, ourStack.size() == 1);
        }
    }

    public void unavailableTransformer(ContentTransformer transformer, long maxSourceSizeKBytes) {
        Deque<Frame> ourStack;
        Frame frame;
        if (this.isEnabled() && (frame = (ourStack = ThreadInfo.getStack()).peek()) != null) {
            boolean debug;
            Deque<String> isTransformableStack = ThreadInfo.getIsTransformableStack();
            String name = !isTransformableStack.isEmpty() ? isTransformableStack.getFirst() : this.getName(transformer);
            boolean bl = debug = maxSourceSizeKBytes != 0L;
            if (frame.unavailableTransformers == null) {
                frame.unavailableTransformers = new HashSet();
            }
            frame.unavailableTransformers.add(new UnavailableTransformer(name, maxSourceSizeKBytes, debug));
        }
    }

    public void availableTransformers(List<ContentTransformer> transformers, long sourceSize, String calledFrom) {
        if (this.isEnabled()) {
            boolean firstLevel;
            Deque<Frame> ourStack = ThreadInfo.getStack();
            Frame frame = ourStack.peek();
            boolean bl = firstLevel = ourStack.size() == 1;
            if (transformers.size() == 0) {
                frame.setFailureReason(NO_TRANSFORMERS);
                if (frame.unavailableTransformers != null && frame.unavailableTransformers.size() != 0) {
                    ThreadInfo.setDebugOutput(true);
                }
            }
            frame.setSourceSize(sourceSize);
            this.logBasicDetails(frame, sourceSize, calledFrom + (transformers.size() == 0 ? " NO transformers" : ""), firstLevel);
            char c = 'a';
            int longestNameLength = this.getLongestTransformerNameLength(transformers, frame);
            for (ContentTransformer trans : transformers) {
                String name = this.getName(trans);
                int padName = longestNameLength - name.length() + 1;
                long maxSourceSizeKBytes = trans.getMaxSourceSizeKBytes(frame.sourceMimetype, frame.targetMimetype, frame.options);
                String size = maxSourceSizeKBytes > 0L ? "< " + this.fileSize(maxSourceSizeKBytes * 1024L) : "";
                int padSize = 10 - size.length();
                String string = c == 'a' ? "**" : "  ";
                char c2 = c;
                c = (char)(c + '\u0001');
                this.log(string + c2 + ") " + name + this.spaces(padName) + size + this.spaces(padSize) + this.ms(trans.getTransformationTime()));
            }
            if (frame.unavailableTransformers != null) {
                for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                    int pad = longestNameLength - unavailable.name.length();
                    String reason = "> " + this.fileSize(unavailable.maxSourceSizeKBytes * 1024L);
                    char c3 = c;
                    c = (char)(c + 1);
                    this.log("--" + c3 + ") " + unavailable.name + this.spaces(pad + 1) + reason, unavailable.debug);
                }
            }
        }
    }

    public void inactiveTransformer(ContentTransformer transformer) {
        this.log(this.getName(transformer) + ' ' + this.ms(transformer.getTransformationTime()) + " INACTIVE");
    }

    public void activeTransformer(int mimetypePairCount, ContentTransformer transformer, String sourceMimetype, String targetMimetype, long maxSourceSizeKBytes, Boolean explicit, boolean firstMimetypePair) {
        if (firstMimetypePair) {
            this.log(this.getName(transformer) + ' ' + this.ms(transformer.getTransformationTime()));
        }
        String i = Integer.toString(mimetypePairCount);
        this.log(this.spaces(5 - i.length()) + mimetypePairCount + ") " + this.getMimetypeExt(sourceMimetype) + this.getMimetypeExt(targetMimetype) + ' ' + this.fileSize(maxSourceSizeKBytes > 0L ? maxSourceSizeKBytes * 1024L : maxSourceSizeKBytes) + (maxSourceSizeKBytes == 0L || explicit != null && explicit == false ? " disabled" : "") + (explicit == null ? "" : (explicit != false ? " EXPLICIT" : " not explicit")));
    }

    public void activeTransformer(String sourceMimetype, String targetMimetype, int transformerCount, ContentTransformer transformer, long maxSourceSizeKBytes, Boolean explicit, boolean firstTransformer) {
        String mimetypes = firstTransformer ? this.getMimetypeExt(sourceMimetype) + this.getMimetypeExt(targetMimetype) : this.spaces(10);
        char c = (char)(97 + transformerCount);
        this.log(mimetypes + "  " + c + ") " + this.getName(transformer) + ' ' + this.ms(transformer.getTransformationTime()) + ' ' + this.fileSize(maxSourceSizeKBytes > 0L ? maxSourceSizeKBytes * 1024L : maxSourceSizeKBytes) + (maxSourceSizeKBytes == 0L || explicit != null && explicit == false ? " disabled" : "") + (explicit == null ? "" : (explicit != false ? " EXPLICIT" : " not explicit")));
    }

    private int getLongestTransformerNameLength(List<ContentTransformer> transformers, Frame frame) {
        int length;
        int longestNameLength = 0;
        for (ContentTransformer trans : transformers) {
            length = this.getName(trans).length();
            if (longestNameLength >= length) continue;
            longestNameLength = length;
        }
        if (frame != null && frame.unavailableTransformers != null) {
            for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                length = unavailable.name.length();
                if (longestNameLength >= length) continue;
                longestNameLength = length;
            }
        }
        return longestNameLength;
    }

    private void logBasicDetails(Frame frame, long sourceSize, String message, boolean firstLevel) {
        if (frame.fromUrl != null && (firstLevel || frame.id != 1)) {
            this.log(frame.fromUrl, false);
        }
        this.log(frame.sourceMimetype + ' ' + frame.targetMimetype, false);
        String fileName = this.getFileName(frame.options, firstLevel, sourceSize);
        this.log(this.getMimetypeExt(frame.sourceMimetype) + this.getMimetypeExt(frame.targetMimetype) + (fileName != null ? fileName + ' ' : "") + (sourceSize >= 0L ? this.fileSize(sourceSize) + ' ' : "") + message);
    }

    public void popAvailable() {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE, false);
        }
    }

    public void popTransform() {
        if (this.isEnabled()) {
            this.pop(Call.TRANSFORM, false);
        }
    }

    public void popMisc() {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE, ThreadInfo.getStack().size() > 1);
        }
    }

    public void popIsTransformableSize() {
        if (this.isEnabled()) {
            ThreadInfo.getIsTransformableStack().pop();
        }
    }

    private void pop(Call callType, boolean suppressFinish) {
        Frame frame;
        Deque<Frame> ourStack = ThreadInfo.getStack();
        if (!ourStack.isEmpty() && ((frame = ourStack.peek()).callType == callType || frame.callType == Call.AVAILABLE_AND_TRANSFORM && callType == Call.AVAILABLE)) {
            boolean firstLevel;
            int size = ourStack.size();
            String ms = this.ms(System.currentTimeMillis() - frame.start);
            this.logInfo(frame, size, ms);
            boolean bl = firstLevel = size == 1;
            if (!suppressFinish && (firstLevel || logger.isTraceEnabled())) {
                this.log("Finished in " + ms + (frame.callType == Call.AVAILABLE ? " Transformer NOT called" : "") + (firstLevel ? "\n" : ""), firstLevel);
            }
            TransformerDebug.setDebugOutput(frame.origDebugOutput);
            ourStack.pop();
        }
    }

    private void logInfo(Frame frame, int size, String ms) {
        if (info.isDebugEnabled()) {
            String failureReason = frame.getFailureReason();
            boolean firstLevel = size == 1;
            String sourceExt = this.getMimetypeExt(frame.sourceMimetype);
            String targetExt = this.getMimetypeExt(frame.targetMimetype);
            String fileName = this.getFileName(frame.options, firstLevel, frame.sourceSize);
            long sourceSize = frame.getSourceSize();
            String transformerName = frame.getTransformerName();
            String level = null;
            boolean debug = false;
            if (NO_TRANSFORMERS.equals(failureReason)) {
                debug = firstLevel;
                level = "INFO";
                failureReason = NO_TRANSFORMERS;
                if (frame.unavailableTransformers != null) {
                    level = "WARN";
                    long smallestMaxSourceSizeKBytes = Long.MAX_VALUE;
                    for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                        if (smallestMaxSourceSizeKBytes <= unavailable.maxSourceSizeKBytes) continue;
                        smallestMaxSourceSizeKBytes = unavailable.maxSourceSizeKBytes;
                    }
                    failureReason = "No transformers as file is > " + this.fileSize(smallestMaxSourceSizeKBytes * 1024L);
                }
            } else if (frame.callType == Call.TRANSFORM) {
                level = failureReason == null || failureReason.length() == 0 ? "INFO" : "ERROR";
                boolean bl = debug = size == 1 || size == 2 && ThreadInfo.getStack().peekLast().callType != Call.TRANSFORM;
            }
            if (level != null) {
                this.infoLog(this.getReference(debug), sourceExt, targetExt, level, fileName, sourceSize, transformerName, failureReason, ms, debug);
            }
        }
    }

    private void infoLog(String reference, String sourceExt, String targetExt, String level, String fileName, long sourceSize, String transformerName, String failureReason, String ms, boolean debug) {
        String message = "  " + reference + sourceExt + targetExt + (level == null ? "" : level + ' ') + (fileName == null ? "" : fileName) + (sourceSize >= 0L ? ' ' + this.fileSize(sourceSize) : "") + (transformerName == null ? "" : ' ' + transformerName) + (failureReason == null ? "" : ' ' + failureReason) + ' ' + ms;
        info.log(message, debug);
    }

    public boolean isEnabled() {
        return logger.isDebugEnabled() || info.isDebugEnabled();
    }

    public static boolean setDebugOutput(boolean debugOutput) {
        return ThreadInfo.setDebugOutput(debugOutput);
    }

    public void debug(String message) {
        if (this.isEnabled() && message != null) {
            this.log(message);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isEnabled()) {
            String msg = t.getMessage();
            int i = msg.indexOf(": \n");
            if (i != -1) {
                msg = msg.substring(0, i);
            }
            this.log(message + ' ' + msg);
            Deque<Frame> ourStack = ThreadInfo.getStack();
            if (!ourStack.isEmpty()) {
                Frame frame = ourStack.peek();
                frame.setFailureReason(message + ' ' + this.getRootCauseMessage(t));
            }
        }
    }

    private String getRootCauseMessage(Throwable t) {
        Throwable cause = t;
        while (cause != null) {
            t = cause;
            cause = t.getCause();
        }
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            message = t.getClass().getSimpleName();
        }
        return message;
    }

    private void log(String message) {
        this.log(message, true);
    }

    private void log(String message, boolean debug) {
        this.log(message, null, debug);
    }

    private void log(String message, Throwable t, boolean debug) {
        if (debug && ThreadInfo.getDebugOutput() && logger.isDebugEnabled()) {
            logger.debug((Object)(this.getReference(false) + message), t);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.getReference(false) + message), t);
        }
    }

    public <T extends Throwable> T setCause(T t) {
        return t;
    }

    private String getReference(boolean firstLevelOnly) {
        StringBuilder sb = new StringBuilder("");
        Frame frame = null;
        Iterator<Frame> iterator = ThreadInfo.getStack().descendingIterator();
        int lengthOfFirstId = 0;
        while (iterator.hasNext()) {
            frame = iterator.next();
            if (sb.length() == 0) {
                sb.append(frame.getId());
                lengthOfFirstId = sb.length();
                if (!firstLevelOnly) continue;
                break;
            }
            sb.append('.');
            sb.append(frame.getId());
        }
        if (frame != null) {
            sb.append(this.spaces(11 - sb.length() + lengthOfFirstId));
        }
        return sb.toString();
    }

    public String getName(ContentTransformer transformer) {
        return (transformer instanceof AbstractContentTransformer2 ? ((AbstractContentTransformerLimits)transformer).getBeanName() : transformer.getClass().getSimpleName()) + (transformer instanceof ComplexContentTransformer ? "<<Complex>>" : (transformer instanceof FailoverContentTransformer ? "<<Failover>>" : (transformer instanceof ProxyContentTransformer ? (((ProxyContentTransformer)transformer).getWorker() instanceof RuntimeExecutableContentTransformerWorker ? "<<Runtime>>" : "<<Proxy>>") : "")));
    }

    public String getFileName(TransformationOptions options, boolean firstLevel, long sourceSize) {
        String fileName = null;
        if (options != null) {
            try {
                NodeRef sourceNodeRef = options.getSourceNodeRef();
                fileName = (String)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_NAME));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (fileName == null) {
            if (!firstLevel) {
                fileName = "<<TemporaryFile>>";
            } else if (sourceSize < 0L) {
                // empty if block
            }
        }
        return fileName;
    }

    private String getMimetypeExt(String mimetype) {
        StringBuilder sb = new StringBuilder("");
        if (this.mimetypeService == null) {
            sb.append(mimetype);
        } else {
            String mimetypeExt = this.mimetypeService.getExtension(mimetype);
            sb.append(mimetypeExt);
            sb.append(this.spaces(4 - mimetypeExt.length()));
        }
        sb.append(' ');
        return sb.toString();
    }

    private String spaces(int i) {
        StringBuilder sb = new StringBuilder("");
        while (--i >= 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public String ms(long time) {
        return String.format("%,d ms", time);
    }

    public String fileSize(long size) {
        if (size < 0L) {
            return "unlimited";
        }
        if (size == 1L) {
            return "1 byte";
        }
        String[] units = new String[]{"bytes", "KB", "MB", "GB", "TB"};
        long divider = 1L;
        for (int i = 0; i < units.length - 1; ++i) {
            long nextDivider = divider * 1024L;
            if (size < nextDivider) {
                return this.fileSizeFormat(size, divider, units[i]);
            }
            divider = nextDivider;
        }
        return this.fileSizeFormat(size, divider, units[units.length - 1]);
    }

    private String fileSizeFormat(long size, long divider, String unit) {
        size = size * 10L / divider;
        int decimalPoint = (int)size % 10;
        StringBuilder sb = new StringBuilder();
        sb.append(size / 10L);
        if (decimalPoint != 0) {
            sb.append(".");
            sb.append(decimalPoint);
        }
        sb.append(' ');
        sb.append(unit);
        return sb.toString();
    }

    private class UnavailableTransformer {
        private final String name;
        private final long maxSourceSizeKBytes;
        private final transient boolean debug;

        UnavailableTransformer(String name, long maxSourceSizeKBytes, boolean debug) {
            this.name = name;
            this.maxSourceSizeKBytes = maxSourceSizeKBytes;
            this.debug = debug;
        }

        public int hashCode() {
            int hashCode = 37 * this.name.hashCode();
            hashCode = (int)((long)hashCode + 37L * this.maxSourceSizeKBytes);
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UnavailableTransformer) {
                UnavailableTransformer that = (UnavailableTransformer)obj;
                return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name) && this.maxSourceSizeKBytes == that.maxSourceSizeKBytes;
            }
            return false;
        }
    }

    private static class Frame {
        private static final AtomicInteger uniqueId = new AtomicInteger(0);
        private int id;
        private final String fromUrl;
        private final String sourceMimetype;
        private final String targetMimetype;
        private final TransformationOptions options;
        private final boolean origDebugOutput;
        private final long start;
        private Call callType;
        private int childId;
        private Set<UnavailableTransformer> unavailableTransformers;
        private String failureReason;
        private long sourceSize;
        private String transformerName;

        private Frame(Frame parent, String transformerName, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, TransformationOptions options, Call pushCall, boolean origDebugOutput) {
            this.id = parent == null ? -1 : (parent.childId = parent.childId + 1);
            this.fromUrl = fromUrl;
            this.transformerName = transformerName;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.sourceSize = sourceSize;
            this.options = options;
            this.callType = pushCall;
            this.origDebugOutput = origDebugOutput;
            this.start = System.currentTimeMillis();
        }

        private int getId() {
            if (this.id == -1) {
                this.id = uniqueId.getAndIncrement();
            }
            return this.id;
        }

        private void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        private String getFailureReason() {
            return this.failureReason;
        }

        private void setSourceSize(long sourceSize) {
            this.sourceSize = sourceSize;
        }

        public long getSourceSize() {
            return this.sourceSize;
        }

        private void setTransformerName(String transformerName) {
            this.transformerName = transformerName;
        }

        public String getTransformerName() {
            return this.transformerName;
        }
    }

    private static class ThreadInfo {
        private static final ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

            @Override
            protected ThreadInfo initialValue() {
                return new ThreadInfo();
            }
        };
        private final Deque<Frame> stack = new ArrayDeque<Frame>();
        private final Deque<String> isTransformableStack = new ArrayDeque<String>();
        private boolean debugOutput = true;

        private ThreadInfo() {
        }

        public static Deque<Frame> getStack() {
            return ThreadInfo.threadInfo.get().stack;
        }

        public static boolean getDebugOutput() {
            return ThreadInfo.threadInfo.get().debugOutput;
        }

        public static Deque<String> getIsTransformableStack() {
            return ThreadInfo.threadInfo.get().isTransformableStack;
        }

        public static boolean setDebugOutput(boolean debugOutput) {
            ThreadInfo thisThreadInfo = threadInfo.get();
            boolean orig = thisThreadInfo.debugOutput;
            thisThreadInfo.debugOutput = debugOutput;
            return orig;
        }
    }

    private static enum Call {
        AVAILABLE,
        TRANSFORM,
        AVAILABLE_AND_TRANSFORM;

    }
}

