/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public interface CopyBehaviourCallback {
    public boolean getMustCopy(QName var1, CopyDetails var2);

    public Pair<AssocCopySourceAction, AssocCopyTargetAction> getAssociationCopyAction(QName var1, CopyDetails var2, CopyAssociationDetails var3);

    public ChildAssocCopyAction getChildAssociationCopyAction(QName var1, CopyDetails var2, CopyChildAssociationDetails var3);

    public ChildAssocRecurseAction getChildAssociationRecurseAction(QName var1, CopyDetails var2, CopyChildAssociationDetails var3);

    public Map<QName, Serializable> getCopyProperties(QName var1, CopyDetails var2, Map<QName, Serializable> var3);

    public static final class CopyChildAssociationDetails {
        private final ChildAssociationRef childAssocRef;
        private final NodeRef copyTarget;
        private final boolean copyTargetIsNew;
        private final boolean copyChildren;

        public CopyChildAssociationDetails(ChildAssociationRef childAssocRef, NodeRef copyTarget, boolean copyTargetIsNew, boolean copyChildren) {
            this.childAssocRef = childAssocRef;
            this.copyTarget = copyTarget;
            this.copyTargetIsNew = copyTargetIsNew;
            this.copyChildren = copyChildren;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append("CopyChildAssociationDetails ").append("[ childAssocRef=").append(this.childAssocRef).append(", copyTarget=").append(this.copyTarget).append(", copyTargetIsNew=").append(this.copyTargetIsNew).append(", copyChildren=").append(this.copyChildren).append("]");
            return sb.toString();
        }

        public final ChildAssociationRef getChildAssocRef() {
            return this.childAssocRef;
        }

        public final NodeRef getCopyTarget() {
            return this.copyTarget;
        }

        public final boolean getCopyTargetIsNew() {
            return this.copyTargetIsNew;
        }

        public final boolean isCopyChildren() {
            return this.copyChildren;
        }
    }

    public static final class CopyAssociationDetails {
        private final AssociationRef assocRef;
        private final NodeRef copyTarget;
        private final boolean copyTargetIsNew;

        public CopyAssociationDetails(AssociationRef assocRef, NodeRef copyTarget, boolean copyTargetIsNew) {
            this.assocRef = assocRef;
            this.copyTarget = copyTarget;
            this.copyTargetIsNew = copyTargetIsNew;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append("CopyChildAssociationDetails ").append("[ assocRef=").append(this.assocRef).append(", copyTarget=").append(this.copyTarget).append(", copyTargetIsNew=").append(this.copyTargetIsNew).append("]");
            return sb.toString();
        }

        public final AssociationRef getAssocRef() {
            return this.assocRef;
        }

        public final NodeRef getCopyTarget() {
            return this.copyTarget;
        }

        public final boolean getCopyTargetIsNew() {
            return this.copyTargetIsNew;
        }
    }

    public static enum ChildAssocRecurseAction implements Comparable<ChildAssocRecurseAction>
    {
        RESPECT_RECURSE_FLAG,
        FORCE_RECURSE;

    }

    public static enum ChildAssocCopyAction implements Comparable<ChildAssocCopyAction>
    {
        IGNORE,
        COPY_ASSOC,
        COPY_CHILD;

    }

    public static enum AssocCopyTargetAction implements Comparable<AssocCopyTargetAction>
    {
        USE_ORIGINAL_TARGET,
        USE_COPIED_TARGET,
        USE_COPIED_OTHERWISE_ORIGINAL_TARGET;

    }

    public static enum AssocCopySourceAction implements Comparable<AssocCopySourceAction>
    {
        COPY,
        COPY_REMOVE_EXISTING,
        IGNORE;

    }
}

