/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.descriptor.DescriptorServiceImpl;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.license.LicenseException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryDescriptorDAOImpl
implements DescriptorDAO {
    private static Log logger = LogFactory.getLog(RepositoryDescriptorDAOImpl.class);
    private String name;
    private NodeService nodeService;
    private ContentService contentService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private ImporterBootstrap systemBootstrap;
    private TransactionService transactionService;

    public void setName(String name) {
        this.name = name;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSystemBootstrap(ImporterBootstrap systemBootstrap) {
        this.systemBootstrap = systemBootstrap;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public Descriptor getDescriptor() {
        RepositoryDescriptor descriptor = null;
        try {
            NodeRef descriptorNodeRef = this.getDescriptorNodeRef(false);
            if (descriptorNodeRef != null) {
                Map properties = this.nodeService.getProperties(descriptorNodeRef);
                descriptor = new RepositoryDescriptor(properties);
            }
        }
        catch (RuntimeException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"getDescriptor: ", (Throwable)e);
            }
            throw e;
        }
        catch (Error e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"getDescriptor: ", (Throwable)e);
            }
            throw e;
        }
        return descriptor;
    }

    @Override
    public Descriptor updateDescriptor(Descriptor serverDescriptor, RepoUsage.LicenseMode licenseMode) {
        RepositoryDescriptor descriptor = null;
        try {
            NodeRef currentDescriptorNodeRef = this.getDescriptorNodeRef(true);
            if (currentDescriptorNodeRef == null) {
                return null;
            }
            if (!this.transactionService.isReadOnly()) {
                HashMap<QName, Object> props = new HashMap<QName, Object>(11);
                props.put(ContentModel.PROP_SYS_NAME, serverDescriptor.getName());
                props.put(ContentModel.PROP_SYS_VERSION_MAJOR, serverDescriptor.getVersionMajor());
                props.put(ContentModel.PROP_SYS_VERSION_MINOR, serverDescriptor.getVersionMinor());
                props.put(ContentModel.PROP_SYS_VERSION_REVISION, serverDescriptor.getVersionRevision());
                props.put(ContentModel.PROP_SYS_VERSION_LABEL, serverDescriptor.getVersionLabel());
                props.put(ContentModel.PROP_SYS_VERSION_BUILD, serverDescriptor.getVersionBuild());
                props.put(ContentModel.PROP_SYS_VERSION_SCHEMA, serverDescriptor.getSchema());
                props.put(ContentModel.PROP_SYS_LICENSE_MODE, (Object)licenseMode);
                this.nodeService.addProperties(currentDescriptorNodeRef, props);
                Serializable value = this.nodeService.getProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_EDITION);
                if (value == null) {
                    this.nodeService.setProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_EDITION, (Serializable)new ContentData(null, null, 0L, null));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updated current repository descriptor properties: \n   node: " + currentDescriptorNodeRef + "\n" + "   descriptor: " + serverDescriptor));
                }
            }
            Map properties = this.nodeService.getProperties(currentDescriptorNodeRef);
            descriptor = new RepositoryDescriptor(properties);
        }
        catch (RuntimeException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"updateDescriptor: ", (Throwable)e);
            }
            throw e;
        }
        catch (Error e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"updateDescriptor: ", (Throwable)e);
            }
            throw e;
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getLicenseKey() {
        byte[] key;
        block19: {
            key = null;
            try {
                ContentReader reader;
                boolean exists;
                NodeRef descriptorRef = this.getDescriptorNodeRef(true);
                if (descriptorRef == null) {
                    throw new LicenseException("Failed to find system descriptor");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getLicenseKey: descriptorRef=" + descriptorRef));
                }
                boolean bl = exists = (reader = this.contentService.getReader(descriptorRef, ContentModel.PROP_SYS_VERSION_EDITION)) != null && reader.exists();
                if (exists) {
                    ByteArrayOutputStream os = null;
                    try {
                        os = new ByteArrayOutputStream();
                        reader.getContent((OutputStream)os);
                        key = os.toByteArray();
                        break block19;
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException ignore) {
                                logger.debug((Object)"getLicenseKey: Error closing ByteArrayOutputStream", (Throwable)ignore);
                            }
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getLicenseKey: reader " + (reader == null ? "is null" : " file does " + (exists ? "" : "NOT ") + "exist")));
                }
            }
            catch (LicenseException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"getLicenseKey: ", (Throwable)e);
                }
                throw new LicenseException("Failed to load license", e);
            }
            catch (Error e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"getLicenseKey: ", (Throwable)e);
                }
                throw e;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getLicenseKey: key " + (key == null ? "is null" : "length=" + key.length)));
        }
        return key;
    }

    @Override
    public void updateLicenseKey(byte[] key) {
        try {
            NodeRef descriptorRef = this.getDescriptorNodeRef(true);
            if (descriptorRef == null) {
                throw new LicenseException("Failed to find system descriptor");
            }
            if (key == null) {
                this.nodeService.setProperty(descriptorRef, ContentModel.PROP_SYS_VERSION_EDITION, null);
            } else {
                ContentWriter writer = this.contentService.getWriter(descriptorRef, ContentModel.PROP_SYS_VERSION_EDITION, true);
                ByteArrayInputStream is = new ByteArrayInputStream(key);
                writer.setMimetype("application/octet-stream");
                writer.putContent((InputStream)is);
            }
        }
        catch (RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getLicenseKey: ", (Throwable)e);
            }
            throw new LicenseException("Failed to save license", e);
        }
        catch (Error e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getLicenseKey: ", (Throwable)e);
            }
            throw e;
        }
    }

    private NodeRef getDescriptorNodeRef(boolean create) {
        NodeRef rootNodeRef;
        StoreRef storeRef = this.systemBootstrap.getStoreRef();
        Properties systemProperties = this.systemBootstrap.getConfiguration();
        String path = systemProperties.getProperty(this.name);
        NodeRef descriptorNodeRef = null;
        String searchPath = "/" + path;
        if (this.nodeService.exists(storeRef)) {
            rootNodeRef = this.nodeService.getRootNode(storeRef);
            List nodeRefs = this.searchService.selectNodes(rootNodeRef, searchPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() == 1) {
                descriptorNodeRef = (NodeRef)nodeRefs.get(0);
            } else if (nodeRefs.size() != 0 && nodeRefs.size() > 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Multiple descriptors: \n   store: " + storeRef + "\n" + "   path: " + searchPath));
                }
                descriptorNodeRef = (NodeRef)nodeRefs.get(0);
            }
        }
        if (descriptorNodeRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Descriptor not found: \n   store: " + storeRef + "\n" + "   path: " + searchPath));
            }
            if (create) {
                storeRef = this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
                rootNodeRef = this.nodeService.getRootNode(storeRef);
                descriptorNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)path, (NamespacePrefixResolver)this.namespaceService), QName.createQName((String)"sys:descriptor", (NamespacePrefixResolver)this.namespaceService)).getChildRef();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created missing descriptor node: " + descriptorNodeRef));
                }
            }
        }
        return descriptorNodeRef;
    }

    private class RepositoryDescriptor
    extends DescriptorServiceImpl.BaseDescriptor {
        private final Map<QName, Serializable> properties;

        private RepositoryDescriptor(Map<QName, Serializable> properties) {
            this.properties = properties;
        }

        @Override
        public String getId() {
            return this.getDescriptor("sys:node-uuid");
        }

        @Override
        public String getName() {
            return this.getDescriptor("sys:name");
        }

        @Override
        public String getVersionMajor() {
            return this.getDescriptor("sys:versionMajor");
        }

        @Override
        public String getVersionMinor() {
            return this.getDescriptor("sys:versionMinor");
        }

        @Override
        public String getVersionRevision() {
            return this.getDescriptor("sys:versionRevision");
        }

        @Override
        public String getVersionLabel() {
            return this.getDescriptor("sys:versionLabel");
        }

        @Override
        public String getVersionBuild() {
            return this.getDescriptor("sys:versionBuild");
        }

        @Override
        public String getEdition() {
            return this.getDescriptor("sys:versionEdition");
        }

        @Override
        public int getSchema() {
            return this.getSchema(this.getDescriptor("sys:versionSchema"));
        }

        @Override
        public String[] getDescriptorKeys() {
            String[] keys = new String[this.properties.size()];
            this.properties.keySet().toArray(keys);
            return keys;
        }

        @Override
        public String getDescriptor(String key) {
            String strValue = null;
            QName qname = QName.createQName((String)key, (NamespacePrefixResolver)RepositoryDescriptorDAOImpl.this.namespaceService);
            Serializable value = this.properties.get(qname);
            if (value != null) {
                if (value instanceof Collection) {
                    Collection coll = (Collection)((Object)value);
                    if (coll.size() > 0) {
                        strValue = coll.iterator().next().toString();
                    }
                } else {
                    strValue = value.toString();
                }
            }
            return strValue;
        }

        @Override
        public RepoUsage.LicenseMode getLicenseMode() {
            String licenseModeStr = this.getDescriptor("sys:licenseMode");
            return licenseModeStr == null ? RepoUsage.LicenseMode.UNKNOWN : RepoUsage.LicenseMode.valueOf(licenseModeStr);
        }
    }
}

