/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrap;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseAlfrescoSpringTest;

public class DictionaryRepositoryBootstrapTest
extends BaseAlfrescoSpringTest {
    public static final String TEMPLATE_MODEL_XML = "<model name={0} xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>{1}</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>      {2}    </imports>   <namespaces>      <namespace uri={3} prefix={4}/>   </namespaces>   <types>      <type name={5}>        <title>Base</title>        <description>The Base Type</description>        <properties>           <property name={6}>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    private BehaviourFilter behaviourFilter;
    private DictionaryRepositoryBootstrap bootstrap;
    private DictionaryDAO dictionaryDAO;
    private TransactionService transactionService;
    private TenantAdminService tenantAdminService;
    private NamespaceService namespaceService;
    private MessageService messageService;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.behaviourFilter = (BehaviourFilter)this.applicationContext.getBean("policyBehaviourFilter");
        this.behaviourFilter.disableBehaviour(ContentModel.TYPE_DICTIONARY_MODEL);
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.tenantAdminService = (TenantAdminService)this.applicationContext.getBean("tenantAdminService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.messageService = (MessageService)this.applicationContext.getBean("messageService");
        this.bootstrap = new DictionaryRepositoryBootstrap();
        this.bootstrap.setContentService(this.contentService);
        this.bootstrap.setDictionaryDAO(this.dictionaryDAO);
        this.bootstrap.setTransactionService(this.transactionService);
        this.bootstrap.setTenantAdminService(this.tenantAdminService);
        this.bootstrap.setNodeService(this.nodeService);
        this.bootstrap.setNamespaceService(this.namespaceService);
        this.bootstrap.setMessageService(this.messageService);
        RepositoryLocation location = new RepositoryLocation();
        location.setStoreProtocol(this.storeRef.getProtocol());
        location.setStoreId(this.storeRef.getIdentifier());
        location.setQueryLanguage("path");
        ArrayList<RepositoryLocation> locations = new ArrayList<RepositoryLocation>();
        locations.add(location);
        this.bootstrap.setRepositoryModelsLocations(locations);
        this.bootstrap.register();
    }

    public void testBootstrap() {
        this.createModelNode("http://www.alfresco.org/model/test2DictionaryBootstrapFromRepo/1.0", "test2", "testModel2", " <import uri=\"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0\" prefix=\"test1\"/> ", "Test model two", "base2", "prop2");
        this.createModelNode("http://www.alfresco.org/model/test3DictionaryBootstrapFromRepo/1.0", "test3", "testModel3", " <import uri=\"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0\" prefix=\"test1\"/> ", "Test model three", "base3", "prop3");
        this.createModelNode("http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0", "test1", "testModel1", "", "Test model one", "base1", "prop1");
        try {
            this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0", (String)"testModel1"));
            DictionaryRepositoryBootstrapTest.fail((String)"The model should not be there.");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        this.bootstrap.init();
        ModelDefinition modelDefinition1 = this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test1DictionaryBootstrapFromRepo/1.0", (String)"testModel1"));
        DictionaryRepositoryBootstrapTest.assertNotNull((Object)modelDefinition1);
        ModelDefinition modelDefinition2 = this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test2DictionaryBootstrapFromRepo/1.0", (String)"testModel2"));
        DictionaryRepositoryBootstrapTest.assertNotNull((Object)modelDefinition2);
        ModelDefinition modelDefinition3 = this.dictionaryDAO.getModel(QName.createQName((String)"http://www.alfresco.org/model/test3DictionaryBootstrapFromRepo/1.0", (String)"testModel3"));
        DictionaryRepositoryBootstrapTest.assertNotNull((Object)modelDefinition3);
    }

    private NodeRef createModelNode(String uri, String prefix, String modelLocalName, String importStatement, String description, String typeName, String propertyName) {
        NodeRef model = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}models"), ContentModel.TYPE_DICTIONARY_MODEL).getChildRef();
        ContentWriter contentWriter1 = this.contentService.getWriter(model, ContentModel.PROP_CONTENT, true);
        contentWriter1.setEncoding("UTF-8");
        contentWriter1.setMimetype("text/xml");
        String modelOne = this.getModelString(uri, prefix, modelLocalName, importStatement, description, typeName, propertyName);
        contentWriter1.putContent(modelOne);
        this.nodeService.setProperty(model, ContentModel.PROP_MODEL_ACTIVE, (Serializable)new Boolean(true));
        return model;
    }

    private String getModelString(String uri, String prefix, String modelLocalName, String importStatement, String description, String typeName, String propertyName) {
        return MessageFormat.format(TEMPLATE_MODEL_XML, "'" + prefix + ":" + modelLocalName + "'", description, importStatement, "'" + uri + "'", "'" + prefix + "'", "'" + prefix + ":" + typeName + "'", "'" + prefix + ":" + propertyName + "'");
    }
}

