/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;

public class TestModel {
    public static void main(String[] args) {
        if (args != null && args.length > 0 && args[0].equals("-h")) {
            System.out.println("TestModel [model filename]*");
            System.exit(1);
        }
        System.out.println("Testing dictionary model definitions...");
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add("org/alfresco/repo/security/authentication/userModel.xml");
        bootstrapModels.add("alfresco/model/contentModel.xml");
        bootstrapModels.add("alfresco/model/wcmModel.xml");
        bootstrapModels.add("alfresco/model/applicationModel.xml");
        bootstrapModels.add("alfresco/model/bpmModel.xml");
        bootstrapModels.add("alfresco/model/wcmAppModel.xml");
        for (String arg : args) {
            bootstrapModels.add(arg);
        }
        for (String model : bootstrapModels) {
            System.out.println(" " + model);
        }
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        namespaceDAO.setTenantService((TenantService)tenantService);
        TestModel.initNamespaceCaches(namespaceDAO);
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl((NamespaceDAO)namespaceDAO);
        dictionaryDAO.setTenantService((TenantService)tenantService);
        TestModel.initDictionaryCaches(dictionaryDAO);
        try {
            DictionaryBootstrap bootstrap = new DictionaryBootstrap();
            bootstrap.setModels(bootstrapModels);
            bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
            bootstrap.bootstrap();
            System.out.println("Models are valid.");
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Found an invalid model...");
            for (Throwable t = e; t != null; t = t.getCause()) {
                System.out.println(t.getMessage());
            }
            System.exit(2);
        }
    }

    private static void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO) {
        DefaultSimpleCache dictionaryCache = new DefaultSimpleCache();
        dictionaryDAO.setDictionaryRegistryCache(dictionaryCache);
    }

    private static void initNamespaceCaches(NamespaceDAOImpl namespaceDAO) {
        DefaultSimpleCache namespaceCache = new DefaultSimpleCache();
        namespaceDAO.setNamespaceRegistryCache(namespaceCache);
    }
}

