/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.discussion;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.discussion.DiscussionServiceImpl;
import org.alfresco.repo.discussion.PostInfoImpl;
import org.alfresco.repo.discussion.TopicInfoImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.discussion.DiscussionService;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.PostWithReplies;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class DiscussionServiceImplTest {
    private static final String TEST_SITE_PREFIX = "DiscussionsSiteTest";
    private static final long ONE_DAY_MS = 86400000L;
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static DictionaryService DICTIONARY_SERVICE;
    private static DiscussionService DISCUSSION_SERVICE;
    private static NodeService NODE_SERVICE;
    private static NodeService PUBLIC_NODE_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static PermissionService PERMISSION_SERVICE;
    private static SiteService SITE_SERVICE;
    private static TaggingService TAGGING_SERVICE;
    private static TenantAdminService TENANT_ADMIN_SERVICE;
    private static final String TENANT_DOMAIN;
    private static final String TEST_USER;
    private static final String ADMIN_USER;
    private static SiteInfo DISCUSSION_SITE;
    private static SiteInfo ALTERNATE_DISCUSSION_SITE;
    private static NodeRef FORUM_NODE;
    private List<NodeRef> testNodesToTidy = new ArrayList<NodeRef>();
    private static List<NodeRef> CLASS_TEST_NODES_TO_TIDY;

    @BeforeClass
    public static void initTestsContext() throws Exception {
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)testContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        DISCUSSION_SERVICE = (DiscussionService)testContext.getBean("DiscussionService");
        DICTIONARY_SERVICE = (DictionaryService)testContext.getBean("dictionaryService");
        NODE_SERVICE = (NodeService)testContext.getBean("nodeService");
        PUBLIC_NODE_SERVICE = (NodeService)testContext.getBean("NodeService");
        PERSON_SERVICE = (PersonService)testContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        PERMISSION_SERVICE = (PermissionService)testContext.getBean("permissionService");
        SITE_SERVICE = (SiteService)testContext.getBean("siteService");
        TAGGING_SERVICE = (TaggingService)testContext.getBean("TaggingService");
        TENANT_ADMIN_SERVICE = (TenantAdminService)testContext.getBean("tenantAdminService", TenantAdminService.class);
        DiscussionServiceImplTest.createTenant();
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        DiscussionServiceImplTest.createUser(TEST_USER);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        DiscussionServiceImplTest.createTestSites();
    }

    @Test
    public void createNewTopic() throws Exception {
        PagingResults<TopicInfo> results = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TopicInfo siteTopic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), "madeUp");
        Assert.assertEquals(null, (Object)siteTopic);
        siteTopic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), "madeUp2");
        Assert.assertEquals(null, (Object)siteTopic);
        siteTopic = DISCUSSION_SERVICE.getTopic(FORUM_NODE, "madeUp");
        Assert.assertEquals(null, (Object)siteTopic);
        siteTopic = DISCUSSION_SERVICE.getTopic(FORUM_NODE, "madeUp2");
        Assert.assertEquals(null, (Object)siteTopic);
        siteTopic = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Site Title");
        Assert.assertNotNull((Object)siteTopic.getNodeRef());
        Assert.assertNotNull((Object)siteTopic.getSystemName());
        NodeRef container = NODE_SERVICE.getPrimaryParent(siteTopic.getNodeRef()).getParentRef();
        NodeRef site = NODE_SERVICE.getPrimaryParent(container).getParentRef();
        Assert.assertEquals((Object)DISCUSSION_SITE.getNodeRef(), (Object)site);
        Assert.assertEquals((Object)"Site Title", (Object)siteTopic.getTitle());
        Assert.assertEquals((Object)ADMIN_USER, (Object)siteTopic.getCreator());
        Assert.assertEquals((long)0L, (long)siteTopic.getTags().size());
        siteTopic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), siteTopic.getSystemName());
        Assert.assertEquals((Object)"Site Title", (Object)siteTopic.getTitle());
        Assert.assertEquals((Object)ADMIN_USER, (Object)siteTopic.getCreator());
        Assert.assertEquals((long)0L, (long)siteTopic.getTags().size());
        TopicInfo nodeTopic = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "Node Title");
        Assert.assertNotNull((Object)nodeTopic.getNodeRef());
        Assert.assertNotNull((Object)nodeTopic.getSystemName());
        Assert.assertEquals((Object)FORUM_NODE, (Object)NODE_SERVICE.getPrimaryParent(nodeTopic.getNodeRef()).getParentRef());
        Assert.assertEquals((Object)"Node Title", (Object)nodeTopic.getTitle());
        Assert.assertEquals((Object)ADMIN_USER, (Object)nodeTopic.getCreator());
        Assert.assertEquals((long)0L, (long)siteTopic.getTags().size());
        nodeTopic = DISCUSSION_SERVICE.getTopic(FORUM_NODE, nodeTopic.getSystemName());
        Assert.assertEquals((Object)"Node Title", (Object)nodeTopic.getTitle());
        Assert.assertEquals((Object)ADMIN_USER, (Object)nodeTopic.getCreator());
        Assert.assertEquals((long)0L, (long)siteTopic.getTags().size());
        this.testNodesToTidy.add(siteTopic.getNodeRef());
        this.testNodesToTidy.add(nodeTopic.getNodeRef());
    }

    @Test
    public void createNewTopicAndPostAndReply() throws Exception {
        PagingResults<TopicInfo> results = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TopicInfo siteTopic = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Site Title");
        TopicInfo nodeTopic = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "Node Title");
        this.testNodesToTidy.add(siteTopic.getNodeRef());
        this.testNodesToTidy.add(nodeTopic.getNodeRef());
        for (TopicInfo topic : new TopicInfo[]{siteTopic, nodeTopic}) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
            PagingResults<PostInfo> posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)0L, (long)posts.getPage().size());
            Assert.assertEquals(null, (Object)DISCUSSION_SERVICE.getPrimaryPost(topic));
            Assert.assertEquals(null, (Object)DISCUSSION_SERVICE.getMostRecentPost(topic));
            PostInfo post = DISCUSSION_SERVICE.getPost(topic, "madeUp");
            Assert.assertEquals(null, (Object)post);
            post = DISCUSSION_SERVICE.getPost(topic, "madeUp2");
            Assert.assertEquals(null, (Object)post);
            String contents = "This Is Some Content";
            post = DISCUSSION_SERVICE.createPost(topic, contents);
            Assert.assertNotNull((Object)post.getNodeRef());
            Assert.assertNotNull((Object)post.getSystemName());
            Assert.assertEquals((Object)topic, (Object)post.getTopic());
            Assert.assertEquals((Object)topic.getSystemName(), (Object)post.getSystemName());
            Assert.assertEquals((Object)topic.getTitle(), (Object)post.getTitle());
            Assert.assertEquals((Object)contents, (Object)post.getContents());
            Assert.assertEquals((Object)ADMIN_USER, (Object)post.getCreator());
            post = DISCUSSION_SERVICE.getPost(topic, post.getSystemName());
            Assert.assertNotNull((Object)post.getNodeRef());
            Assert.assertNotNull((Object)post.getSystemName());
            Assert.assertEquals((Object)topic, (Object)post.getTopic());
            Assert.assertEquals((Object)topic.getTitle(), (Object)post.getTitle());
            Assert.assertEquals((Object)contents, (Object)post.getContents());
            Assert.assertEquals((Object)ADMIN_USER, (Object)post.getCreator());
            Assert.assertNotNull((Object)DISCUSSION_SERVICE.getPrimaryPost(topic));
            Assert.assertEquals((Object)post.getNodeRef(), (Object)DISCUSSION_SERVICE.getPrimaryPost(topic).getNodeRef());
            Assert.assertNotNull((Object)DISCUSSION_SERVICE.getMostRecentPost(topic));
            Assert.assertEquals((Object)post.getNodeRef(), (Object)DISCUSSION_SERVICE.getMostRecentPost(topic).getNodeRef());
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)1L, (long)posts.getPage().size());
            String reply1Contents = "Reply Contents";
            PostInfo reply1 = DISCUSSION_SERVICE.createReply(post, reply1Contents);
            Assert.assertNotNull((Object)reply1.getNodeRef());
            Assert.assertNotNull((Object)reply1.getSystemName());
            Assert.assertEquals((Object)topic, (Object)reply1.getTopic());
            Assert.assertEquals(null, (Object)reply1.getTitle());
            Assert.assertEquals((Object)reply1Contents, (Object)reply1.getContents());
            Assert.assertEquals((Object)ADMIN_USER, (Object)reply1.getCreator());
            reply1 = DISCUSSION_SERVICE.getPost(topic, reply1.getSystemName());
            Assert.assertNotNull((Object)reply1.getNodeRef());
            Assert.assertNotNull((Object)reply1.getSystemName());
            Assert.assertEquals((Object)topic, (Object)reply1.getTopic());
            Assert.assertEquals(null, (Object)reply1.getTitle());
            Assert.assertEquals((Object)reply1Contents, (Object)reply1.getContents());
            Assert.assertEquals((Object)ADMIN_USER, (Object)reply1.getCreator());
            AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
            String reply2Contents = "2Reply 2Contents";
            PostInfo reply2 = DISCUSSION_SERVICE.createReply(post, reply2Contents);
            Assert.assertNotNull((Object)reply2.getNodeRef());
            Assert.assertNotNull((Object)reply2.getSystemName());
            Assert.assertEquals((Object)topic, (Object)reply2.getTopic());
            Assert.assertEquals(null, (Object)reply2.getTitle());
            Assert.assertEquals((Object)reply2Contents, (Object)reply2.getContents());
            Assert.assertEquals((Object)TEST_USER, (Object)reply2.getCreator());
            reply2 = DISCUSSION_SERVICE.getPost(topic, reply2.getSystemName());
            Assert.assertNotNull((Object)reply2.getNodeRef());
            Assert.assertNotNull((Object)reply2.getSystemName());
            Assert.assertEquals((Object)topic, (Object)reply2.getTopic());
            Assert.assertEquals(null, (Object)reply2.getTitle());
            Assert.assertEquals((Object)reply2Contents, (Object)reply2.getContents());
            Assert.assertEquals((Object)TEST_USER, (Object)reply2.getCreator());
            Pair<TopicInfo, PostInfo> objects = DISCUSSION_SERVICE.getForNodeRef(FORUM_NODE);
            Assert.assertEquals(null, objects);
            objects = DISCUSSION_SERVICE.getForNodeRef(topic.getNodeRef());
            Assert.assertNotNull(objects);
            Assert.assertEquals((Object)topic.getNodeRef(), (Object)((TopicInfo)objects.getFirst()).getNodeRef());
            Assert.assertEquals(null, (Object)objects.getSecond());
            objects = DISCUSSION_SERVICE.getForNodeRef(post.getNodeRef());
            Assert.assertNotNull(objects);
            Assert.assertEquals((Object)topic.getNodeRef(), (Object)((TopicInfo)objects.getFirst()).getNodeRef());
            Assert.assertEquals((Object)post.getNodeRef(), (Object)((PostInfo)objects.getSecond()).getNodeRef());
            objects = DISCUSSION_SERVICE.getForNodeRef(reply1.getNodeRef());
            Assert.assertNotNull(objects);
            Assert.assertEquals((Object)topic.getNodeRef(), (Object)((TopicInfo)objects.getFirst()).getNodeRef());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)((PostInfo)objects.getSecond()).getNodeRef());
            Assert.assertNotNull((Object)DISCUSSION_SERVICE.getPrimaryPost(topic));
            Assert.assertEquals((Object)post.getNodeRef(), (Object)DISCUSSION_SERVICE.getPrimaryPost(topic).getNodeRef());
            Assert.assertNotNull((Object)DISCUSSION_SERVICE.getMostRecentPost(topic));
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)DISCUSSION_SERVICE.getMostRecentPost(topic).getNodeRef());
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)3L, (long)posts.getPage().size());
        }
    }

    @Test
    public void createUpdateDeleteEntries() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        TopicInfo siteTopic = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Site Title");
        TopicInfo nodeTopic = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "Node Title");
        this.testNodesToTidy.add(siteTopic.getNodeRef());
        this.testNodesToTidy.add(nodeTopic.getNodeRef());
        TopicInfo siteTopic2 = (TopicInfo)DISCUSSION_SERVICE.getForNodeRef(siteTopic.getNodeRef()).getFirst();
        Assert.assertEquals((Object)"Site Title", (Object)siteTopic.getTitle());
        Assert.assertEquals((Object)TEST_USER, (Object)siteTopic.getCreator());
        Assert.assertEquals((long)0L, (long)siteTopic.getTags().size());
        Assert.assertEquals((Object)"Node Title", (Object)nodeTopic.getTitle());
        Assert.assertEquals((Object)TEST_USER, (Object)nodeTopic.getCreator());
        Assert.assertEquals((long)0L, (long)nodeTopic.getTags().size());
        Assert.assertEquals((Object)siteTopic, (Object)siteTopic2);
        Assert.assertNotSame((Object)siteTopic, (Object)siteTopic2);
        siteTopic.setTitle("Site Changed");
        nodeTopic.setTitle("Node Changed");
        siteTopic = DISCUSSION_SERVICE.updateTopic(siteTopic);
        nodeTopic = DISCUSSION_SERVICE.updateTopic(nodeTopic);
        siteTopic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), siteTopic.getSystemName());
        nodeTopic = DISCUSSION_SERVICE.getTopic(FORUM_NODE, nodeTopic.getSystemName());
        Assert.assertEquals((Object)"Site Changed", (Object)siteTopic.getTitle());
        Assert.assertEquals((Object)TEST_USER, (Object)siteTopic.getCreator());
        Assert.assertEquals((long)0L, (long)siteTopic.getTags().size());
        Assert.assertEquals((Object)"Node Changed", (Object)nodeTopic.getTitle());
        Assert.assertEquals((Object)TEST_USER, (Object)nodeTopic.getCreator());
        Assert.assertEquals((long)0L, (long)nodeTopic.getTags().size());
        for (TopicInfo topic : new TopicInfo[]{siteTopic, nodeTopic}) {
            String contents = "This Is Some Content";
            PostInfo post = DISCUSSION_SERVICE.createPost(topic, contents);
            String replyContents = "Reply Contents";
            PostInfo reply = DISCUSSION_SERVICE.createReply(post, replyContents);
            Assert.assertEquals((Object)topic.getTitle(), (Object)post.getTitle());
            Assert.assertEquals((Object)contents, (Object)post.getContents());
            Assert.assertEquals(null, (Object)post.getUpdatedAt());
            Assert.assertEquals(null, (Object)reply.getTitle());
            Assert.assertEquals((Object)replyContents, (Object)reply.getContents());
            Assert.assertEquals(null, (Object)reply.getUpdatedAt());
            post = DISCUSSION_SERVICE.getPost(topic, post.getSystemName());
            reply = DISCUSSION_SERVICE.getPost(topic, reply.getSystemName());
            Assert.assertEquals((Object)topic.getTitle(), (Object)post.getTitle());
            Assert.assertEquals((Object)contents, (Object)post.getContents());
            Assert.assertEquals(null, (Object)post.getUpdatedAt());
            Assert.assertEquals(null, (Object)reply.getTitle());
            Assert.assertEquals((Object)replyContents, (Object)reply.getContents());
            Assert.assertEquals(null, (Object)reply.getUpdatedAt());
            String pTitle = "Title on the Post";
            String rTitle = "Title on the Reply";
            String pContents = "Changed! Changed!";
            String rContents = "Reply was changed...";
            post.setTitle(pTitle);
            post.setContents(pContents);
            reply.setTitle(rTitle);
            reply.setContents(rContents);
            post = DISCUSSION_SERVICE.updatePost(post);
            reply = DISCUSSION_SERVICE.updatePost(reply);
            Assert.assertEquals((Object)pTitle, (Object)post.getTitle());
            Assert.assertEquals((Object)pContents, (Object)post.getContents());
            Assert.assertEquals((Object)rTitle, (Object)reply.getTitle());
            Assert.assertEquals((Object)rContents, (Object)reply.getContents());
            Assert.assertNotNull((Object)post.getUpdatedAt());
            Assert.assertNotNull((Object)post.getModifiedAt());
            Assert.assertNotNull((Object)reply.getUpdatedAt());
            Assert.assertNotNull((Object)reply.getModifiedAt());
            post = DISCUSSION_SERVICE.getPost(topic, post.getSystemName());
            reply = DISCUSSION_SERVICE.getPost(topic, reply.getSystemName());
            Assert.assertEquals((Object)pTitle, (Object)post.getTitle());
            Assert.assertEquals((Object)pContents, (Object)post.getContents());
            Assert.assertEquals((Object)rTitle, (Object)reply.getTitle());
            Assert.assertEquals((Object)rContents, (Object)reply.getContents());
            Assert.assertNotNull((Object)post.getUpdatedAt());
            Assert.assertNotNull((Object)post.getModifiedAt());
            Assert.assertNotNull((Object)reply.getUpdatedAt());
            Assert.assertNotNull((Object)reply.getModifiedAt());
            String oldTitle = topic.getTitle();
            PUBLIC_NODE_SERVICE.setProperty(topic.getNodeRef(), ContentModel.PROP_TITLE, null);
            Assert.assertEquals((Object)oldTitle, (Object)topic.getTitle());
            topic = DISCUSSION_SERVICE.getTopic(topic.getContainerNodeRef(), topic.getSystemName());
            Assert.assertEquals((Object)pTitle, (Object)topic.getTitle());
            DISCUSSION_SERVICE.deletePost(reply);
            DISCUSSION_SERVICE.deletePost(post);
            post = DISCUSSION_SERVICE.getPost(topic, post.getSystemName());
            reply = DISCUSSION_SERVICE.getPost(topic, reply.getSystemName());
            Assert.assertEquals(null, (Object)post);
            Assert.assertEquals(null, (Object)reply);
        }
        DISCUSSION_SERVICE.deleteTopic(siteTopic);
        DISCUSSION_SERVICE.deleteTopic(nodeTopic);
        siteTopic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), siteTopic.getSystemName());
        nodeTopic = DISCUSSION_SERVICE.getTopic(FORUM_NODE, nodeTopic.getSystemName());
        Assert.assertEquals(null, (Object)siteTopic);
        Assert.assertEquals(null, (Object)nodeTopic);
    }

    @Test
    public void basicListings() throws Exception {
        String TAG_1 = "topic_tag_one";
        String TAG_2 = "topic_tag_two";
        PagingResults<TopicInfo> topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        TopicInfo siteT1 = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "ST1");
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        TopicInfo siteT2 = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "ST2");
        TopicInfo nodeT1 = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "NT1");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        TopicInfo nodeT2 = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "NT2");
        TopicInfo nodeT3 = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "NT3");
        this.testNodesToTidy.add(siteT1.getNodeRef());
        this.testNodesToTidy.add(siteT2.getNodeRef());
        this.testNodesToTidy.add(nodeT1.getNodeRef());
        this.testNodesToTidy.add(nodeT2.getNodeRef());
        this.testNodesToTidy.add(nodeT3.getNodeRef());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(2)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), false, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, false, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(2)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), ADMIN_USER, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, ADMIN_USER, true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), TEST_USER, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, TEST_USER, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), ADMIN_USER, false, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, ADMIN_USER, false, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), TEST_USER, false, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, TEST_USER, false, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Date now = new Date();
        Date yesterday = new Date(now.getTime() - 86400000L - 60000L);
        Date tomorrow = new Date(now.getTime() + 86400000L);
        Date future = new Date(now.getTime() + 864000000L);
        Date fourDaysAgo = new Date(now.getTime() - 345600000L);
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), yesterday, tomorrow, true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, yesterday, tomorrow, true, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(2)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, yesterday, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, fourDaysAgo, yesterday, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), tomorrow, future, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, tomorrow, future, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), yesterday, tomorrow, false, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, yesterday, tomorrow, false, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(2)).getTitle());
        siteT2.getTags().add("topic_tag_one");
        nodeT2.getTags().add("topic_tag_one");
        nodeT2.getTags().add("topic_tag_two");
        nodeT3.getTags().add("topic_tag_one");
        DISCUSSION_SERVICE.updateTopic(siteT2);
        DISCUSSION_SERVICE.updateTopic(nodeT2);
        DISCUSSION_SERVICE.updateTopic(nodeT3);
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), null, null, true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, null, null, true, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(2)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), null, "topic_tag_one", true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, null, "topic_tag_one", true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), null, "topic_tag_two", true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, null, "topic_tag_two", true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), ADMIN_USER, null, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, ADMIN_USER, null, true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), TEST_USER, null, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, TEST_USER, null, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), ADMIN_USER, "topic_tag_one", true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.findTopics(DISCUSSION_SITE.getShortName(), TEST_USER, "topic_tag_one", true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, ADMIN_USER, "topic_tag_two", true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, TEST_USER, "topic_tag_two", true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, ADMIN_USER, null, true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.findTopics(FORUM_NODE, ADMIN_USER, null, false, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        this.pushAuditableDatesBack(siteT2, 2, 2);
        this.pushAuditableDatesBack(nodeT3, 3, 3);
        this.pushAuditableDatesBack(nodeT1, 1, 1);
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(2)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), yesterday, tomorrow, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, yesterday, tomorrow, true, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT1", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"NT2", (Object)((TopicInfo)topics.getPage().get(1)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, yesterday, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"ST2", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, fourDaysAgo, yesterday, true, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)"NT3", (Object)((TopicInfo)topics.getPage().get(0)).getTitle());
        PostInfo siteCP1 = DISCUSSION_SERVICE.createPost(siteT2, "Check");
        PostInfo nodeCP1 = DISCUSSION_SERVICE.createPost(nodeT2, "Check");
        this.testNodesToTidy.add(siteCP1.getNodeRef());
        this.testNodesToTidy.add(nodeCP1.getNodeRef());
        for (TopicInfo topic : new TopicInfo[]{siteT1, nodeT1}) {
            PagingResults<PostInfo> posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)0L, (long)posts.getPage().size());
            PostInfo post = DISCUSSION_SERVICE.createPost(topic, "Post");
            Assert.assertEquals((Object)post.getNodeRef(), (Object)DISCUSSION_SERVICE.getPrimaryPost(topic).getNodeRef());
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)1L, (long)posts.getPage().size());
            Assert.assertEquals((Object)"Post", (Object)((PostInfo)posts.getPage().get(0)).getContents());
            PostInfo reply1 = DISCUSSION_SERVICE.createReply(post, "R1");
            PostInfo reply2 = DISCUSSION_SERVICE.createReply(post, "R2");
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)3L, (long)posts.getPage().size());
            Assert.assertEquals((Object)"Post", (Object)((PostInfo)posts.getPage().get(0)).getContents());
            Assert.assertEquals((Object)"R1", (Object)((PostInfo)posts.getPage().get(1)).getContents());
            Assert.assertEquals((Object)"R2", (Object)((PostInfo)posts.getPage().get(2)).getContents());
            this.pushAuditableDatesBack(reply1, -1, -1);
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)3L, (long)posts.getPage().size());
            Assert.assertEquals((Object)"Post", (Object)((PostInfo)posts.getPage().get(0)).getContents());
            Assert.assertEquals((Object)"R2", (Object)((PostInfo)posts.getPage().get(1)).getContents());
            Assert.assertEquals((Object)"R1", (Object)((PostInfo)posts.getPage().get(2)).getContents());
            DISCUSSION_SERVICE.deletePost(reply1);
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)2L, (long)posts.getPage().size());
            Assert.assertEquals((Object)"Post", (Object)((PostInfo)posts.getPage().get(0)).getContents());
            Assert.assertEquals((Object)"R2", (Object)((PostInfo)posts.getPage().get(1)).getContents());
            DISCUSSION_SERVICE.deletePost(post);
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)1L, (long)posts.getPage().size());
            Assert.assertEquals((Object)"R2", (Object)((PostInfo)posts.getPage().get(0)).getContents());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)DISCUSSION_SERVICE.getPrimaryPost(topic).getNodeRef());
            DISCUSSION_SERVICE.deletePost(reply2);
            posts = DISCUSSION_SERVICE.listPosts(topic, new PagingRequest(10));
            Assert.assertEquals((long)0L, (long)posts.getPage().size());
        }
    }

    @Test
    public void replyListing() throws Exception {
        TopicInfo siteT1 = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "ST1");
        TopicInfo nodeT1 = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "NT1");
        this.testNodesToTidy.add(siteT1.getNodeRef());
        this.testNodesToTidy.add(nodeT1.getNodeRef());
        for (TopicInfo topic : new TopicInfo[]{siteT1, nodeT1}) {
            PostWithReplies pr = DISCUSSION_SERVICE.listPostReplies(topic, 1);
            Assert.assertEquals(null, (Object)pr);
            PostInfo post = DISCUSSION_SERVICE.createPost(topic, "Post");
            this.testNodesToTidy.add(post.getNodeRef());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 1);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().size());
            PostInfo reply1 = DISCUSSION_SERVICE.createReply(post, "R1");
            PostInfo reply2 = DISCUSSION_SERVICE.createReply(post, "R2");
            this.testNodesToTidy.add(reply1.getNodeRef());
            this.testNodesToTidy.add(reply2.getNodeRef());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 1);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 0);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 5);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            PostInfo reply1_1 = DISCUSSION_SERVICE.createReply(reply1, "R1_1");
            PostInfo reply1_2 = DISCUSSION_SERVICE.createReply(reply1, "R1_2");
            PostInfo reply1_3 = DISCUSSION_SERVICE.createReply(reply1, "R1_3");
            PostInfo reply1_2_1 = DISCUSSION_SERVICE.createReply(reply1_2, "R1_2_1");
            PostInfo reply1_2_2 = DISCUSSION_SERVICE.createReply(reply1_2, "R1_2_2");
            PostInfo reply1_3_1 = DISCUSSION_SERVICE.createReply(reply1_3, "R1_3_1");
            PostInfo reply1_3_1_1 = DISCUSSION_SERVICE.createReply(reply1_3_1, "R1_3_1_1");
            PostInfo reply1_3_1_1_1 = DISCUSSION_SERVICE.createReply(reply1_3_1_1, "R1_3_1_1_1");
            this.testNodesToTidy.add(reply1_1.getNodeRef());
            this.testNodesToTidy.add(reply1_2.getNodeRef());
            this.testNodesToTidy.add(reply1_3.getNodeRef());
            this.testNodesToTidy.add(reply1_2_1.getNodeRef());
            this.testNodesToTidy.add(reply1_2_2.getNodeRef());
            this.testNodesToTidy.add(reply1_3_1.getNodeRef());
            this.testNodesToTidy.add(reply1_3_1_1.getNodeRef());
            this.testNodesToTidy.add(reply1_3_1_1_1.getNodeRef());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 0);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 1);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(post, 1);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 2);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)3L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            Assert.assertEquals((Object)reply1_1.getNodeRef(), (Object)pr.getReplies().get(0).getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply1_2.getNodeRef(), (Object)pr.getReplies().get(0).getReplies().get(1).getNodeRef());
            Assert.assertEquals((Object)reply1_3.getNodeRef(), (Object)pr.getReplies().get(0).getReplies().get(2).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().get(1).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().get(2).getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 3);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)3L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            PostWithReplies pr1 = pr.getReplies().get(0);
            Assert.assertEquals((Object)reply1_1.getNodeRef(), (Object)pr1.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply1_2.getNodeRef(), (Object)pr1.getReplies().get(1).getNodeRef());
            Assert.assertEquals((Object)reply1_3.getNodeRef(), (Object)pr1.getReplies().get(2).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr1.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)2L, (long)pr1.getReplies().get(1).getReplies().size());
            Assert.assertEquals((long)1L, (long)pr1.getReplies().get(2).getReplies().size());
            Assert.assertEquals((Object)reply1_2_1.getNodeRef(), (Object)pr1.getReplies().get(1).getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply1_2_2.getNodeRef(), (Object)pr1.getReplies().get(1).getReplies().get(1).getNodeRef());
            Assert.assertEquals((Object)reply1_3_1.getNodeRef(), (Object)pr1.getReplies().get(2).getReplies().get(0).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr1.getReplies().get(1).getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr1.getReplies().get(2).getReplies().get(0).getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(topic, 10);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)post.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)2L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getReplies().get(1).getNodeRef());
            Assert.assertEquals((long)3L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(1).getReplies().size());
            pr1 = pr.getReplies().get(0);
            Assert.assertEquals((Object)reply1_1.getNodeRef(), (Object)pr1.getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply1_2.getNodeRef(), (Object)pr1.getReplies().get(1).getNodeRef());
            Assert.assertEquals((Object)reply1_3.getNodeRef(), (Object)pr1.getReplies().get(2).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr1.getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)2L, (long)pr1.getReplies().get(1).getReplies().size());
            Assert.assertEquals((long)1L, (long)pr1.getReplies().get(2).getReplies().size());
            Assert.assertEquals((Object)reply1_2_1.getNodeRef(), (Object)pr1.getReplies().get(1).getReplies().get(0).getNodeRef());
            Assert.assertEquals((Object)reply1_2_2.getNodeRef(), (Object)pr1.getReplies().get(1).getReplies().get(1).getNodeRef());
            Assert.assertEquals((Object)reply1_3_1.getNodeRef(), (Object)pr1.getReplies().get(2).getReplies().get(0).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr1.getReplies().get(1).getReplies().get(0).getReplies().size());
            Assert.assertEquals((long)1L, (long)pr1.getReplies().get(2).getReplies().get(0).getReplies().size());
            PostWithReplies rp1_3_1 = pr1.getReplies().get(2).getReplies().get(0);
            Assert.assertEquals((Object)reply1_3_1.getNodeRef(), (Object)rp1_3_1.getNodeRef());
            Assert.assertEquals((long)1L, (long)rp1_3_1.getReplies().size());
            Assert.assertEquals((Object)reply1_3_1_1.getNodeRef(), (Object)rp1_3_1.getReplies().get(0).getNodeRef());
            Assert.assertEquals((long)1L, (long)rp1_3_1.getReplies().get(0).getReplies().size());
            Assert.assertEquals((Object)reply1_3_1_1_1.getNodeRef(), (Object)rp1_3_1.getReplies().get(0).getReplies().get(0).getNodeRef());
            Assert.assertEquals((long)0L, (long)rp1_3_1.getReplies().get(0).getReplies().get(0).getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(reply2, 10);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)reply2.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().size());
            pr = DISCUSSION_SERVICE.listPostReplies(reply1_3_1, 10);
            Assert.assertNotNull((Object)pr);
            Assert.assertEquals((Object)reply1_3_1.getNodeRef(), (Object)pr.getNodeRef());
            Assert.assertEquals((long)1L, (long)pr.getReplies().size());
            Assert.assertEquals((Object)reply1_3_1_1.getNodeRef(), (Object)pr.getReplies().get(0).getNodeRef());
            Assert.assertEquals((long)1L, (long)pr.getReplies().get(0).getReplies().size());
            Assert.assertEquals((Object)reply1_3_1_1_1.getNodeRef(), (Object)pr.getReplies().get(0).getReplies().get(0).getNodeRef());
            Assert.assertEquals((long)0L, (long)pr.getReplies().get(0).getReplies().get(0).getReplies().size());
        }
    }

    @Test
    public void newContainerSetup() throws Exception {
        String TEST_SITE_NAME = "DiscussionsTestNewTestSite";
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (SITE_SERVICE.getSite("DiscussionsTestNewTestSite") != null) {
                    SITE_SERVICE.deleteSite("DiscussionsTestNewTestSite");
                }
                SITE_SERVICE.createSite(DiscussionServiceImplTest.TEST_SITE_PREFIX, "DiscussionsTestNewTestSite", "Test", "Test", SiteVisibility.PUBLIC);
                Assert.assertFalse((boolean)SITE_SERVICE.hasContainer("DiscussionsTestNewTestSite", "discussions"));
                DISCUSSION_SERVICE.createTopic("DiscussionsTestNewTestSite", "Title");
                Assert.assertTrue((boolean)SITE_SERVICE.hasContainer("DiscussionsTestNewTestSite", "discussions"));
                NodeRef container = SITE_SERVICE.getContainer("DiscussionsTestNewTestSite", "discussions");
                Assert.assertTrue((boolean)TAGGING_SERVICE.isTagScope(container));
                SITE_SERVICE.deleteSite("DiscussionsTestNewTestSite");
                return null;
            }
        });
    }

    @Test
    public void tagging() throws Exception {
        String TAG_1 = "link_tag_1";
        String TAG_2 = "link_tag_2";
        String TAG_3 = "link_tag_3";
        TopicInfo topic = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Title");
        this.testNodesToTidy.add(topic.getNodeRef());
        Assert.assertEquals((long)0L, (long)topic.getTags().size());
        topic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), topic.getSystemName());
        Assert.assertEquals((long)0L, (long)topic.getTags().size());
        topic.getTags().add("link_tag_1");
        topic.getTags().add("link_tag_2");
        topic.getTags().add("link_tag_1");
        Assert.assertEquals((long)3L, (long)topic.getTags().size());
        DISCUSSION_SERVICE.updateTopic(topic);
        topic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), topic.getSystemName());
        Assert.assertEquals((long)2L, (long)topic.getTags().size());
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)false, (Object)topic.getTags().contains("link_tag_3"));
        topic.getTags().remove("link_tag_2");
        topic.getTags().add("link_tag_3");
        topic.getTags().add("link_tag_1");
        DISCUSSION_SERVICE.updateTopic(topic);
        Assert.assertEquals((long)3L, (long)topic.getTags().size());
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)false, (Object)topic.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_3"));
        topic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), topic.getSystemName());
        Assert.assertEquals((long)2L, (long)topic.getTags().size());
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)false, (Object)topic.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_3"));
        topic.getTags().clear();
        DISCUSSION_SERVICE.updateTopic(topic);
        topic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), topic.getSystemName());
        Assert.assertEquals((long)0L, (long)topic.getTags().size());
        topic.getTags().add("link_tag_1");
        topic.getTags().add("link_tag_2");
        topic.getTags().add("link_tag_3");
        DISCUSSION_SERVICE.updateTopic(topic);
        topic = DISCUSSION_SERVICE.getTopic(DISCUSSION_SITE.getShortName(), topic.getSystemName());
        Assert.assertEquals((long)3L, (long)topic.getTags().size());
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)topic.getTags().contains("link_tag_3"));
        DISCUSSION_SERVICE.deleteTopic(topic);
    }

    @Test
    public void discussionsHotTopicsListing() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        Date now = new Date();
        Date yesterday = new Date(now.getTime() - 86400000L - 60000L);
        Date tomorrow = new Date(now.getTime() + 86400000L);
        Date future = new Date(now.getTime() + 864000000L);
        Date fourDaysAgo = new Date(now.getTime() - 345600000L);
        PagingResults<Pair<TopicInfo, Integer>> topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        TopicInfo topicSA = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Title1A");
        TopicInfo topicSB = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Title1B");
        this.testNodesToTidy.add(topicSA.getNodeRef());
        this.testNodesToTidy.add(topicSB.getNodeRef());
        TopicInfo topicNA = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "TitleNA");
        TopicInfo topicNB = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "TitleNB");
        this.testNodesToTidy.add(topicNA.getNodeRef());
        this.testNodesToTidy.add(topicNB.getNodeRef());
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        PostInfo postSA = DISCUSSION_SERVICE.createPost(topicSA, "Test S Post");
        PostInfo postSB = DISCUSSION_SERVICE.createPost(topicSB, "Test S Post");
        PostInfo postNA = DISCUSSION_SERVICE.createPost(topicNA, "Test N Post");
        PostInfo postNB = DISCUSSION_SERVICE.createPost(topicNB, "Test N Post");
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        PostInfo replySA1 = DISCUSSION_SERVICE.createReply(postSA, "Reply SA 1");
        PostInfo replySB1 = DISCUSSION_SERVICE.createReply(postSB, "Reply SB 1");
        PostInfo replySB2 = DISCUSSION_SERVICE.createReply(postSB, "Reply SB 2");
        PostInfo replySB3 = DISCUSSION_SERVICE.createReply(postSB, "Reply SB 3");
        PostInfo replyNA1 = DISCUSSION_SERVICE.createReply(postNA, "Reply NA 1");
        PostInfo replyNB1 = DISCUSSION_SERVICE.createReply(postNB, "Reply NB 1");
        PostInfo replyNB2 = DISCUSSION_SERVICE.createReply(postNB, "Reply NB 2");
        PostInfo replyNB3 = DISCUSSION_SERVICE.createReply(postNB, "Reply NB 3");
        PostInfo replyNB4 = DISCUSSION_SERVICE.createReply(postNB, "Reply NB 4");
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)3L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)4L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        PostInfo replySA1_1 = DISCUSSION_SERVICE.createReply(replySA1, "Reply to a reply");
        PostInfo replyNA1_1 = DISCUSSION_SERVICE.createReply(replyNA1, "Reply to a reply");
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)3L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)2L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)4L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)2L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        this.pushAuditableDatesBack(topicSA, 11, 1);
        this.pushAuditableDatesBack(topicSB, 12, 2);
        this.pushAuditableDatesBack(topicNA, 13, 3);
        this.pushAuditableDatesBack(topicNB, 14, 4);
        this.pushAuditableDatesBack(postSA, 3, 3);
        this.pushAuditableDatesBack(postNA, 3, 3);
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)3L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)2L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)4L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)2L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        this.pushAuditableDatesBack(replySA1, 6, 6);
        this.pushAuditableDatesBack(replyNA1, 6, 6);
        this.pushAuditableDatesBack(replySB1, 1, 1);
        this.pushAuditableDatesBack(replyNB1, 1, 1);
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)3L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)4L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        this.pushAuditableDatesBack(replySB2, 10, 10);
        this.pushAuditableDatesBack(replySB3, 10, 10);
        this.pushAuditableDatesBack(replyNB2, 10, 10);
        this.pushAuditableDatesBack(replyNB3, 10, 10);
        this.pushAuditableDatesBack(replyNB4, 10, 10);
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicSB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        Assert.assertEquals((Object)topicNB.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(1)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(1)).getSecond()).intValue());
        DISCUSSION_SERVICE.deletePost(replySB1);
        DISCUSSION_SERVICE.deletePost(replyNB1);
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        this.pushAuditableDatesBack(replySA1_1, 1, 1);
        this.pushAuditableDatesBack(replyNA1_1, 1, 1);
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), fourDaysAgo, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, fourDaysAgo, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), yesterday, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicSA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, yesterday, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        Assert.assertEquals((Object)topicNA.getTitle(), (Object)((TopicInfo)((Pair)topics.getPage().get(0)).getFirst()).getTitle());
        Assert.assertEquals((long)1L, (long)((Integer)((Pair)topics.getPage().get(0)).getSecond()).intValue());
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), tomorrow, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, tomorrow, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listHotTopics(DISCUSSION_SITE.getShortName(), future, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listHotTopics(FORUM_NODE, future, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
    }

    @Test
    public void discussionsListingPermissionsChecking() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        PagingResults<TopicInfo> topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(ALTERNATE_DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        Assert.assertEquals((Object)true, (Object)SITE_SERVICE.isMember(DISCUSSION_SITE.getShortName(), TEST_USER));
        Assert.assertEquals((Object)false, (Object)SITE_SERVICE.isMember(ALTERNATE_DISCUSSION_SITE.getShortName(), TEST_USER));
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        TopicInfo topicSA = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Title1A");
        TopicInfo topicSB = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Title1B");
        this.testNodesToTidy.add(topicSA.getNodeRef());
        this.testNodesToTidy.add(topicSB.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        TopicInfo topicPrivA = DISCUSSION_SERVICE.createTopic(ALTERNATE_DISCUSSION_SITE.getShortName(), "PrivTitleA");
        TopicInfo topicPrivB = DISCUSSION_SERVICE.createTopic(ALTERNATE_DISCUSSION_SITE.getShortName(), "PrivTitleB");
        TopicInfo topicPrivC = DISCUSSION_SERVICE.createTopic(ALTERNATE_DISCUSSION_SITE.getShortName(), "PrivTitleC");
        this.testNodesToTidy.add(topicPrivA.getNodeRef());
        this.testNodesToTidy.add(topicPrivB.getNodeRef());
        this.testNodesToTidy.add(topicPrivC.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        TopicInfo topicNA = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "TitleNA");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        TopicInfo topicNB = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "TitleNB");
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        this.testNodesToTidy.add(topicNA.getNodeRef());
        this.testNodesToTidy.add(topicNB.getNodeRef());
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(ALTERNATE_DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.setMembership(ALTERNATE_DISCUSSION_SITE.getShortName(), TEST_USER, "SiteCollaborator");
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(ALTERNATE_DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)3L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        PERMISSION_SERVICE.setInheritParentPermissions(topicPrivC.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(topicPrivC.getNodeRef(), TEST_USER);
        PERMISSION_SERVICE.setInheritParentPermissions(topicNB.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(topicNB.getNodeRef(), TEST_USER);
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(ALTERNATE_DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        DISCUSSION_SERVICE.createPost(topicSA, "Test S Post");
        DISCUSSION_SERVICE.createPost(topicSB, "Test S Post");
        DISCUSSION_SERVICE.createPost(topicPrivA, "Test P Post");
        DISCUSSION_SERVICE.createPost(topicPrivB, "Test P Post");
        DISCUSSION_SERVICE.createPost(topicPrivC, "Test P Post");
        DISCUSSION_SERVICE.createPost(topicNA, "Test N Post");
        DISCUSSION_SERVICE.createPost(topicNB, "Test N Post");
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        PagingResults<PostInfo> posts = DISCUSSION_SERVICE.listPosts(topicSA, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicSB, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicPrivA, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicPrivB, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicPrivC, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicNA, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicNB, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        PostInfo ppSA = DISCUSSION_SERVICE.getPrimaryPost(topicSA);
        PERMISSION_SERVICE.setInheritParentPermissions(ppSA.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(ppSA.getNodeRef(), TEST_USER);
        PostInfo ppPA = DISCUSSION_SERVICE.getPrimaryPost(topicPrivA);
        PERMISSION_SERVICE.setInheritParentPermissions(ppPA.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(ppPA.getNodeRef(), TEST_USER);
        PostInfo ppNA = DISCUSSION_SERVICE.getPrimaryPost(topicNA);
        PERMISSION_SERVICE.setInheritParentPermissions(ppNA.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(ppNA.getNodeRef(), TEST_USER);
        posts = DISCUSSION_SERVICE.listPosts(topicSA, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicSB, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicPrivA, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicPrivB, paging);
        Assert.assertEquals((long)1L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicPrivC, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicNA, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        posts = DISCUSSION_SERVICE.listPosts(topicNB, paging);
        Assert.assertEquals((long)0L, (long)posts.getPage().size());
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.removeMembership(ALTERNATE_DISCUSSION_SITE.getShortName(), TEST_USER);
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)2L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(ALTERNATE_DISCUSSION_SITE.getShortName(), true, paging);
        Assert.assertEquals((long)0L, (long)topics.getPage().size());
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, paging);
        Assert.assertEquals((long)1L, (long)topics.getPage().size());
        paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        topics = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, paging);
        for (TopicInfo topic : topics.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(topic.getNodeRef());
        }
        topics = DISCUSSION_SERVICE.listTopics(ALTERNATE_DISCUSSION_SITE.getShortName(), true, paging);
        for (TopicInfo topic : topics.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(topic.getNodeRef());
        }
        topics = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, paging);
        for (TopicInfo topic : topics.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(topic.getNodeRef());
        }
    }

    @Test
    public void alf_9460() {
        PagingResults<TopicInfo> results = DISCUSSION_SERVICE.listTopics(DISCUSSION_SITE.getShortName(), true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = DISCUSSION_SERVICE.listTopics(FORUM_NODE, true, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TopicInfo siteTopic = DISCUSSION_SERVICE.createTopic(DISCUSSION_SITE.getShortName(), "Site Title");
        TopicInfo nodeTopic = DISCUSSION_SERVICE.createTopic(FORUM_NODE, "Node Title");
        this.testNodesToTidy.add(siteTopic.getNodeRef());
        this.testNodesToTidy.add(nodeTopic.getNodeRef());
        for (TopicInfo topic : new TopicInfo[]{siteTopic, nodeTopic}) {
            String contents = "This Is Some Content";
            PostInfo post = DISCUSSION_SERVICE.createPost(topic, contents);
            String reply1Contents = "Reply Contents";
            PostInfo reply = DISCUSSION_SERVICE.createReply(post, reply1Contents);
            List assocs = NODE_SERVICE.getTargetAssocs(reply.getNodeRef(), (QNamePattern)ContentModel.ASSOC_REFERENCES);
            Assert.assertNotNull((Object)assocs);
            Assert.assertEquals((long)1L, (long)assocs.size());
            Assert.assertEquals((Object)post.getNodeRef(), (Object)((AssociationRef)assocs.get(0)).getTargetRef());
            DISCUSSION_SERVICE.deletePost(post);
            Assert.assertFalse((boolean)NODE_SERVICE.exists(post.getNodeRef()));
            assocs = NODE_SERVICE.getTargetAssocs(reply.getNodeRef(), (QNamePattern)ContentModel.ASSOC_REFERENCES);
            Assert.assertNotNull((Object)assocs);
            Assert.assertEquals((long)0L, (long)assocs.size());
        }
    }

    private void pushAuditableDatesBack(Object thing, int createdDaysAgo, int modifiedDaysAgo) throws Exception {
        NodeRef tmpNodeRef;
        if (thing instanceof NodeRef) {
            tmpNodeRef = (NodeRef)thing;
        } else if (thing instanceof TopicInfo) {
            tmpNodeRef = ((TopicInfo)thing).getNodeRef();
        } else if (thing instanceof PostInfo) {
            tmpNodeRef = ((PostInfo)thing).getNodeRef();
        } else {
            throw new IllegalArgumentException("Unknown thing " + thing);
        }
        final NodeRef node = tmpNodeRef;
        Date created = (Date)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED);
        final Date newCreated = new Date(created.getTime() - (long)createdDaysAgo * 86400000L);
        Date modified = (Date)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_MODIFIED);
        final Date newModified = new Date(modified.getTime() - (long)modifiedDaysAgo * 86400000L);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                BEHAVIOUR_FILTER.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                NODE_SERVICE.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
                NODE_SERVICE.setProperty(node, ContentModel.PROP_MODIFIED, (Serializable)newModified);
                return null;
            }
        }, false, true);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                BEHAVIOUR_FILTER.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_MODIFIED, (Serializable)newModified);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Forced Change"));
                return null;
            }
        }, false, true);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((Object)newCreated, (Object)NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED));
                Assert.assertEquals((Object)newCreated, (Object)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED));
                Assert.assertEquals((Object)newModified, (Object)NODE_SERVICE.getProperty(node, ContentModel.PROP_MODIFIED));
                Assert.assertEquals((Object)newModified, (Object)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_MODIFIED));
                return null;
            }
        }, false, true);
        if (thing instanceof TopicInfo) {
            ((TopicInfoImpl)thing).setCreatedAt(newCreated);
            ((TopicInfoImpl)thing).setModifiedAt(newModified);
        }
        if (thing instanceof PostInfo) {
            ((PostInfoImpl)thing).setCreatedAt(newCreated);
            ((PostInfoImpl)thing).setModifiedAt(newModified);
        }
    }

    private static void createTestSites() throws Exception {
        final DiscussionServiceImpl privateDiscussionService = (DiscussionServiceImpl)testContext.getBean("discussionService");
        DISCUSSION_SITE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            @Override
            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(DiscussionServiceImplTest.TEST_SITE_PREFIX, DiscussionServiceImplTest.class.getSimpleName() + "_testSite" + System.currentTimeMillis(), "test site title", "test site description", SiteVisibility.PUBLIC);
                privateDiscussionService.getSiteDiscussionsContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        FORUM_NODE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef node = NODE_SERVICE.createNode(DISCUSSION_SITE.getNodeRef(), ForumModel.ASSOC_DISCUSSION, QName.createQName((String)"Forum"), ForumModel.TYPE_FORUM).getChildRef();
                NODE_SERVICE.setProperty(node, ContentModel.PROP_NAME, (Serializable)((Object)"Forum"));
                NODE_SERVICE.setProperty(node, ContentModel.PROP_TITLE, (Serializable)((Object)"Forum"));
                CLASS_TEST_NODES_TO_TIDY.add(node);
                return node;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        ALTERNATE_DISCUSSION_SITE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            @Override
            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(DiscussionServiceImplTest.TEST_SITE_PREFIX, DiscussionServiceImplTest.class.getSimpleName() + "_testAltSite" + System.currentTimeMillis(), "alternate site title", "alternate site description", SiteVisibility.PRIVATE);
                privateDiscussionService.getSiteDiscussionsContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
    }

    private static void createTenant() {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (!TENANT_ADMIN_SERVICE.existsTenant(TENANT_DOMAIN)) {
                    TENANT_ADMIN_SERVICE.createTenant(TENANT_DOMAIN, "password".toCharArray());
                }
                return null;
            }
        });
    }

    @Before
    public void setAdminUser() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    @After
    public void deleteTestNodes() throws Exception {
        DiscussionServiceImplTest.performDeletionOfNodes(this.testNodesToTidy);
    }

    @AfterClass
    public static void deleteClassTestNodesAndUsers() throws Exception {
        DiscussionServiceImplTest.performDeletionOfNodes(CLASS_TEST_NODES_TO_TIDY);
        DiscussionServiceImplTest.deleteUser(TEST_USER);
        DiscussionServiceImplTest.deleteTenant();
    }

    private static void deleteTenant() {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TENANT_ADMIN_SERVICE.deleteTenant(TENANT_DOMAIN);
                return null;
            }
        });
    }

    private static void performDeletionOfNodes(final List<NodeRef> nodesToDelete) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                for (NodeRef node : nodesToDelete) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    if (NODE_SERVICE.getType(node).equals((Object)SiteModel.TYPE_SITE)) {
                        SiteInfo siteInfo = SITE_SERVICE.getSite(node);
                        SITE_SERVICE.deleteSite(siteInfo.getShortName());
                        continue;
                    }
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put(ContentModel.PROP_USERNAME, userName);
                    ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
                    ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
                    ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
                    ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
                    PERSON_SERVICE.createPerson(ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (PERSON_SERVICE.personExists(userName)) {
                    PERSON_SERVICE.deletePerson(userName);
                }
                return null;
            }
        });
    }

    static {
        TENANT_DOMAIN = (DiscussionServiceImplTest.class.getSimpleName() + "Tenant").toLowerCase();
        TEST_USER = DiscussionServiceImplTest.class.getSimpleName() + "_testuser@" + TENANT_DOMAIN;
        ADMIN_USER = AuthenticationUtil.getAdminUserName() + "@" + TENANT_DOMAIN;
        CLASS_TEST_NODES_TO_TIDY = new ArrayList<NodeRef>();
    }
}

