/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMStoreDAO;
import org.alfresco.repo.domain.avm.AVMStoreEntity;
import org.alfresco.repo.domain.avm.AVMStorePropertyEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class AbstractAVMStoreDAOImpl
implements AVMStoreDAO {
    private static final String CACHE_REGION_AVM_STORE = "AVMStore";
    private static final String CACHE_REGION_AVM_STORE_PROP = "AVMStoreProp";
    private final AVMStoreEntityCallbackDAO avmStoreEntityDaoCallback = new AVMStoreEntityCallbackDAO();
    private final AVMStorePropertyEntityCallbackDAO avmStorePropEntityDaoCallback;
    private QNameDAO qnameDAO;
    private EntityLookupCache<Long, AVMStoreEntity, String> avmStoreCache = new EntityLookupCache<Long, AVMStoreEntity, String>(this.avmStoreEntityDaoCallback);
    private EntityLookupCache<Pair<Long, Long>, AVMStorePropertyEntity, Serializable> avmStorePropCache;

    public void setAvmStoreCache(SimpleCache<Serializable, Object> avmStoreCache) {
        this.avmStoreCache = new EntityLookupCache<Long, AVMStoreEntity, String>(avmStoreCache, CACHE_REGION_AVM_STORE, this.avmStoreEntityDaoCallback);
    }

    public void setAvmStorePropertyCache(SimpleCache<Serializable, Object> avmStorePropCache) {
        this.avmStorePropCache = new EntityLookupCache<Pair<Long, Long>, AVMStorePropertyEntity, Serializable>(avmStorePropCache, CACHE_REGION_AVM_STORE_PROP, this.avmStorePropEntityDaoCallback);
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public AbstractAVMStoreDAOImpl() {
        this.avmStorePropEntityDaoCallback = new AVMStorePropertyEntityCallbackDAO();
        this.avmStorePropCache = new EntityLookupCache<Pair<Long, Long>, AVMStorePropertyEntity, Serializable>(this.avmStorePropEntityDaoCallback);
    }

    @Override
    public AVMStoreEntity createStore(String name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        AVMStoreEntity storeEntity = new AVMStoreEntity();
        storeEntity.setVersion(0L);
        storeEntity.setName(name);
        storeEntity.setVers(0L);
        Pair<Long, AVMStoreEntity> entityPair = this.avmStoreCache.getOrCreateByValue(storeEntity);
        return (AVMStoreEntity)entityPair.getSecond();
    }

    @Override
    public AVMStoreEntity getStore(long storeId) {
        Pair<Long, AVMStoreEntity> entityPair = this.avmStoreCache.getByKey(storeId);
        if (entityPair == null) {
            return null;
        }
        return (AVMStoreEntity)entityPair.getSecond();
    }

    @Override
    public AVMStoreEntity getStoreByRoot(long rootNodeId) {
        return this.getStoreEntityByRoot(rootNodeId);
    }

    @Override
    public AVMStoreEntity getStore(String name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        AVMStoreEntity storeEntity = new AVMStoreEntity();
        storeEntity.setName(name);
        Pair<Long, AVMStoreEntity> entityPair = this.avmStoreCache.getByValue(storeEntity);
        if (entityPair == null) {
            return null;
        }
        return (AVMStoreEntity)entityPair.getSecond();
    }

    @Override
    public List<AVMStoreEntity> getAllStores() {
        return this.getAllStoreEntities();
    }

    @Override
    public void updateStore(AVMStoreEntity storeEntity) {
        ParameterCheck.mandatory((String)"storeEntity", (Object)storeEntity);
        ParameterCheck.mandatory((String)"storeEntity.getId()", (Object)storeEntity.getId());
        ParameterCheck.mandatory((String)"storeEntity.getVers()", (Object)storeEntity.getVers());
        int updated = this.avmStoreCache.updateValue(storeEntity.getId(), storeEntity);
        if (updated < 1) {
            throw new ConcurrencyFailureException("AVMStore with ID (" + storeEntity.getId() + ") no longer exists or has been updated concurrently");
        }
    }

    @Override
    public void deleteStore(long storeId) {
        Pair<Long, AVMStoreEntity> entityPair = this.avmStoreCache.getByKey(storeId);
        if (entityPair == null) {
            return;
        }
        int deleted = this.avmStoreCache.deleteByKey(storeId);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMStore with ID " + storeId + " no longer exists");
        }
    }

    @Override
    public void clearStoreEntityCache() {
        this.avmStoreCache.clear();
    }

    protected abstract AVMStoreEntity getStoreEntity(long var1);

    protected abstract AVMStoreEntity getStoreEntity(String var1);

    protected abstract AVMStoreEntity getStoreEntityByRoot(long var1);

    protected abstract List<AVMStoreEntity> getAllStoreEntities();

    protected abstract AVMStoreEntity createStoreEntity(AVMStoreEntity var1);

    protected abstract int deleteStoreEntity(long var1);

    protected abstract int updateStoreEntity(AVMStoreEntity var1);

    @Override
    public void createOrUpdateStoreProperty(long storeId, QName qname, PropertyValue value) {
        ParameterCheck.mandatory((String)"qname", (Object)qname);
        ParameterCheck.mandatory((String)"value", (Object)value);
        Pair<Long, QName> qnamePair = this.qnameDAO.getOrCreateQName(qname);
        Long qnameId = (Long)qnamePair.getFirst();
        AVMStorePropertyEntity propEntity = new AVMStorePropertyEntity(storeId, qnameId, value);
        Pair key = new Pair((Object)storeId, (Object)propEntity.getQnameId());
        Pair<Pair<Long, Long>, AVMStorePropertyEntity> entityPair = this.avmStorePropCache.getByKey((Pair<Long, Long>)key);
        if (entityPair != null) {
            int updated = this.avmStorePropCache.updateValue((Pair<Long, Long>)key, propEntity);
            if (updated < 1) {
                throw new ConcurrencyFailureException("AVMStorePropertyEntity with IDs (" + propEntity.getAvmStoreId() + ", " + propEntity.getQnameId() + ") no longer exists");
            }
        } else {
            this.avmStorePropCache.getOrCreateByValue(propEntity);
        }
    }

    @Override
    public PropertyValue getStoreProperty(long storeId, QName qname) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(qname);
        if (qnamePair != null) {
            Long qnameId = (Long)qnamePair.getFirst();
            Pair key = new Pair((Object)storeId, (Object)qnameId);
            Pair<Pair<Long, Long>, AVMStorePropertyEntity> entityPair = this.avmStorePropCache.getByKey((Pair<Long, Long>)key);
            if (entityPair == null) {
                return null;
            }
            return (PropertyValue)entityPair.getSecond();
        }
        return null;
    }

    @Override
    public Map<QName, PropertyValue> getStoreProperties(long storeId) {
        List<AVMStorePropertyEntity> propEntities = this.getStorePropertyEntities(storeId);
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(propEntities.size());
        for (AVMStorePropertyEntity propEntity : propEntities) {
            Pair<Long, QName> qnamePair = this.qnameDAO.getQName(propEntity.getQnameId());
            if (qnamePair == null) continue;
            props.put((QName)qnamePair.getSecond(), propEntity);
        }
        return props;
    }

    @Override
    public Map<String, Map<QName, PropertyValue>> getStorePropertiesByKeyPattern(String uriPattern, String localNamePattern) {
        ParameterCheck.mandatoryString((String)"uriPattern", (String)uriPattern);
        ParameterCheck.mandatoryString((String)"localNamePattern", (String)localNamePattern);
        List<AVMStorePropertyEntity> spEntities = this.getStorePropertyEntitiesByKeyPattern(uriPattern, localNamePattern);
        HashMap<String, Map<QName, PropertyValue>> results = new HashMap<String, Map<QName, PropertyValue>>(10);
        for (AVMStorePropertyEntity spEntity : spEntities) {
            String storeName = this.getStore(spEntity.getAvmStoreId()).getName();
            Pair<Long, QName> qnamePair = this.qnameDAO.getQName(spEntity.getQnameId());
            if (qnamePair == null) continue;
            QName propQName = (QName)qnamePair.getSecond();
            HashMap<QName, AVMStorePropertyEntity> pairs = null;
            pairs = (HashMap<QName, AVMStorePropertyEntity>)results.get(storeName);
            if (pairs == null) {
                pairs = new HashMap<QName, AVMStorePropertyEntity>();
                results.put(storeName, pairs);
            }
            pairs.put(propQName, spEntity);
        }
        return results;
    }

    @Override
    public Map<QName, PropertyValue> getStorePropertiesByStoreAndKeyPattern(long storeId, String uriPattern, String localNamePattern) {
        ParameterCheck.mandatoryString((String)"uriPattern", (String)uriPattern);
        ParameterCheck.mandatoryString((String)"localNamePattern", (String)localNamePattern);
        List<AVMStorePropertyEntity> propEntities = this.getStorePropertyEntitiesByStoreAndKeyPattern(storeId, uriPattern, localNamePattern);
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(propEntities.size());
        for (AVMStorePropertyEntity propEntity : propEntities) {
            Pair<Long, QName> qnamePair = this.qnameDAO.getQName(propEntity.getQnameId());
            if (qnamePair == null) continue;
            props.put((QName)qnamePair.getSecond(), propEntity);
        }
        return props;
    }

    @Override
    public void deleteStoreProperty(long storeId, QName qname) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(qname);
        if (qnamePair != null) {
            Long qnameId = (Long)qnamePair.getFirst();
            Pair key = new Pair((Object)storeId, (Object)qnameId);
            Pair<Pair<Long, Long>, AVMStorePropertyEntity> entityPair = this.avmStorePropCache.getByKey((Pair<Long, Long>)key);
            if (entityPair == null) {
                return;
            }
            int deleted = this.avmStorePropCache.deleteByKey((Pair<Long, Long>)key);
            if (deleted < 1) {
                throw new ConcurrencyFailureException("AVMStoreProperty with key (" + storeId + ", " + qnameId + ") no longer exists");
            }
        }
    }

    @Override
    public void deleteStoreProperties(long storeId) {
        Map<QName, PropertyValue> props = this.getStoreProperties(storeId);
        if (props.size() == 0) {
            return;
        }
        for (QName qname : props.keySet()) {
            this.deleteStoreProperty(storeId, qname);
        }
    }

    protected abstract void insertStorePropertyEntity(AVMStorePropertyEntity var1);

    protected abstract int updateStorePropertyEntity(AVMStorePropertyEntity var1);

    protected abstract AVMStorePropertyEntity getStorePropertyEntity(long var1, long var3);

    protected abstract List<AVMStorePropertyEntity> getStorePropertyEntities(long var1);

    protected abstract List<AVMStorePropertyEntity> getStorePropertyEntitiesByKeyPattern(String var1, String var2);

    protected abstract List<AVMStorePropertyEntity> getStorePropertyEntitiesByStoreAndKeyPattern(long var1, String var3, String var4);

    protected abstract int deleteStorePropertyEntity(long var1, long var3);

    protected abstract int deleteStorePropertyEntities(long var1);

    private class AVMStorePropertyEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Pair<Long, Long>, AVMStorePropertyEntity, Serializable> {
        private AVMStorePropertyEntityCallbackDAO() {
        }

        private final Pair<Pair<Long, Long>, AVMStorePropertyEntity> convertEntityToPair(AVMStorePropertyEntity storePropEntity) {
            if (storePropEntity == null) {
                return null;
            }
            Pair key = new Pair((Object)storePropEntity.getAvmStoreId(), (Object)storePropEntity.getQnameId());
            return new Pair((Object)key, (Object)storePropEntity);
        }

        @Override
        public Serializable getValueKey(AVMStorePropertyEntity value) {
            return null;
        }

        @Override
        public Pair<Pair<Long, Long>, AVMStorePropertyEntity> createValue(AVMStorePropertyEntity value) {
            AbstractAVMStoreDAOImpl.this.insertStorePropertyEntity(value);
            return this.convertEntityToPair(value);
        }

        @Override
        public Pair<Pair<Long, Long>, AVMStorePropertyEntity> findByKey(Pair<Long, Long> key) {
            AVMStorePropertyEntity entity = AbstractAVMStoreDAOImpl.this.getStorePropertyEntity((Long)key.getFirst(), (Long)key.getSecond());
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Pair<Long, Long>, AVMStorePropertyEntity> findByValue(AVMStorePropertyEntity value) {
            if (value.getAvmStoreId() != null && value.getQnameId() != null) {
                return this.findByKey((Pair<Long, Long>)new Pair((Object)value.getAvmStoreId(), (Object)value.getQnameId()));
            }
            return null;
        }

        @Override
        public int updateValue(Pair<Long, Long> key, AVMStorePropertyEntity value) {
            return AbstractAVMStoreDAOImpl.this.updateStorePropertyEntity(value);
        }

        @Override
        public int deleteByKey(Pair<Long, Long> key) {
            return AbstractAVMStoreDAOImpl.this.deleteStorePropertyEntity((Long)key.getFirst(), (Long)key.getSecond());
        }

        @Override
        public int deleteByValue(AVMStorePropertyEntity value) {
            throw new UnsupportedOperationException("deleteByValue(AVMStorePropertyEntity)");
        }
    }

    private class AVMStoreEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Long, AVMStoreEntity, String> {
        private AVMStoreEntityCallbackDAO() {
        }

        private final Pair<Long, AVMStoreEntity> convertEntityToPair(AVMStoreEntity storeEntity) {
            if (storeEntity == null) {
                return null;
            }
            return new Pair((Object)storeEntity.getId(), (Object)storeEntity);
        }

        @Override
        public String getValueKey(AVMStoreEntity value) {
            return value.getName();
        }

        @Override
        public Pair<Long, AVMStoreEntity> createValue(AVMStoreEntity value) {
            AVMStoreEntity entity = AbstractAVMStoreDAOImpl.this.createStoreEntity(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AVMStoreEntity> findByKey(Long key) {
            AVMStoreEntity entity = AbstractAVMStoreDAOImpl.this.getStoreEntity(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AVMStoreEntity> findByValue(AVMStoreEntity value) {
            if (value == null || value.getName() == null) {
                throw new AlfrescoRuntimeException("Unexpected: AVMStoreEntity / name must not be null");
            }
            return this.convertEntityToPair(AbstractAVMStoreDAOImpl.this.getStoreEntity(value.getName()));
        }

        @Override
        public int updateValue(Long key, AVMStoreEntity value) {
            return AbstractAVMStoreDAOImpl.this.updateStoreEntity(value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractAVMStoreDAOImpl.this.deleteStoreEntity(key);
        }

        @Override
        public int deleteByValue(AVMStoreEntity value) {
            throw new UnsupportedOperationException("deleteByValue(AVMStoreEntity)");
        }
    }
}

