/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;

public class ContentDataDAOTest
extends TestCase {
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private ContentDataDAO contentDataDAO;
    private ContentStore contentStore;
    private static final String[] MIMETYPES = new String[]{"application/acp", "application/vnd.ms-excel", "image/jpeg", "application/x-javascript", "application/rss+xml"};
    private static final String[] ENCODINGS = new String[]{"utf-8", "ascii", "latin1", "wibbles", "iso-whatever"};
    private static final Locale[] LOCALES = new Locale[]{Locale.FRENCH, Locale.CHINESE, Locale.ITALIAN, Locale.JAPANESE, Locale.ENGLISH};

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.contentDataDAO = (ContentDataDAO)this.ctx.getBean("contentDataDAO");
        this.contentStore = new FileContentStore((ApplicationContext)this.ctx, TempFileProvider.getTempDir());
    }

    private Pair<Long, ContentData> create(final ContentData contentData) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>>(){

            @Override
            public Pair<Long, ContentData> execute() throws Throwable {
                Pair<Long, ContentData> contentDataPair = ContentDataDAOTest.this.contentDataDAO.createContentData(contentData);
                return contentDataPair;
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    private Pair<Long, ContentData> update(final Long id, final ContentData contentData) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>>(){

            @Override
            public Pair<Long, ContentData> execute() throws Throwable {
                ContentDataDAOTest.this.contentDataDAO.updateContentData(id, contentData);
                return new Pair((Object)id, (Object)contentData);
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    private void delete(final Long id) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDataDAOTest.this.contentDataDAO.deleteContentData(id);
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback, false, false);
    }

    private void getAndCheck(final Long contentDataId, ContentData checkContentData) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>>(){

            @Override
            public Pair<Long, ContentData> execute() throws Throwable {
                Pair<Long, ContentData> contentDataPair = ContentDataDAOTest.this.contentDataDAO.getContentData(contentDataId);
                return contentDataPair;
            }
        };
        Pair<Long, ContentData> resultPair = this.txnHelper.doInTransaction(callback, true, false);
        ContentDataDAOTest.assertNotNull((String)("Failed to find result for ID " + contentDataId), resultPair);
        ContentDataDAOTest.assertEquals((String)"ContentData retrieved not the same as persisted: ", (Object)checkContentData, (Object)resultPair.getSecond());
    }

    private ContentData getContentData() {
        ContentContext contentCtx = new ContentContext(null, null);
        String contentUrl = this.contentStore.getWriter(contentCtx).getContentUrl();
        ContentData contentData = new ContentData(contentUrl, "text/plain", 12335L, "UTF-8", Locale.FRENCH);
        return contentData;
    }

    public void testGetWithInvalidId() {
        try {
            this.contentDataDAO.getContentData(-1L);
            ContentDataDAOTest.fail((String)"Invalid ContentData IDs must generate DataIntegrityViolationException.");
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            // empty catch block
        }
    }

    public void testCreateContentDataSimple() throws Exception {
        ContentData contentData = this.getContentData();
        Pair<Long, ContentData> resultPair = this.create(contentData);
        this.getAndCheck((Long)resultPair.getFirst(), contentData);
    }

    public void testCreateContentDataNulls() throws Exception {
        ContentData contentData = new ContentData(null, null, 0L, null, null);
        Pair<Long, ContentData> resultPair = this.create(contentData);
        this.getAndCheck((Long)resultPair.getFirst(), contentData);
    }

    public void testEnsureCaseSensitiveStorage() throws Exception {
        ContentData contentData = this.getContentData();
        String contentUrlUpper = contentData.getContentUrl().toUpperCase();
        ContentData contentDataUpper = new ContentData(contentUrlUpper, "text/plain", 0L, "UTF-8", new Locale("FR"));
        String contentUrlLower = contentData.getContentUrl().toLowerCase();
        ContentData contentDataLower = new ContentData(contentUrlLower, "text/plain", 0L, "utf-8", new Locale("fr"));
        Pair<Long, ContentData> resultPairUpper = this.create(contentDataUpper);
        this.getAndCheck((Long)resultPairUpper.getFirst(), contentDataUpper);
        Pair<Long, ContentData> resultPairLower = this.create(contentDataLower);
        this.getAndCheck((Long)resultPairLower.getFirst(), contentDataLower);
    }

    public void testUpdate() throws Exception {
        ContentData contentData = this.getContentData();
        Pair<Long, ContentData> resultPair = this.create(contentData);
        Long id = (Long)resultPair.getFirst();
        contentData = ContentData.setMimetype((ContentData)contentData, (String)"text/html");
        contentData = ContentData.setEncoding((ContentData)contentData, (String)"UTF-16");
        this.update(id, contentData);
        this.getAndCheck(id, contentData);
    }

    public void testDelete() throws Exception {
        ContentData contentData = this.getContentData();
        Pair<Long, ContentData> resultPair = this.create(contentData);
        this.getAndCheck((Long)resultPair.getFirst(), contentData);
        this.delete((Long)resultPair.getFirst());
        try {
            this.getAndCheck((Long)resultPair.getFirst(), contentData);
            ContentDataDAOTest.fail((String)"Entity still exists");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testReinstate_ALF3867() {
        ContentData contentData = this.getContentData();
        Pair<Long, ContentData> resultPair = this.create(contentData);
        this.getAndCheck((Long)resultPair.getFirst(), contentData);
        this.delete((Long)resultPair.getFirst());
        this.create(contentData);
    }

    public void testContentUrl_FetchingOrphansNoLimit() throws Exception {
        ContentData contentData = this.getContentData();
        Pair<Long, ContentData> resultPair = this.create(contentData);
        this.getAndCheck((Long)resultPair.getFirst(), contentData);
        this.delete((Long)resultPair.getFirst());
        final String contentUrlOrphaned = contentData.getContentUrl();
        final boolean[] found = new boolean[]{false};
        ContentDataDAO.ContentUrlHandler handler = new ContentDataDAO.ContentUrlHandler(){

            @Override
            public void handle(Long id, String contentUrl, Long orphanTime) {
                if (id == null || contentUrl == null || orphanTime == null) {
                    Assert.fail((String)("Invalid orphan data returned to handler: " + id + "-" + contentUrl + "-" + orphanTime));
                }
                if (contentUrl.equals(contentUrlOrphaned)) {
                    found[0] = true;
                }
            }
        };
        this.contentDataDAO.getContentUrlsOrphaned(handler, Long.MAX_VALUE, Integer.MAX_VALUE);
        ContentDataDAOTest.assertTrue((String)"Newly-orphaned content URL not found", (boolean)found[0]);
    }

    public void testContentUrl_FetchingOrphansWithLimit() throws Exception {
        for (int i = 0; i < 5; ++i) {
            ContentData contentData = this.getContentData();
            Pair<Long, ContentData> resultPair = this.create(contentData);
            this.getAndCheck((Long)resultPair.getFirst(), contentData);
            this.delete((Long)resultPair.getFirst());
        }
        final int[] count = new int[]{0};
        ContentDataDAO.ContentUrlHandler handler = new ContentDataDAO.ContentUrlHandler(){

            @Override
            public void handle(Long id, String contentUrl, Long orphanTime) {
                if (id == null || contentUrl == null || orphanTime == null) {
                    Assert.fail((String)("Invalid orphan data returned to handler: " + id + "-" + contentUrl + "-" + orphanTime));
                }
                count[0] = count[0] + 1;
            }
        };
        this.contentDataDAO.getContentUrlsOrphaned(handler, Long.MAX_VALUE, 5);
        ContentDataDAOTest.assertEquals((String)"Expected exactly 5 results callbacks", (int)5, (int)count[0]);
    }

    private List<Pair<Long, ContentData>> speedTestWrite(String name, int total) {
        System.out.println("Starting write speed test: " + name);
        long start = System.nanoTime();
        ArrayList<Pair<Long, ContentData>> pairs = new ArrayList<Pair<Long, ContentData>>(100000);
        for (int i = 0; i < total / 200 / 5; ++i) {
            for (int j = 0; j < 200; ++j) {
                for (int k = 0; k < 5; ++k) {
                    ContentData contentData = this.getContentData();
                    String contentUrl = contentData.getContentUrl();
                    contentData = new ContentData(contentUrl, MIMETYPES[k], (long)j * (long)k, ENCODINGS[k], LOCALES[k]);
                    Pair<Long, ContentData> pair = this.create(contentData);
                    pairs.add(pair);
                }
            }
            long now = System.nanoTime();
            double diffMs = (double)(now - start) / 1000000.0;
            double aveMs = diffMs / (double)pairs.size();
            String msg = String.format("   Wrote %7d rows; average is %5.2f ms per row or %5.2f rows per second", pairs.size(), aveMs, 1000.0 / aveMs);
            System.out.println(msg);
        }
        return pairs;
    }

    private void speedTestRead(String name, List<Pair<Long, ContentData>> pairs) {
        System.out.println("Starting read speed test: " + name);
        long start = System.nanoTime();
        int num = 1;
        for (Pair<Long, ContentData> pair : pairs) {
            Long id = (Long)pair.getFirst();
            ContentData contentData = (ContentData)pair.getSecond();
            this.getAndCheck(id, contentData);
            if (num % 1000 == 0) {
                long now = System.nanoTime();
                double diffMs = (double)(now - start) / 1000000.0;
                double aveMs = diffMs / (double)num;
                String msg = String.format("   Read %7d rows; average is %5.2f ms per row or %5.2f rows per second", num, aveMs, 1000.0 / aveMs);
                System.out.println(msg);
            }
            ++num;
        }
    }

    public void testCreateSpeedIndividualTxns() {
        List<Pair<Long, ContentData>> pairs = this.speedTestWrite(this.getName(), 2000);
        this.speedTestRead(this.getName(), pairs);
    }

    public void testCreateSpeedSingleTxn() {
        RetryingTransactionHelper.RetryingTransactionCallback<List<Pair<Long, ContentData>>> writeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<Pair<Long, ContentData>>>(){

            @Override
            public List<Pair<Long, ContentData>> execute() throws Throwable {
                return ContentDataDAOTest.this.speedTestWrite(ContentDataDAOTest.this.getName(), 10000);
            }
        };
        final List<Pair<Long, ContentData>> pairs = this.txnHelper.doInTransaction(writeCallback, false, false);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDataDAOTest.this.speedTestRead(ContentDataDAOTest.this.getName(), pairs);
                return null;
            }
        };
        this.txnHelper.doInTransaction(readCallback, false, false);
    }
}

