/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.contentdata.ibatis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.repo.domain.contentdata.AbstractContentDataDAOImpl;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.contentdata.ContentDataEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlEntity;
import org.alfresco.repo.domain.contentdata.ContentUrlOrphanQuery;
import org.alfresco.repo.domain.contentdata.ContentUrlUpdateEntity;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

public class ContentDataDAOImpl
extends AbstractContentDataDAOImpl {
    private static final String SELECT_CONTENT_URL_BY_ID = "alfresco.content.select_ContentUrlById";
    private static final String SELECT_CONTENT_URL_BY_KEY = "alfresco.content.select_ContentUrlByKey";
    private static final String SELECT_CONTENT_URL_BY_KEY_UNREFERENCED = "alfresco.content.select_ContentUrlByKeyUnreferenced";
    private static final String SELECT_CONTENT_URLS_ORPHANED = "alfresco.content.select_ContentUrlsOrphaned";
    private static final String SELECT_CONTENT_DATA_BY_ID = "alfresco.content.select_ContentDataById";
    private static final String SELECT_CONTENT_DATA_BY_NODE_AND_QNAME = "alfresco.content.select_ContentDataByNodeAndQName";
    private static final String SELECT_CONTENT_DATA_BY_NODE_IDS = "alfresco.content.select_ContentDataByNodeIds";
    private static final String INSERT_CONTENT_URL = "alfresco.content.insert.insert_ContentUrl";
    private static final String INSERT_CONTENT_DATA = "alfresco.content.insert.insert_ContentData";
    private static final String UPDATE_CONTENT_URL_ORPHAN_TIME = "alfresco.content.update_ContentUrlOrphanTime";
    private static final String UPDATE_CONTENT_DATA = "alfresco.content.update_ContentData";
    private static final String DELETE_CONTENT_DATA = "alfresco.content.delete_ContentData";
    private static final String DELETE_CONTENT_URLS = "alfresco.content.delete_ContentUrls";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    public Pair<Long, String> createContentUrlOrphaned(String contentUrl, Date orphanTime) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        contentUrlEntity.setSize(0L);
        contentUrlEntity.setOrphanTime(orphanTime == null ? System.currentTimeMillis() : orphanTime.getTime());
        this.template.insert(INSERT_CONTENT_URL, (Object)contentUrlEntity);
        Long id = contentUrlEntity.getId();
        return new Pair((Object)id, (Object)contentUrl);
    }

    @Override
    protected ContentUrlEntity createContentUrlEntity(String contentUrl, long size) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        contentUrlEntity.setSize(size);
        contentUrlEntity.setOrphanTime(null);
        this.template.insert(INSERT_CONTENT_URL, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    protected ContentUrlEntity getContentUrlEntity(Long id) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setId(id);
        contentUrlEntity = (ContentUrlEntity)this.template.selectOne(SELECT_CONTENT_URL_BY_ID, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    protected ContentUrlEntity getContentUrlEntity(String contentUrl) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        if (contentUrlEntity.getContentUrlShort() != null) {
            contentUrlEntity.setContentUrlShort(contentUrlEntity.getContentUrlShort().toLowerCase());
        }
        contentUrlEntity = (ContentUrlEntity)this.template.selectOne(SELECT_CONTENT_URL_BY_KEY, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    public void getContentUrlsOrphaned(ContentDataDAO.ContentUrlHandler contentUrlHandler, Long maxOrphanTimeExclusive, int maxResults) {
        ParameterCheck.mandatory((String)"maxOrphanTimeExclusive", (Object)maxOrphanTimeExclusive);
        ContentUrlOrphanQuery query = new ContentUrlOrphanQuery();
        query.setMaxOrphanTimeExclusive(maxOrphanTimeExclusive);
        List results = this.template.selectList(SELECT_CONTENT_URLS_ORPHANED, (Object)query, new RowBounds(0, maxResults));
        for (ContentUrlEntity result : results) {
            contentUrlHandler.handle(result.getId(), result.getContentUrl(), result.getOrphanTime());
        }
    }

    @Override
    public int updateContentUrlOrphanTime(Long id, Long orphanTime, Long oldOrphanTime) {
        ContentUrlUpdateEntity contentUrlUpdateEntity = new ContentUrlUpdateEntity();
        contentUrlUpdateEntity.setId(id);
        contentUrlUpdateEntity.setOrphanTime(orphanTime);
        contentUrlUpdateEntity.setOldOrphanTime(oldOrphanTime);
        return this.template.update(UPDATE_CONTENT_URL_ORPHAN_TIME, (Object)contentUrlUpdateEntity);
    }

    @Override
    public int deleteContentUrls(List<Long> ids) {
        return this.template.delete(DELETE_CONTENT_URLS, ids);
    }

    @Override
    protected ContentUrlEntity getContentUrlEntityUnreferenced(String contentUrl) {
        ContentUrlEntity contentUrlEntity = new ContentUrlEntity();
        contentUrlEntity.setContentUrl(contentUrl);
        if (contentUrlEntity.getContentUrlShort() != null) {
            contentUrlEntity.setContentUrlShort(contentUrlEntity.getContentUrlShort().toLowerCase());
        }
        contentUrlEntity = (ContentUrlEntity)this.template.selectOne(SELECT_CONTENT_URL_BY_KEY_UNREFERENCED, (Object)contentUrlEntity);
        return contentUrlEntity;
    }

    @Override
    protected ContentDataEntity createContentDataEntity(Long contentUrlId, Long mimetypeId, Long encodingId, Long localeId) {
        ContentDataEntity contentDataEntity = new ContentDataEntity();
        contentDataEntity.setVersion(ContentDataEntity.CONST_LONG_ZERO);
        contentDataEntity.setContentUrlId(contentUrlId);
        contentDataEntity.setMimetypeId(mimetypeId);
        contentDataEntity.setEncodingId(encodingId);
        contentDataEntity.setLocaleId(localeId);
        try {
            this.template.insert(INSERT_CONTENT_DATA, (Object)contentDataEntity);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to insert ContentData: " + contentDataEntity, e);
        }
        return contentDataEntity;
    }

    @Override
    protected ContentDataEntity getContentDataEntity(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("id", id);
        ContentDataEntity contentDataEntity = (ContentDataEntity)this.template.selectOne(SELECT_CONTENT_DATA_BY_ID, params);
        return contentDataEntity;
    }

    @Override
    protected List<ContentDataEntity> getContentDataEntitiesForNodes(Set<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return Collections.emptyList();
        }
        IdsEntity idsEntity = new IdsEntity();
        idsEntity.setIds(new ArrayList<Long>(nodeIds));
        return this.template.selectList(SELECT_CONTENT_DATA_BY_NODE_IDS, (Object)idsEntity);
    }

    @Override
    protected int updateContentDataEntity(ContentDataEntity entity) {
        entity.incrementVersion();
        return this.template.update(UPDATE_CONTENT_DATA, (Object)entity);
    }

    @Override
    protected int deleteContentDataEntity(Long id) {
        try {
            ContentData contentData = (ContentData)this.getContentData(id).getSecond();
            String contentUrl = contentData.getContentUrl();
            if (contentUrl != null) {
                this.registerDereferencedContentUrl(contentUrl);
            }
        }
        catch (DataIntegrityViolationException e) {
            // empty catch block
        }
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("id", id);
        return this.template.delete(DELETE_CONTENT_DATA, params);
    }

    @Override
    public void deleteContentDataForNode(Long nodeId, Set<Long> qnameIds) {
        if (qnameIds.size() == 0) {
            return;
        }
        IdsEntity idsEntity = new IdsEntity();
        idsEntity.setIdOne(nodeId);
        idsEntity.setIds(new ArrayList<Long>(qnameIds));
        List ids = this.template.selectList(SELECT_CONTENT_DATA_BY_NODE_AND_QNAME, (Object)idsEntity);
        for (Long id : ids) {
            try {
                this.deleteContentData(id);
            }
            catch (ConcurrencyFailureException e) {}
        }
    }
}

