/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChildAssocEntity {
    private static final Log logger = LogFactory.getLog(ChildAssocEntity.class);
    private Long id;
    private Long version;
    private NodeEntity parentNode;
    private NodeEntity childNode;
    private Long typeQNameId;
    private Long childNodeNameCrc;
    private String childNodeName;
    private Long qnameNamespaceId;
    private String qnameLocalName;
    private Long qnameCrc;
    private Boolean isPrimary;
    private int assocIndex;
    private List<Long> typeQNameIds;
    private List<Long> childNodeNameCrcs;
    private List<Long> childNodeTypeQNameIds;
    private Boolean sameStore;
    private boolean ordered = false;
    private static final String TRUNCATED_NAME_INDICATOR = "~~~";

    public static Long getQNameCrc(QName qname) {
        CRC32 crc = new CRC32();
        try {
            crc.update(qname.getNamespaceURI().getBytes("UTF-8"));
            crc.update(qname.getLocalName().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported");
        }
        return crc.getValue();
    }

    public static Long getChildNodeNameCrc(String childNodeName) {
        CRC32 crc = new CRC32();
        try {
            crc.update(childNodeName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported");
        }
        return crc.getValue();
    }

    public static String getChildNodeNameShort(String childNodeName) {
        int length = childNodeName.length();
        if (length <= 50) {
            return childNodeName;
        }
        StringBuilder ret = new StringBuilder(50);
        ret.append(childNodeName.substring(0, 47)).append(TRUNCATED_NAME_INDICATOR);
        return ret.toString();
    }

    public static Pair<String, Long> getChildNameUnique(DictionaryService dictionaryService, QName assocTypeQName, String childName) {
        String childNameNewShort;
        if (childName == null) {
            throw new IllegalArgumentException("Child name may not be null.  Use the Node ID ...");
        }
        long childNameNewCrc = -1L;
        AssociationDefinition assocDef = dictionaryService.getAssociation(assocTypeQName);
        if (assocDef == null || !assocDef.isChild()) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("No child association of this type could be found: " + assocTypeQName));
            }
            childNameNewShort = GUID.generate();
            childNameNewCrc = -1L * ChildAssocEntity.getChildNodeNameCrc(childNameNewShort);
        } else {
            ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
            if (childAssocDef.getDuplicateChildNamesAllowed()) {
                childNameNewShort = GUID.generate();
                childNameNewCrc = -1L * ChildAssocEntity.getChildNodeNameCrc(childNameNewShort);
            } else {
                String childNameNewLower = childName.toLowerCase();
                childNameNewShort = ChildAssocEntity.getChildNodeNameShort(childNameNewLower);
                childNameNewCrc = ChildAssocEntity.getChildNodeNameCrc(childNameNewLower);
            }
        }
        return new Pair((Object)childNameNewShort, (Object)childNameNewCrc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("ChildAssocEntity").append("[ ID=").append(this.id).append(", typeQNameId=").append(this.typeQNameId).append(", childNodeNameCrc=").append(this.childNodeNameCrc).append(", childNodeName=").append(this.childNodeName).append(", qnameNamespaceId=").append(this.qnameNamespaceId).append(", qnameLocalName=").append(this.qnameLocalName).append(", qnameCrc=").append(this.qnameCrc).append(", parentNode=").append(this.parentNode).append(", childNode=").append(this.childNode).append("]");
        return sb.toString();
    }

    public ChildAssociationRef getRef(QNameDAO qnameDAO) {
        QName typeQName = (QName)qnameDAO.getQName(this.typeQNameId).getSecond();
        QName qname = QName.createQName((String)((String)qnameDAO.getNamespace(this.qnameNamespaceId).getSecond()), (String)this.qnameLocalName);
        return new ChildAssociationRef(typeQName, this.parentNode.getNodeRef(), qname, this.childNode.getNodeRef(), this.isPrimary.booleanValue(), this.assocIndex);
    }

    public Pair<Long, ChildAssociationRef> getPair(QNameDAO qnameDAO) {
        return new Pair((Object)this.id, (Object)this.getRef(qnameDAO));
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public NodeEntity getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(NodeEntity parentNode) {
        this.parentNode = parentNode;
    }

    public NodeEntity getChildNode() {
        return this.childNode;
    }

    public void setChildNode(NodeEntity childNode) {
        this.childNode = childNode;
    }

    public boolean setTypeQNameAll(QNameDAO qnameDAO, QName typeQName, boolean forUpdate) {
        if (forUpdate) {
            this.typeQNameId = (Long)qnameDAO.getOrCreateQName(typeQName).getFirst();
            return true;
        }
        Pair<Long, QName> qnamePair = qnameDAO.getQName(typeQName);
        if (qnamePair == null) {
            return false;
        }
        this.typeQNameId = (Long)qnamePair.getFirst();
        return true;
    }

    public Long getTypeQNameId() {
        return this.typeQNameId;
    }

    public void setTypeQNameId(Long typeQNameId) {
        this.typeQNameId = typeQNameId;
    }

    public void setChildNodeNameAll(DictionaryService dictionaryService, QName typeQName, String childNodeName) {
        ParameterCheck.mandatory((String)"childNodeName", (Object)childNodeName);
        if (dictionaryService != null) {
            ParameterCheck.mandatory((String)"typeQName", (Object)typeQName);
            Pair<String, Long> childNameUnique = ChildAssocEntity.getChildNameUnique(dictionaryService, typeQName, childNodeName);
            this.childNodeName = (String)childNameUnique.getFirst();
            this.childNodeNameCrc = (Long)childNameUnique.getSecond();
        } else {
            String childNameNewLower = childNodeName.toLowerCase();
            this.childNodeName = ChildAssocEntity.getChildNodeNameShort(childNameNewLower);
            this.childNodeNameCrc = ChildAssocEntity.getChildNodeNameCrc(childNameNewLower);
        }
    }

    public Long getChildNodeNameCrc() {
        return this.childNodeNameCrc;
    }

    public void setChildNodeNameCrc(Long childNodeNameCrc) {
        this.childNodeNameCrc = childNodeNameCrc;
    }

    public String getChildNodeName() {
        return this.childNodeName;
    }

    public void setChildNodeName(String childNodeName) {
        this.childNodeName = childNodeName;
    }

    public boolean setQNameAll(QNameDAO qnameDAO, QName qname, boolean forUpdate) {
        String assocQNameNamespace = qname.getNamespaceURI();
        String assocQNameLocalName = qname.getLocalName();
        Long assocQNameNamespaceId = null;
        if (forUpdate) {
            assocQNameNamespaceId = (Long)qnameDAO.getOrCreateNamespace(assocQNameNamespace).getFirst();
        } else {
            Pair<Long, String> nsPair = qnameDAO.getNamespace(assocQNameNamespace);
            if (nsPair == null) {
                return false;
            }
            assocQNameNamespaceId = (Long)nsPair.getFirst();
        }
        Long assocQNameCrc = ChildAssocEntity.getQNameCrc(qname);
        this.qnameNamespaceId = assocQNameNamespaceId;
        this.qnameLocalName = assocQNameLocalName;
        this.qnameCrc = assocQNameCrc;
        return true;
    }

    public Long getQnameNamespaceId() {
        return this.qnameNamespaceId;
    }

    public void setQnameNamespaceId(Long qnameNamespaceId) {
        this.qnameNamespaceId = qnameNamespaceId;
    }

    public String getQnameLocalName() {
        return this.qnameLocalName;
    }

    public void setQnameLocalName(String qnameLocalName) {
        this.qnameLocalName = qnameLocalName;
    }

    public Long getQnameCrc() {
        return this.qnameCrc;
    }

    public void setQnameCrc(Long qnameCrc) {
        this.qnameCrc = qnameCrc;
    }

    public Boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public int getAssocIndex() {
        return this.assocIndex;
    }

    public void setAssocIndex(int assocIndex) {
        this.assocIndex = assocIndex;
    }

    public List<Long> getTypeQNameIds() {
        return this.typeQNameIds;
    }

    public void setTypeQNameIds(List<Long> typeQNameIds) {
        this.typeQNameIds = typeQNameIds;
    }

    public List<Long> getChildNodeNameCrcs() {
        return this.childNodeNameCrcs;
    }

    public void setChildNodeNameCrcs(List<Long> childNodeNameCrcs) {
        this.childNodeNameCrcs = childNodeNameCrcs;
    }

    public List<Long> getChildNodeTypeQNameIds() {
        return this.childNodeTypeQNameIds;
    }

    public void setChildNodeTypeQNameIds(List<Long> childNodeTypeQNameIds) {
        this.childNodeTypeQNameIds = childNodeTypeQNameIds;
    }

    public Boolean getSameStore() {
        return this.sameStore;
    }

    public void setSameStore(Boolean sameStore) {
        this.sameStore = sameStore;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }
}

