/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

public class NodeDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private NodeDAO nodeDAO;

    public void setUp() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMinRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(10);
        this.txnHelper.setMaxRetryWaitMs(50);
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
    }

    public void testTransaction() throws Throwable {
        final boolean[] newTxn = new boolean[]{false};
        RetryingTransactionHelper.RetryingTransactionCallback<Long> getTxnIdCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return NodeDAOTest.this.nodeDAO.getCurrentTransactionId(newTxn[0]);
            }
        };
        try {
            getTxnIdCallback.execute();
            NodeDAOTest.fail((String)"Should have failed when running outside of a transaction");
        }
        catch (Throwable e) {
            // empty catch block
        }
        NodeDAOTest.assertNull((String)"No Txn ID should be present in read-only txn", (Object)this.txnHelper.doInTransaction(getTxnIdCallback, true));
        Long txnId1 = this.txnHelper.doInTransaction(getTxnIdCallback);
        NodeDAOTest.assertNull((String)"No Txn ID should be present in untouched txn", (Object)txnId1);
        newTxn[0] = true;
        Long txnId2 = this.txnHelper.doInTransaction(getTxnIdCallback);
        NodeDAOTest.assertNotNull((String)"Txn ID should be present by forcing it", (Object)txnId2);
    }

    public void testGetNodesWithAspects() throws Throwable {
        NodeDAO.NodeRefQueryCallback callback = new NodeDAO.NodeRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, NodeRef> nodePair) {
                return false;
            }
        };
        this.nodeDAO.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_AUDITABLE), 1L, 1000L, callback);
    }

    public void testGetPrimaryChildAcls() throws Throwable {
        List<NodeIdAndAclId> acls = this.nodeDAO.getPrimaryChildrenAcls(1L);
        NodeDAOTest.assertNotNull((String)"Null list", acls);
    }

    public void testGetStoreId() throws Throwable {
        List<Pair<Long, StoreRef>> storePairs = this.nodeDAO.getStores();
        for (Pair<Long, StoreRef> storePair : storePairs) {
            StoreRef storeRef = (StoreRef)storePair.getSecond();
            Pair<Long, StoreRef> checkStorePair = this.nodeDAO.getStore(storeRef);
            NodeDAOTest.assertEquals((String)"Store pair did not match. ", storePair, checkStorePair);
        }
    }
}

