/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.solr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class NodeParametersEntity
extends NodeParameters {
    private List<Long> includeTypeIds;
    private List<Long> excludeTypeIds;
    private List<Long> includeAspectIds;
    private List<Long> excludeAspectIds;
    private Long originalIdPropQNameId;

    public NodeParametersEntity(QNameDAO qnameDAO) {
        Pair<Long, QName> qnamePair = qnameDAO.getQName(ContentModel.PROP_ORIGINAL_ID);
        this.setOriginalIdPropQNameId(qnamePair == null ? -1L : (Long)qnamePair.getFirst());
    }

    public NodeParametersEntity(NodeParameters params, QNameDAO qnameDAO) {
        this(qnameDAO);
        Set<Long> qnamesIds;
        this.setFromNodeId(params.getFromNodeId());
        this.setToNodeId(params.getToNodeId());
        this.setFromTxnId(params.getFromTxnId());
        this.setToTxnId(params.getToTxnId());
        this.setTransactionIds(params.getTransactionIds());
        this.setStoreIdentifier(params.getStoreIdentifier());
        this.setStoreProtocol(params.getStoreProtocol());
        if (params.getIncludeNodeTypes() != null) {
            qnamesIds = qnameDAO.convertQNamesToIds(params.getIncludeNodeTypes(), false);
            this.setIncludeTypeIds(new ArrayList<Long>(qnamesIds));
        }
        if (params.getExcludeNodeTypes() != null) {
            qnamesIds = qnameDAO.convertQNamesToIds(params.getExcludeNodeTypes(), false);
            this.setExcludeTypeIds(new ArrayList<Long>(qnamesIds));
        }
        if (params.getExcludeAspects() != null) {
            qnamesIds = qnameDAO.convertQNamesToIds(params.getExcludeAspects(), false);
            this.setExcludeAspectIds(new ArrayList<Long>(qnamesIds));
        }
        if (params.getIncludeAspects() != null) {
            qnamesIds = qnameDAO.convertQNamesToIds(params.getIncludeAspects(), false);
            this.setIncludeAspectIds(new ArrayList<Long>(qnamesIds));
        }
    }

    public void setOriginalIdPropQNameId(Long originalIdPropQNameId) {
        this.originalIdPropQNameId = originalIdPropQNameId;
    }

    public Long getOriginalIdPropQNameId() {
        return this.originalIdPropQNameId;
    }

    @Override
    public boolean getStoreFilter() {
        return this.getStoreProtocol() != null || this.getStoreIdentifier() != null;
    }

    public List<Long> getIncludeAspectIds() {
        return this.includeAspectIds;
    }

    public void setIncludeAspectIds(List<Long> includeAspectIds) {
        this.includeAspectIds = includeAspectIds;
    }

    public List<Long> getExcludeAspectIds() {
        return this.excludeAspectIds;
    }

    public void setExcludeAspectIds(List<Long> excludeAspectIds) {
        this.excludeAspectIds = excludeAspectIds;
    }

    public List<Long> getIncludeTypeIds() {
        return this.includeTypeIds;
    }

    public void setIncludeTypeIds(List<Long> includeTypeIds) {
        this.includeTypeIds = includeTypeIds;
    }

    public List<Long> getExcludeTypeIds() {
        return this.excludeTypeIds;
    }

    public void setExcludeTypeIds(List<Long> excludeTypeIds) {
        this.excludeTypeIds = excludeTypeIds;
    }

    public boolean isIncludeNodesTable() {
        return this.getFromNodeId() != null || this.getToNodeId() != null || this.getIncludeTypeIds() != null || this.getExcludeTypeIds() != null || this.getIncludeAspectIds() != null || this.getExcludeAspectIds() != null;
    }
}

