/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.subscriptions;

import junit.framework.TestCase;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.subscriptions.SubscriptionsDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.PagingSubscriptionResults;
import org.alfresco.service.cmr.subscriptions.SubscriptionItemTypeEnum;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class SubscriptionDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private PersonService personService;
    private SubscriptionsDAO subscriptionsDAO;

    protected NodeRef getUserNodeRef(final String userId) {
        final PersonService ps = this.personService;
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return ps.getPerson(userId);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void insert(final String userId, final NodeRef node) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                SubscriptionDAOTest.this.subscriptionsDAO.insertSubscription(userId, node);
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback, false, false);
    }

    protected void delete(final String userId, final NodeRef node) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                SubscriptionDAOTest.this.subscriptionsDAO.deleteSubscription(userId, node);
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback, false, false);
    }

    protected int count(final String userId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                return SubscriptionDAOTest.this.subscriptionsDAO.countSubscriptions(userId, SubscriptionItemTypeEnum.USER);
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    protected boolean hasSubscribed(final String userId, final NodeRef node) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return SubscriptionDAOTest.this.subscriptionsDAO.hasSubscribed(userId, node);
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    protected PagingSubscriptionResults select(final String userId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<PagingSubscriptionResults> callback = new RetryingTransactionHelper.RetryingTransactionCallback<PagingSubscriptionResults>(){

            @Override
            public PagingSubscriptionResults execute() throws Throwable {
                return SubscriptionDAOTest.this.subscriptionsDAO.selectSubscriptions(userId, SubscriptionItemTypeEnum.USER, new PagingRequest(100000, null));
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    protected int countFollowers(final String userId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                return SubscriptionDAOTest.this.subscriptionsDAO.countFollowers(userId);
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    protected PagingFollowingResults selectFollowing(final String userId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<PagingFollowingResults> callback = new RetryingTransactionHelper.RetryingTransactionCallback<PagingFollowingResults>(){

            @Override
            public PagingFollowingResults execute() throws Throwable {
                return SubscriptionDAOTest.this.subscriptionsDAO.selectFollowing(userId, new PagingRequest(100000, null));
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    protected PagingFollowingResults selectFollowers(final String userId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<PagingFollowingResults> callback = new RetryingTransactionHelper.RetryingTransactionCallback<PagingFollowingResults>(){

            @Override
            public PagingFollowingResults execute() throws Throwable {
                return SubscriptionDAOTest.this.subscriptionsDAO.selectFollowers(userId, new PagingRequest(100000, null));
            }
        };
        return this.txnHelper.doInTransaction(callback, false, false);
    }

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.personService = serviceRegistry.getPersonService();
        this.subscriptionsDAO = (SubscriptionsDAO)this.ctx.getBean("subscriptionsDAO");
    }

    public void testInsertAndDelete() throws Exception {
        String userId = "admin";
        String userId2 = "guest";
        NodeRef nodeRef = this.getUserNodeRef(userId2);
        if (this.hasSubscribed(userId, nodeRef)) {
            this.delete(userId, nodeRef);
        }
        boolean hasSubscribed = this.hasSubscribed(userId, nodeRef);
        SubscriptionDAOTest.assertFalse((boolean)hasSubscribed);
        int count = this.count(userId);
        SubscriptionDAOTest.assertTrue((count >= 0 ? 1 : 0) != 0);
        this.insert(userId, nodeRef);
        this.insert(userId, nodeRef);
        SubscriptionDAOTest.assertEquals((int)(count + 1), (int)this.count(userId));
        SubscriptionDAOTest.assertTrue((boolean)this.hasSubscribed(userId, nodeRef));
        PagingSubscriptionResults psr = this.select(userId);
        SubscriptionDAOTest.assertNotNull((Object)psr);
        SubscriptionDAOTest.assertNotNull((Object)psr.getPage());
        SubscriptionDAOTest.assertTrue((boolean)psr.getPage().contains(nodeRef));
        PagingFollowingResults following = this.selectFollowing(userId);
        SubscriptionDAOTest.assertNotNull((Object)following);
        SubscriptionDAOTest.assertNotNull((Object)following.getPage());
        SubscriptionDAOTest.assertTrue((boolean)following.getPage().contains(userId2));
        SubscriptionDAOTest.assertEquals((int)psr.getPage().size(), (int)following.getPage().size());
        int followerCount = this.countFollowers(userId2);
        SubscriptionDAOTest.assertTrue((followerCount >= 0 ? 1 : 0) != 0);
        PagingFollowingResults followers = this.selectFollowers(userId2);
        SubscriptionDAOTest.assertNotNull((Object)followers);
        SubscriptionDAOTest.assertNotNull((Object)followers.getPage());
        SubscriptionDAOTest.assertTrue((boolean)followers.getPage().contains(userId));
        this.delete(userId, nodeRef);
        SubscriptionDAOTest.assertEquals((int)count, (int)this.count(userId));
        SubscriptionDAOTest.assertFalse((boolean)this.hasSubscribed(userId, nodeRef));
    }
}

