/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.tenant;

import java.io.Serializable;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.domain.tenant.TenantUpdateEntity;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class AbstractTenantAdminDAOImpl
implements TenantAdminDAO {
    private final TenantEntityCallbackDAO tenantEntityDaoCallback = new TenantEntityCallbackDAO();
    private EntityLookupCache<String, TenantEntity, Serializable> tenantEntityCache = new EntityLookupCache<String, TenantEntity, Serializable>(this.tenantEntityDaoCallback);

    public void setTenantEntityCache(SimpleCache<Serializable, Object> tenantEntityCache) {
        this.tenantEntityCache = new EntityLookupCache<String, TenantEntity, Serializable>(tenantEntityCache, this.tenantEntityDaoCallback);
    }

    @Override
    public TenantEntity createTenant(TenantEntity entity) {
        ParameterCheck.mandatory((String)"entity", (Object)entity);
        ParameterCheck.mandatoryString((String)"entity.tenantDomain", (String)entity.getTenantDomain());
        if (entity.getEnabled() == null) {
            entity.setEnabled(true);
        }
        entity.setTenantDomain(entity.getTenantDomain().toLowerCase());
        entity.setVersion(0L);
        Pair<String, TenantEntity> entityPair = this.tenantEntityCache.getOrCreateByValue(entity);
        return (TenantEntity)entityPair.getSecond();
    }

    @Override
    public TenantEntity getTenant(String tenantDomain) {
        return this.getTenantImpl(tenantDomain);
    }

    private TenantEntity getTenantImpl(String tenantDomain) {
        Pair<String, TenantEntity> entityPair = this.tenantEntityCache.getByKey(tenantDomain);
        if (entityPair == null && (entityPair = this.tenantEntityCache.getByKey(tenantDomain.toLowerCase())) == null) {
            return null;
        }
        return (TenantEntity)entityPair.getSecond();
    }

    @Override
    public List<TenantEntity> listTenants() {
        return this.getTenantEntities();
    }

    @Override
    public TenantUpdateEntity getTenantForUpdate(String tenantDomain) {
        TenantEntity entity = this.getTenantImpl(tenantDomain);
        if (entity == null) {
            return null;
        }
        TenantUpdateEntity updateEntity = new TenantUpdateEntity(entity.getTenantDomain());
        updateEntity.setVersion(entity.getVersion());
        updateEntity.setEnabled(entity.getEnabled());
        updateEntity.setContentRoot(entity.getContentRoot());
        updateEntity.setDbUrl(entity.getDbUrl());
        updateEntity.setTenantName(entity.getTenantName());
        return updateEntity;
    }

    @Override
    public void updateTenant(TenantUpdateEntity entity) {
        ParameterCheck.mandatory((String)"entity", (Object)entity);
        ParameterCheck.mandatory((String)"entity.version", (Object)entity.getVersion());
        ParameterCheck.mandatoryString((String)"entity.tenantDomain", (String)entity.getTenantDomain());
        int updated = this.tenantEntityCache.updateValue(entity.getTenantDomain(), entity);
        if (updated < 1) {
            throw new ConcurrencyFailureException("TenantEntity " + entity.getTenantDomain() + " no longer exists or has been updated concurrently");
        }
    }

    @Override
    public void deleteTenant(String tenantDomain) {
        ParameterCheck.mandatoryString((String)"tenantDomain", (String)tenantDomain);
        tenantDomain = tenantDomain.toLowerCase();
        int deleted = this.tenantEntityCache.deleteByKey(tenantDomain);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("TenantEntity " + tenantDomain + " no longer exists");
        }
    }

    protected abstract TenantEntity createTenantEntity(TenantEntity var1);

    protected abstract TenantEntity getTenantEntity(String var1);

    protected abstract List<TenantEntity> getTenantEntities();

    protected abstract int updateTenantEntity(TenantEntity var1);

    protected abstract int deleteTenantEntity(String var1);

    private class TenantEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<String, TenantEntity, Serializable> {
        private TenantEntityCallbackDAO() {
        }

        private final Pair<String, TenantEntity> convertEntityToPair(TenantEntity entity) {
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getTenantDomain(), (Object)entity);
        }

        @Override
        public Serializable getValueKey(TenantEntity value) {
            return null;
        }

        @Override
        public Pair<String, TenantEntity> createValue(TenantEntity value) {
            TenantEntity entity = AbstractTenantAdminDAOImpl.this.createTenantEntity(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<String, TenantEntity> findByKey(String key) {
            TenantEntity entity = AbstractTenantAdminDAOImpl.this.getTenantEntity(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<String, TenantEntity> findByValue(TenantEntity value) {
            if (value == null || value.getTenantDomain() == null) {
                throw new AlfrescoRuntimeException("Unexpected: TenantEntity / tenantDomain must not be null");
            }
            return this.convertEntityToPair(AbstractTenantAdminDAOImpl.this.getTenantEntity(value.getTenantDomain()));
        }

        @Override
        public int updateValue(String tenantDomain, TenantEntity value) {
            return AbstractTenantAdminDAOImpl.this.updateTenantEntity(value);
        }

        @Override
        public int deleteByKey(String tenantDomain) {
            return AbstractTenantAdminDAOImpl.this.deleteTenantEntity(tenantDomain);
        }

        @Override
        public int deleteByValue(TenantEntity value) {
            throw new UnsupportedOperationException("deleteByValue");
        }
    }
}

